/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.tracker;

import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;
import pregenerator.base.mixins.common.chunk.ChunkHolderMixin;
import pregenerator.base.mixins.common.storage.ChunkManagerMixin;

public class TypeEntry {
    ResourceLocation location;
    int count;

    public TypeEntry(ResourceLocation location, int count) {
        this.location = location;
        this.count = count;
    }

    public int getCount() {
        return this.count;
    }

    public ResourceLocation getLocation() {
        return this.location;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130085_(this.location);
        buffer.m_130130_(this.count);
    }

    public static TypeEntry read(FriendlyByteBuf buffer) {
        ResourceLocation location = buffer.m_130281_();
        int count = buffer.m_130242_();
        return new TypeEntry(location, count);
    }

    public static List<TypeEntry> toList(Object2IntMap<ResourceLocation> locations) {
        ObjectArrayList list = new ObjectArrayList();
        for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(locations)) {
            list.add(new TypeEntry((ResourceLocation)entry.getKey(), entry.getIntValue()));
        }
        return list;
    }

    public static List<TypeEntry> createTileEntity(ServerLevel world) {
        Object2IntLinkedOpenHashMap tiles = new Object2IntLinkedOpenHashMap();
        TypeEntry.getBlockEntities(world, T -> tiles.addTo((Object)BlockEntityType.m_58954_((BlockEntityType)T.m_58903_()), 1));
        return TypeEntry.toList((Object2IntMap<ResourceLocation>)tiles);
    }

    public static void getBlockEntities(ServerLevel world, Consumer<BlockEntity> result) {
        ServerChunkCache cache = world.m_7726_();
        for (ChunkHolder holder : ((ChunkManagerMixin)cache.f_8325_).getLoadedChunks()) {
            ChunkHolderMixin mixin = (ChunkHolderMixin)holder;
            LevelChunk chunk = mixin.getLoadingChunk();
            if (chunk == null) {
                ChunkAccess testChunk;
                Either either = holder.m_140080_(ChunkStatus.f_62326_).getNow(null);
                if (either == null || !((testChunk = (ChunkAccess)either.left().orElse(null)) instanceof LevelChunk)) continue;
                chunk = (LevelChunk)testChunk;
            }
            chunk.m_62954_().values().forEach(result);
        }
    }

    public static List<TypeEntry> createEntities(ServerLevel world) {
        Object2IntLinkedOpenHashMap tiles = new Object2IntLinkedOpenHashMap();
        world.m_142646_().m_142273_().forEach(T -> {
            if (T instanceof Player) {
                return;
            }
            tiles.addTo((Object)EntityType.m_20613_((EntityType)T.m_6095_()), 1);
        });
        return TypeEntry.toList((Object2IntMap<ResourceLocation>)tiles);
    }

    public static List<TypeEntry> createChunkTileEntity(LevelChunk chunk) {
        Object2IntLinkedOpenHashMap tiles = new Object2IntLinkedOpenHashMap();
        for (BlockEntity entity : chunk.m_62954_().values()) {
            tiles.addTo((Object)BlockEntityType.m_58954_((BlockEntityType)entity.m_58903_()), 1);
        }
        return TypeEntry.toList((Object2IntMap<ResourceLocation>)tiles);
    }

    public static List<TypeEntry> createChunkEntities(LevelChunk chunk) {
        Object2IntLinkedOpenHashMap tiles = new Object2IntLinkedOpenHashMap();
        ChunkPos pos = chunk.m_7697_();
        AABB box = new AABB((double)(pos.f_45578_ * 16), (double)chunk.m_62953_().m_141937_(), (double)(pos.f_45579_ * 16), (double)(pos.f_45578_ * 16 + 16), (double)chunk.m_62953_().m_151558_(), (double)(pos.f_45579_ * 16 + 16));
        ((ServerLevel)chunk.m_62953_()).m_142646_().m_142232_(box, T -> tiles.addTo((Object)EntityType.m_20613_((EntityType)T.m_6095_()), 1));
        tiles.removeInt((Object)EntityType.m_20613_((EntityType)EntityType.f_20532_));
        return TypeEntry.toList((Object2IntMap<ResourceLocation>)tiles);
    }

    public static List<TypeEntry> createChunkBiomes(LevelChunk chunks) {
        Object2IntLinkedOpenHashMap tiles = new Object2IntLinkedOpenHashMap();
        for (LevelChunkSection section : chunks.m_7103_()) {
            section.m_187996_().m_63099_((K, T) -> tiles.addTo((Object)TypeEntry.fromBiome((Holder<Biome>)K), T));
        }
        return TypeEntry.toList((Object2IntMap<ResourceLocation>)tiles);
    }

    private static ResourceLocation fromBiome(Holder<Biome> holder) {
        if (holder instanceof Holder.Reference) {
            Holder.Reference biome = (Holder.Reference)holder;
            return biome.m_205785_().m_135782_();
        }
        return ForgeRegistries.BIOMES.getKey((Object)((Biome)holder.m_203334_()));
    }
}

