/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.utils.config;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Strings;
import pregenerator.common.utils.config.FileSystemWatcher;

public abstract class ConfigEntry<T> {
    private String key;
    private T value;
    private T defaultValue;
    private T lastValue;
    private String[] comment;
    private boolean used = false;
    private boolean sync = false;
    private boolean worldReload = false;
    private boolean gameReload = false;
    protected static final int STR_BUFFER_LEN = Short.MAX_VALUE;

    public ConfigEntry(String key, T defaultValue, String ... comment) {
        if (FileSystemWatcher.check(key)) {
            throw new IllegalArgumentException("ConfigEntry key must not be null, empty or start/end with white spaces");
        }
        if (key.contains(":") || key.contains("=")) {
            throw new IllegalArgumentException("ConfigEntry key must not contain any ':' or '=' signs. Key: " + key);
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException("ConfigEntry default value must not be null. Key: " + key);
        }
        this.key = key;
        this.value = defaultValue;
        this.defaultValue = defaultValue;
        this.comment = this.validateComments(comment);
    }

    private String[] validateComments(String[] inputs) {
        if (inputs == null) {
            return null;
        }
        for (int i = 0; i < inputs.length; ++i) {
            if (inputs[i] != null) continue;
            inputs[i] = "";
        }
        return inputs;
    }

    public String[] getComment() {
        return this.comment;
    }

    public ConfigEntry<T> setComment(String ... comment) {
        this.comment = this.validateComments(comment);
        return this;
    }

    public T getValue() {
        return this.value;
    }

    public T getDefault() {
        return this.defaultValue;
    }

    public boolean canSet(T value) {
        return true;
    }

    public ConfigEntry<T> set(T value) {
        if (value != null) {
            if (this.sync) {
                this.lastValue = this.value;
            }
            this.value = value;
        }
        return this;
    }

    public String getKey() {
        return this.key;
    }

    final boolean isUsed() {
        return this.used;
    }

    final ConfigEntry<T> setUsed() {
        this.used = true;
        return this;
    }

    public final boolean hasChanged() {
        return this.used && (this.value.getClass().isArray() ? !Objects.deepEquals(this.lastValue, this.value) : !Objects.equals(this.lastValue, this.value));
    }

    public final boolean needsWorldReload() {
        return this.worldReload;
    }

    public final boolean needsGameReload() {
        return this.gameReload;
    }

    public final void onSynced() {
        this.lastValue = this.value;
    }

    final boolean isSynced() {
        return this.sync;
    }

    public final <S extends ConfigEntry<T>> S setSynced() {
        this.sync = true;
        return (S)this;
    }

    public final <S extends ConfigEntry<T>> S setWorldReload() {
        this.worldReload = true;
        return (S)this;
    }

    public final <S extends ConfigEntry<T>> S setGameRestart() {
        this.gameReload = true;
        return (S)this;
    }

    public ConfigEntry<T> setKey(String key) {
        if (FileSystemWatcher.check(key)) {
            throw new IllegalArgumentException("ConfigEntry key must not be null, empty or start/end with white spaces");
        }
        if (key.contains(":") || key.contains("=")) {
            throw new IllegalArgumentException("ConfigEntry key must not contain any ':' or '=' signs. Key: " + key);
        }
        this.key = key;
        return this;
    }

    public abstract char getPrefix();

    public abstract void parseValue(String var1);

    public void resetDefault() {
        this.value = this.defaultValue;
    }

    protected String serializedValue() {
        return String.valueOf(this.value);
    }

    public abstract String getLimitations();

    public String serialize(int indentationLevel) {
        String limits;
        String indentation = "\n" + StringUtils.repeat((char)' ', (int)(indentationLevel * 2));
        StringBuilder builder = new StringBuilder();
        if (this.comment != null) {
            builder.append('\n');
            for (int i = 0; i < this.comment.length; ++i) {
                builder.append(indentation);
                builder.append("# ");
                builder.append(this.comment[i].replaceAll("\\R", indentation + "# "));
            }
        }
        if (!Strings.isBlank((String)(limits = this.getLimitations()))) {
            builder.append(indentation);
            builder.append("#").append('\u200b').append(" ");
            builder.append(limits);
        }
        builder.append(indentation);
        builder.append(this.getPrefix());
        builder.append(':');
        builder.append(this.key);
        builder.append('=');
        builder.append(this.serializedValue());
        return builder.toString();
    }

    public abstract void serialize(FriendlyByteBuf var1);

    public abstract void deserialize(FriendlyByteBuf var1);

    public static class EnumValue<E extends Enum<E>>
    extends ConfigEntry<E> {
        private Class<E> enumClass;

        public EnumValue(String key, E defaultValue, Class<E> enumClass, String ... comment) {
            super(key, defaultValue, comment);
            this.enumClass = enumClass;
        }

        public EnumValue(String key, E defaultValue, Class<E> enumClass) {
            super(key, defaultValue, new String[0]);
            this.enumClass = enumClass;
        }

        @Override
        public char getPrefix() {
            return 'E';
        }

        @Override
        public boolean canSet(E value) {
            return this.enumClass.isInstance(value);
        }

        public E get() {
            return (E)((Enum)this.getValue());
        }

        @Override
        public String getLimitations() {
            return "Must be one of " + Arrays.toString(this.enumClass.getEnumConstants());
        }

        @Override
        public void parseValue(String value) {
            this.set(Enum.valueOf(this.enumClass, value));
        }

        @Override
        public void serialize(FriendlyByteBuf buffer) {
            buffer.m_130068_(this.get());
        }

        @Override
        public void deserialize(FriendlyByteBuf buffer) {
            this.set(buffer.m_130066_(this.enumClass));
        }
    }

    public static class ArrayValue
    extends ConfigEntry<String[]>
    implements IArrayConfig {
        public ArrayValue(String key, String[] defaultValue, String ... comment) {
            super(key, defaultValue, comment);
        }

        public ArrayValue(String key, String[] defaultValue) {
            super(key, defaultValue, new String[0]);
        }

        public ArrayValue(String key, String comment) {
            super(key, new String[0], comment);
        }

        public ArrayValue(String key) {
            super(key, new String[0], new String[0]);
        }

        @Override
        public char getPrefix() {
            return 'A';
        }

        public String[] get() {
            return (String[])this.getValue();
        }

        @Override
        public String getLimitations() {
            return "";
        }

        @Override
        public List<String> getEntries() {
            return new ObjectArrayList((Object[])((String[])this.getValue()));
        }

        @Override
        public List<String> getDefaults() {
            return ObjectArrayList.wrap((Object[])((String[])this.getValue()));
        }

        @Override
        public boolean canSet(List<String> entries) {
            return true;
        }

        @Override
        public void set(List<String> entries) {
            this.set((String[])entries.toArray(String[]::new));
        }

        @Override
        public void parseValue(String value) {
            this.set(value.isEmpty() ? new String[]{} : value.split(","));
        }

        @Override
        protected String serializedValue() {
            StringJoiner joiner = new StringJoiner(",");
            for (String s : this.get()) {
                joiner.add(s);
            }
            return joiner.toString();
        }

        public static ArrayValue parse(String key, String value, String ... comment) {
            return new ArrayValue(key, value.isEmpty() ? new String[]{} : value.split(","), comment);
        }

        @Override
        public void serialize(FriendlyByteBuf buffer) {
            buffer.m_130130_(this.get().length);
            for (String val : this.get()) {
                buffer.m_130072_(val, Short.MAX_VALUE);
            }
        }

        @Override
        public void deserialize(FriendlyByteBuf buffer) {
            String[] val = new String[buffer.m_130242_()];
            for (int i = 0; i < val.length; ++i) {
                val[i] = buffer.m_130136_(Short.MAX_VALUE);
            }
            this.set(val);
        }
    }

    public static class StringValue
    extends ConfigEntry<String> {
        public StringValue(String key, String defaultValue, String ... comment) {
            super(key, defaultValue, comment);
        }

        public StringValue(String key, String defaultValue) {
            super(key, defaultValue, new String[0]);
        }

        @Override
        public char getPrefix() {
            return 'S';
        }

        public String get() {
            return (String)this.getValue();
        }

        @Override
        public String getLimitations() {
            return "";
        }

        @Override
        public void parseValue(String value) {
            this.set(value);
        }

        public static StringValue parse(String key, String value, String ... comment) {
            return new StringValue(key, value, comment);
        }

        @Override
        public void serialize(FriendlyByteBuf buffer) {
            buffer.m_130072_(this.get(), Short.MAX_VALUE);
        }

        @Override
        public void deserialize(FriendlyByteBuf buffer) {
            this.set(buffer.m_130136_(Short.MAX_VALUE));
        }
    }

    public static class BoolValue
    extends ConfigEntry<Boolean> {
        public BoolValue(String key, Boolean defaultValue, String ... comment) {
            super(key, defaultValue, comment);
        }

        public BoolValue(String key, Boolean defaultValue) {
            super(key, defaultValue, new String[0]);
        }

        public boolean get() {
            return (Boolean)this.getValue();
        }

        @Override
        public char getPrefix() {
            return 'B';
        }

        @Override
        public String getLimitations() {
            return "";
        }

        @Override
        public void parseValue(String value) {
            this.set(Boolean.parseBoolean(value));
        }

        public static BoolValue parse(String key, String value, String ... comment) {
            return new BoolValue(key, Boolean.parseBoolean(value), comment);
        }

        @Override
        public void serialize(FriendlyByteBuf buffer) {
            buffer.writeBoolean(this.get());
        }

        @Override
        public void deserialize(FriendlyByteBuf buffer) {
            this.set(buffer.readBoolean());
        }
    }

    public static class DoubleValue
    extends ConfigEntry<Double> {
        private double min = Double.MIN_VALUE;
        private double max = Double.MAX_VALUE;

        public DoubleValue(String key, Double defaultValue, String ... comment) {
            super(key, defaultValue, comment);
        }

        public DoubleValue(String key, Double defaultValue) {
            super(key, defaultValue, new String[0]);
        }

        public DoubleValue setMin(double min) {
            this.min = min;
            return this;
        }

        public DoubleValue setMax(double max) {
            this.max = max;
            return this;
        }

        public DoubleValue setRange(double min, double max) {
            this.min = min;
            this.max = max;
            return this;
        }

        @Override
        public boolean canSet(Double value) {
            return value >= this.min && value <= this.max;
        }

        public DoubleValue set(Double value) {
            super.set(Mth.m_14008_((double)value, (double)this.min, (double)this.max));
            return this;
        }

        @Override
        public char getPrefix() {
            return 'D';
        }

        public double get() {
            return (Double)this.getValue();
        }

        @Override
        public String getLimitations() {
            if (this.min == Double.MIN_VALUE) {
                if (this.max == Double.MAX_VALUE) {
                    return "";
                }
                return "Range: > " + this.max;
            }
            if (this.max == Double.MIN_VALUE) {
                if (this.min == Double.MAX_VALUE) {
                    return "";
                }
                return "Range: < " + this.min;
            }
            return "Range: " + this.min + " ~ " + this.max;
        }

        @Override
        public void parseValue(String value) {
            this.set(Double.parseDouble(value));
        }

        public static DoubleValue parse(String key, String value, String ... comment) {
            return new DoubleValue(key, Double.parseDouble(value), comment);
        }

        @Override
        public void serialize(FriendlyByteBuf buffer) {
            buffer.writeDouble(this.get());
        }

        @Override
        public void deserialize(FriendlyByteBuf buffer) {
            this.set(buffer.readDouble());
        }
    }

    public static class IntValue
    extends ConfigEntry<Integer> {
        private int min = Integer.MIN_VALUE;
        private int max = Integer.MAX_VALUE;

        public IntValue(String key, Integer defaultValue, String ... comment) {
            super(key, defaultValue, comment);
        }

        public IntValue(String key, Integer defaultValue) {
            super(key, defaultValue, new String[0]);
        }

        public IntValue setMin(int min) {
            this.min = min;
            return this;
        }

        public IntValue setMax(int max) {
            this.max = max;
            return this;
        }

        public IntValue setRange(int min, int max) {
            this.min = min;
            this.max = max;
            return this;
        }

        public IntValue set(Integer value) {
            super.set(Mth.m_14045_((int)value, (int)this.min, (int)this.max));
            return this;
        }

        @Override
        public boolean canSet(Integer value) {
            return value >= this.min && value <= this.max;
        }

        @Override
        public String getLimitations() {
            if (this.min == Integer.MIN_VALUE) {
                if (this.max == Integer.MAX_VALUE) {
                    return "";
                }
                return "Range: > " + this.max;
            }
            if (this.max == Integer.MIN_VALUE) {
                if (this.min == Integer.MAX_VALUE) {
                    return "";
                }
                return "Range: < " + this.min;
            }
            return "Range: " + this.min + " ~ " + this.max;
        }

        @Override
        public char getPrefix() {
            return 'I';
        }

        public int get() {
            return (Integer)this.getValue();
        }

        @Override
        public void parseValue(String value) {
            this.set(Integer.parseInt(value));
        }

        public static IntValue parse(String key, String value, String ... comment) {
            return new IntValue(key, Integer.parseInt(value), comment);
        }

        @Override
        public void serialize(FriendlyByteBuf buffer) {
            buffer.writeInt(this.get());
        }

        @Override
        public void deserialize(FriendlyByteBuf buffer) {
            this.set(buffer.readInt());
        }
    }

    public static interface IArrayConfig {
        public List<String> getEntries();

        public List<String> getDefaults();

        public boolean canSet(List<String> var1);

        public void set(List<String> var1);
    }
}

