/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.utils.config;

import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.minecraftforge.fml.loading.FMLPaths;
import pregenerator.ChunkPregenerator;
import pregenerator.common.utils.config.Config;
import pregenerator.common.utils.config.ConfigEntry;
import pregenerator.common.utils.config.ConfigSection;

public class ConfigHandler {
    private final Path cfgDir;
    private final Path configFile;
    private final Config config;
    private final boolean useFileWatcher;
    private List<Runnable> loadedListeners = new ObjectArrayList();
    private Char2ObjectMap<IConfigParser> parsers = new Char2ObjectOpenHashMap();

    public ConfigHandler(String basePath, Config config, boolean useAutoReload) {
        this.config = config;
        this.useFileWatcher = useAutoReload;
        this.cfgDir = !basePath.isEmpty() ? FMLPaths.CONFIGDIR.get().resolve(basePath) : FMLPaths.CONFIGDIR.get();
        this.configFile = this.cfgDir.resolve(config.getName().concat(".cfg"));
        this.parsers.put('I', ConfigEntry.IntValue::parse);
        this.parsers.put('D', ConfigEntry.DoubleValue::parse);
        this.parsers.put('B', ConfigEntry.BoolValue::parse);
        this.parsers.put('S', ConfigEntry.StringValue::parse);
        this.parsers.put('A', ConfigEntry.ArrayValue::parse);
        this.parsers.put('E', ConfigEntry.StringValue::parse);
    }

    public void setAutoSync() {
        if (!this.useFileWatcher) {
            ChunkPregenerator.FILE_WATCHER.registerSyncHandler(this);
        }
    }

    public ConfigHandler addParser(char id, IConfigParser parser) {
        this.parsers.putIfAbsent(id, (Object)parser);
        return this;
    }

    public Config getConfig() {
        return this.config;
    }

    public void init() {
        try {
            if (Files.notExists(this.cfgDir, new LinkOption[0])) {
                Files.createDirectories(this.cfgDir, new FileAttribute[0]);
            }
            if (Files.notExists(this.configFile, new LinkOption[0])) {
                Files.createFile(this.configFile, new FileAttribute[0]);
                this.save();
            } else {
                this.load();
                this.save();
            }
            if (this.useFileWatcher) {
                ChunkPregenerator.FILE_WATCHER.registerConfigHandler(this.configFile, this, this.config.getName());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addLoadedListener(Runnable listener) {
        this.loadedListeners.add(listener);
    }

    public void onSynced() {
        for (Runnable r : this.loadedListeners) {
            r.run();
        }
    }

    private void handleEntry(ConfigSection currentSection, String line, String[] comment) {
        if (currentSection == null) {
            ChunkPregenerator.LOGGER.error("config entry not in section: {}", (Object)line);
            return;
        }
        String[] entryData = line.split("[:=]", 3);
        if (entryData.length != 3) {
            ChunkPregenerator.LOGGER.error("invalid config entry: {}", (Object)line);
            return;
        }
        ConfigEntry<?> entry = currentSection.getEntry(entryData[1]);
        boolean skip = false;
        if (entry == null) {
            IConfigParser parser = (IConfigParser)this.parsers.get(line.charAt(0));
            if (parser == null) {
                ChunkPregenerator.LOGGER.error("config entry is not registered and no parser found: {}", (Object)line);
                return;
            }
            try {
                entry = parser.parse(entryData[1], entryData[2], comment);
                if (entry == null) {
                    ChunkPregenerator.LOGGER.error("config entry was able to be parsed: {}", (Object)line);
                    return;
                }
                skip = true;
                currentSection.addParsed(entry);
            }
            catch (ClassCastException e) {
                ChunkPregenerator.LOGGER.fatal("config entry has wrong type: {}", (Object)line);
            }
            catch (NumberFormatException e) {
                ChunkPregenerator.LOGGER.fatal("config value is not a valid number: {}", (Object)line);
            }
        }
        if (skip) {
            return;
        }
        entry.setComment(comment);
        try {
            if (line.charAt(0) == entry.getPrefix()) {
                entry.parseValue(entryData[2]);
            } else {
                ChunkPregenerator.LOGGER.fatal("config entry has wrong type: {}", (Object)line);
            }
        }
        catch (ClassCastException e) {
            ChunkPregenerator.LOGGER.fatal("config entry has wrong type: {}", (Object)line);
        }
        catch (NumberFormatException e) {
            ChunkPregenerator.LOGGER.fatal("config value is not a valid number: {}", (Object)line);
        }
    }

    public void load() {
        try {
            List<String> lines = Files.readAllLines(this.configFile);
            ConfigSection currentSection = null;
            ObjectArrayList comments = new ObjectArrayList();
            for (String line : lines) {
                if ((line = line.trim()).length() == 0) continue;
                switch (line.charAt(0)) {
                    case '[': {
                        currentSection = this.config.getSectionRecursive(line.substring(1, line.length() - 1).split("\\."));
                        comments.clear();
                        break;
                    }
                    case '#': {
                        if (line.charAt(1) == '\u200b') break;
                        comments.add(line.substring(1).trim());
                        break;
                    }
                    default: {
                        this.handleEntry(currentSection, line, (String[])comments.toArray(String[]::new));
                        comments.clear();
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (Runnable r : this.loadedListeners) {
            r.run();
        }
    }

    public void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(this.configFile, new OpenOption[0]);){
            writer.write(this.config.serialize());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @FunctionalInterface
    public static interface IConfigParser {
        public ConfigEntry<?> parse(String var1, String var2, String ... var3);
    }
}

