/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.utils.config;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Map;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.server.ServerLifecycleHooks;
import pregenerator.ChunkPregenerator;
import pregenerator.common.networking.NetworkManager;
import pregenerator.common.utils.config.ConfigHandler;
import pregenerator.common.utils.config.IConfiguredHelper;
import pregenerator.common.utils.config.networking.SyncConfigPacket;

public class FileSystemWatcher {
    private final WatchService watchService;
    private Map<String, ConfigHandler> configsByName;
    private Map<Path, ConfigHandler> configs;
    private Map<WatchKey, Path> folders;
    private IConfiguredHelper helper = IConfiguredHelper.DUMMY;

    public FileSystemWatcher() {
        WatchService tmp;
        try {
            tmp = FileSystems.getDefault().newWatchService();
        }
        catch (IOException e) {
            tmp = null;
            ChunkPregenerator.LOGGER.fatal("WatchService could not be created");
            ChunkPregenerator.LOGGER.fatal((Object)e);
        }
        this.watchService = tmp;
        this.configsByName = new Object2ObjectLinkedOpenHashMap();
        this.configs = new Object2ObjectLinkedOpenHashMap();
        this.folders = new Object2ObjectLinkedOpenHashMap();
    }

    public void setConfiguredHelper(IConfiguredHelper helper) {
        this.helper = helper;
    }

    public void registerSyncHandler(ConfigHandler handler) {
        this.configsByName.put(handler.getConfig().getName(), handler);
    }

    public void registerConfigHandler(Path configFile, ConfigHandler handler, String name) {
        Path relative = FMLPaths.CONFIGDIR.get().relativize(configFile);
        this.configs.putIfAbsent(relative, handler);
        this.configsByName.put(handler.getConfig().getName(), handler);
        if (!this.folders.containsValue(relative.getParent())) {
            try {
                this.folders.put(configFile.getParent().register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY), relative.getParent());
            }
            catch (IOException e) {
                ChunkPregenerator.LOGGER.fatal("could not register WatchService for directory {}", (Object)configFile.getParent());
            }
        }
        this.helper.registerConfig(handler, name);
    }

    public ConfigHandler getConfig(String name) {
        return this.configsByName.get(name);
    }

    private void processFileSystemEvents() {
        WatchKey key;
        if (this.watchService != null && (key = this.watchService.poll()) != null) {
            for (WatchEvent<?> event : key.pollEvents()) {
                SyncConfigPacket packet;
                ConfigHandler handler = this.configs.get(this.folders.get(key).resolve(((Path)event.context()).getFileName()));
                if (handler == null) continue;
                handler.load();
                if (!this.configsByName.containsKey(handler.getConfig().getName()) || ServerLifecycleHooks.getCurrentServer() == null || (packet = SyncConfigPacket.create(handler.getConfig(), false)) == null) continue;
                NetworkManager.INSTANCE.sendToAllPlayers(packet);
            }
            key.reset();
        }
    }

    @SubscribeEvent
    public void onPlayerJoinEvent(OnDatapackSyncEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        this.syncConfigToPlayer((Player)event.getPlayer());
    }

    public void syncConfigToPlayer(Player player) {
        for (ConfigHandler handler : this.configsByName.values()) {
            SyncConfigPacket packet = SyncConfigPacket.create(handler.getConfig(), true);
            if (packet == null) continue;
            NetworkManager.INSTANCE.sendToPlayer(packet, player);
        }
    }

    @SubscribeEvent
    public void onLocalServerStarted(ServerStartedEvent event) {
        if (!event.getServer().m_6982_()) {
            for (ConfigHandler handler : this.configsByName.values()) {
                handler.load();
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.processFileSystemEvents();
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.processFileSystemEvents();
        }
    }

    public static boolean check(CharSequence s) {
        return s == null || s.length() == 0 || s.charAt(0) <= ' ' || s.charAt(s.length() - 1) <= ' ';
    }
}

