/*
 * Decompiled with CFR 0.152.
 */
package pregenerator.common.utils.misc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.StringJoiner;
import java.util.function.Consumer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RunConfigFixer {
    public static void main(String ... args) {
        String folder = args[0];
        System.out.println("Folder: " + folder);
        String file = args[1];
        System.out.println("File: " + file);
        try {
            Path path;
            Path folderPath = Paths.get(folder, new String[0]);
            for (Path path2 : RunConfigFixer.wrap(Files.newDirectoryStream(folderPath).iterator())) {
                if (!path2.getFileName().toString().endsWith(".launch")) continue;
                RunConfigFixer.insertConfig(path2, file, "org.eclipse.jdt.launching.VM_ARGUMENTS", "key");
            }
            if (Files.exists(folderPath = folderPath.resolve(".idea").resolve("runConfigurations"), new LinkOption[0])) {
                for (Path path2 : RunConfigFixer.wrap(Files.newDirectoryStream(folderPath).iterator())) {
                    if (!path2.getFileName().toString().endsWith(".xml")) continue;
                    RunConfigFixer.insertConfig(path2, file, "VM_PARAMETERS", "name");
                }
            }
            if (Files.exists(path = Paths.get(folder, new String[0]).resolve(".vscode").resolve("launch.json"), new LinkOption[0])) {
                RunConfigFixer.insertJsonConfig(path, file);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Iterable<Path> wrap(Iterator<Path> iter) {
        return () -> iter;
    }

    private static void insertConfig(Path path, String filePath, String arg, String key) throws IOException, SAXException, ParserConfigurationException, TransformerConfigurationException, TransformerException {
        boolean[] result = new boolean[1];
        Document doc = DocumentBuilderFactory.newDefaultInstance().newDocumentBuilder().parse(Files.newInputStream(path, new OpenOption[0]));
        RunConfigFixer.findNode(doc.getChildNodes(), arg, key, T -> {
            Node valueNode = T.getAttributes().getNamedItem("value");
            ObjectArrayList parameters = new ObjectArrayList((Object[])valueNode.getNodeValue().split(" "));
            int index = parameters.indexOf("-p");
            if (index == -1) {
                return;
            }
            String args = (String)parameters.get(index + 1);
            if (args.contains(filePath)) {
                return;
            }
            parameters.set(index + 1, args + File.pathSeparator + filePath);
            StringJoiner joiner = new StringJoiner(" ");
            parameters.forEach(joiner::add);
            valueNode.setNodeValue(joiner.toString());
            result[0] = true;
            System.out.println("Fixed: " + path.toString());
        });
        if (result[0]) {
            try (OutputStream stream = Files.newOutputStream(path, new OpenOption[0]);){
                TransformerFactory.newDefaultInstance().newTransformer().transform(new DOMSource(doc), new StreamResult(stream));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void findNode(NodeList list, String finder, String key, Consumer<Node> result) {
        int m = list.getLength();
        for (int i = 0; i < m; ++i) {
            Node subNode;
            Node node = list.item(i);
            NamedNodeMap map = node.getAttributes();
            if (map != null && (subNode = map.getNamedItem(key)) != null && finder.equals(subNode.getNodeValue())) {
                result.accept(node);
            }
            RunConfigFixer.findNode(node.getChildNodes(), finder, key, result);
        }
    }

    private static void insertJsonConfig(Path path, String filePath) throws IOException {
        boolean result = false;
        JsonObject object = null;
        try (JsonReader reader = new JsonReader((Reader)new FileReader(path.toFile()));){
            object = JsonParser.parseReader((JsonReader)reader).getAsJsonObject();
        }
        JsonArray configurations = object.getAsJsonArray("configurations");
        for (JsonElement e : configurations) {
            String args;
            JsonObject config = e.getAsJsonObject();
            JsonPrimitive vmArgs = config.getAsJsonPrimitive("vmArgs");
            ObjectArrayList parameters = new ObjectArrayList((Object[])vmArgs.getAsString().split(" "));
            int index = parameters.indexOf("-p");
            if (index == -1 || (args = (String)parameters.get(index + 1)).contains(filePath)) continue;
            parameters.set(index + 1, args + File.pathSeparator + filePath);
            StringJoiner joiner = new StringJoiner(" ");
            parameters.forEach(joiner::add);
            config.addProperty("vmArgs", joiner.toString());
            result = true;
            System.out.println("Fixed: " + path.toString() + " " + config.getAsJsonPrimitive("name").getAsString());
        }
        if (result) {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            try (JsonWriter writer = gson.newJsonWriter((Writer)new FileWriter(path.toFile()));){
                gson.toJson((JsonElement)object, writer);
            }
        }
    }
}

