/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.mixin;

import com.blakebr0.cucumber.Cucumber;
import com.blakebr0.cucumber.event.RecipeManagerLoadingEvent;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={RecipeManager.class})
public class RecipeManagerMixin {
    @Inject(at={@At(value="INVOKE_ASSIGN", target="Lcom/google/common/collect/ImmutableMap;builder()Lcom/google/common/collect/ImmutableMap$Builder;", ordinal=0)}, method={"apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void cucumber$apply(Map<ResourceLocation, JsonElement> p_44037_, ResourceManager p_44038_, ProfilerFiller p_44039_, CallbackInfo ci, Map<RecipeType<?>, ImmutableMap.Builder<ResourceLocation, Recipe<?>>> map, ImmutableMap.Builder<ResourceLocation, Recipe<?>> builder) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        RecipeManager manager = (RecipeManager)this;
        ArrayList recipes = new ArrayList();
        try {
            MinecraftForge.EVENT_BUS.post((Event)new RecipeManagerLoadingEvent(manager, recipes));
        }
        catch (Exception e) {
            Cucumber.LOGGER.error("An error occurred while firing RecipeManagerLoadingEvent", (Throwable)e);
        }
        for (Recipe<?> recipe : recipes) {
            map.computeIfAbsent(recipe.m_6671_(), t -> ImmutableMap.builder()).put((Object)recipe.m_6423_(), recipe);
            builder.put((Object)recipe.m_6423_(), recipe);
        }
        Cucumber.LOGGER.info("Cucumber registered {} recipes in {} ms", (Object)recipes.size(), (Object)stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
    }
}

