/*
 * Decompiled with CFR 0.152.
 */
package dicemc.money;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import dicemc.money.api.MoneyManager;
import dicemc.money.commands.AccountCommandRoot;
import dicemc.money.commands.AccountCommandTop;
import dicemc.money.commands.ShopCommandBuilder;
import dicemc.money.compat.SectionProtectionCompat;
import dicemc.money.compat.ftbquests.FTBQHandler;
import dicemc.money.setup.Config;
import dicemc.money.storage.DatabaseManager;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="dicemcmm")
public class MoneyMod {
    public static final String MOD_ID = "dicemcmm";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static DatabaseManager dbm;

    public MoneyMod() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SERVER_CONFIG);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        if (ModList.get().isLoaded("ftbquests")) {
            FTBQHandler.init();
        }
        if (ModList.get().isLoaded("sectionprotection")) {
            SectionProtectionCompat.init();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
    }

    @SubscribeEvent
    public void onServerStart(ServerStartingEvent event) {
        MoneyManager.get().setWorld(event.getServer().m_129783_());
        if (((Boolean)Config.ENABLE_HISTORY.get()).booleanValue()) {
            String worldname = MoneyMod.getWorldName(event.getServer().m_129910_().m_5462_());
            String urlIn = event.getServer().m_6237_().getAbsolutePath() + "\\saves\\" + worldname + "\\";
            dbm = new DatabaseManager(worldname, urlIn);
        }
    }

    @SubscribeEvent
    public void onCommandRegister(RegisterCommandsEvent event) {
        AccountCommandRoot.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ShopCommandBuilder.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        AccountCommandTop.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private static String getWorldName(String raw) {
        int start = raw.indexOf("[") + 1;
        int end = raw.contains("]") ? raw.length() - 1 : raw.length();
        start = start >= 0 && start < end ? start : 0;
        end = end >= 0 ? end : 0;
        return raw.substring(start, end);
    }

    public static enum AcctTypes {
        PLAYER(new ResourceLocation("dicemcmm", "player")),
        SERVER(new ResourceLocation("dicemcmm", "server"));

        public ResourceLocation key;

        private AcctTypes(ResourceLocation res) {
            this.key = res;
        }
    }
}

