/*
 * Decompiled with CFR 0.152.
 */
package dicemc.money.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dicemc.money.MoneyMod;
import dicemc.money.setup.Config;
import dicemc.money.storage.DatabaseManager;
import dicemc.money.storage.MoneyWSD;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class AccountCommandAdmin {
    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"admin").requires(p -> p.m_6761_(((Integer)Config.ADMIN_LEVEL.get()).intValue()))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"byName").then(Commands.m_82127_((String)"balance").then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.word()).executes(p -> AccountCommandAdmin.balance((CommandContext<CommandSourceStack>)p))))).then(Commands.m_82129_((String)"action", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> b.suggest("set").suggest("give").suggest("take").buildFuture()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.word()).executes(p -> AccountCommandAdmin.process((CommandContext<CommandSourceStack>)p))).then(Commands.m_82129_((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(p -> AccountCommandAdmin.process((CommandContext<CommandSourceStack>)p)))))).then(Commands.m_82127_((String)"transfer").then(Commands.m_82129_((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).then(Commands.m_82129_((String)"from", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"to", (ArgumentType)StringArgumentType.word()).executes(p -> AccountCommandAdmin.transfer((CommandContext<CommandSourceStack>)p)))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"online").then(Commands.m_82127_((String)"balance").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(p -> AccountCommandAdmin.balance((CommandContext<CommandSourceStack>)p))))).then(Commands.m_82129_((String)"action", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> b.suggest("set").suggest("give").suggest("take").buildFuture()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(p -> AccountCommandAdmin.process((CommandContext<CommandSourceStack>)p))).then(Commands.m_82129_((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).executes(p -> AccountCommandAdmin.process((CommandContext<CommandSourceStack>)p)))))).then(Commands.m_82127_((String)"transfer").then(Commands.m_82129_((String)"amount", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).then(Commands.m_82129_((String)"from", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"to", (ArgumentType)EntityArgument.m_91466_()).executes(p -> AccountCommandAdmin.transfer((CommandContext<CommandSourceStack>)p)))))));
    }

    public static int process(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        GameProfile player = null;
        try {
            player = (GameProfile)((CommandSourceStack)context.getSource()).m_81377_().m_129927_().m_10996_(StringArgumentType.getString(context, (String)"player")).get();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (player == null) {
            try {
                player = EntityArgument.m_91474_(context, (String)"player").m_36316_();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        MoneyWSD wsd = MoneyWSD.get(((CommandSourceStack)context.getSource()).m_81377_().m_129783_());
        String option = StringArgumentType.getString(context, (String)"action");
        UUID pid = player.getId();
        double value = DoubleArgumentType.getDouble(context, (String)"amount");
        if (pid == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"message.command.playernotfound"));
            return 1;
        }
        switch (option) {
            case "set": {
                boolean result = wsd.setBalance(MoneyMod.AcctTypes.PLAYER.key, pid, value);
                if (result) {
                    if (((Boolean)Config.ENABLE_HISTORY.get()).booleanValue()) {
                        boolean isPlayer = ((CommandSourceStack)context.getSource()).m_81373_() instanceof ServerPlayer;
                        UUID srcID = isPlayer ? ((CommandSourceStack)context.getSource()).m_81373_().m_20148_() : DatabaseManager.NIL;
                        ResourceLocation srcType = isPlayer ? MoneyMod.AcctTypes.PLAYER.key : MoneyMod.AcctTypes.SERVER.key;
                        String srcName = isPlayer ? ((GameProfile)((CommandSourceStack)context.getSource()).m_81377_().m_129927_().m_11002_(srcID).get()).getName() : "Console";
                        MoneyMod.dbm.postEntry(System.currentTimeMillis(), srcID, srcType, srcName, pid, MoneyMod.AcctTypes.PLAYER.key, ((GameProfile)MoneyMod.dbm.server.m_129927_().m_11002_(pid).get()).getName(), value, "Admin Set Command");
                    }
                    ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"message.command.set.success", (Object[])new Object[]{player.getName(), Config.getFormattedCurrency(value)}), true);
                    return 0;
                }
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"message.command.set.failure"));
                return 1;
            }
            case "give": {
                boolean result = wsd.changeBalance(MoneyMod.AcctTypes.PLAYER.key, pid, value);
                if (result) {
                    if (((Boolean)Config.ENABLE_HISTORY.get()).booleanValue()) {
                        boolean isPlayer = ((CommandSourceStack)context.getSource()).m_81373_() instanceof ServerPlayer;
                        UUID srcID = isPlayer ? ((CommandSourceStack)context.getSource()).m_81373_().m_20148_() : DatabaseManager.NIL;
                        ResourceLocation srcType = isPlayer ? MoneyMod.AcctTypes.PLAYER.key : MoneyMod.AcctTypes.SERVER.key;
                        String srcName = isPlayer ? ((GameProfile)((CommandSourceStack)context.getSource()).m_81377_().m_129927_().m_11002_(srcID).get()).getName() : "Console";
                        MoneyMod.dbm.postEntry(System.currentTimeMillis(), srcID, srcType, srcName, pid, MoneyMod.AcctTypes.PLAYER.key, ((GameProfile)MoneyMod.dbm.server.m_129927_().m_11002_(pid).get()).getName(), value, "Admin Give Command");
                    }
                    ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"message.command.give.success", (Object[])new Object[]{Config.getFormattedCurrency(value), player.getName()}), true);
                    return 0;
                }
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"message.command.change.failure"));
                return 1;
            }
            case "take": {
                boolean result = wsd.changeBalance(MoneyMod.AcctTypes.PLAYER.key, pid, -value);
                if (result) {
                    if (((Boolean)Config.ENABLE_HISTORY.get()).booleanValue()) {
                        boolean isPlayer = ((CommandSourceStack)context.getSource()).m_81373_() instanceof ServerPlayer;
                        UUID srcID = isPlayer ? ((CommandSourceStack)context.getSource()).m_81373_().m_20148_() : DatabaseManager.NIL;
                        ResourceLocation srcType = isPlayer ? MoneyMod.AcctTypes.PLAYER.key : MoneyMod.AcctTypes.SERVER.key;
                        String srcName = isPlayer ? ((GameProfile)((CommandSourceStack)context.getSource()).m_81377_().m_129927_().m_11002_(srcID).get()).getName() : "Console";
                        MoneyMod.dbm.postEntry(System.currentTimeMillis(), srcID, srcType, srcName, pid, MoneyMod.AcctTypes.PLAYER.key, ((GameProfile)MoneyMod.dbm.server.m_129927_().m_11002_(pid).get()).getName(), value, "Admin Take Command");
                    }
                    ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"message.command.take.success", (Object[])new Object[]{Config.getFormattedCurrency(value), player.getName()}), true);
                    return 0;
                }
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"message.command.change.failure"));
                return 1;
            }
        }
        return 0;
    }

    public static int balance(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        GameProfile player = null;
        try {
            player = (GameProfile)((CommandSourceStack)context.getSource()).m_81377_().m_129927_().m_10996_(StringArgumentType.getString(context, (String)"player")).get();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (player == null) {
            try {
                player = EntityArgument.m_91474_(context, (String)"player").m_36316_();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        MoneyWSD wsd = MoneyWSD.get(((CommandSourceStack)context.getSource()).m_81377_().m_129783_());
        if (player == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"message.command.playernotfound"));
            return 1;
        }
        double balP = wsd.getBalance(MoneyMod.AcctTypes.PLAYER.key, player.getId());
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)Config.getFormattedCurrency(balP)), true);
        return 0;
    }

    public static int transfer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        GameProfile fromplayer = null;
        GameProfile toplayer = null;
        try {
            fromplayer = (GameProfile)((CommandSourceStack)context.getSource()).m_81377_().m_129927_().m_10996_(StringArgumentType.getString(context, (String)"from")).get();
            toplayer = (GameProfile)((CommandSourceStack)context.getSource()).m_81377_().m_129927_().m_10996_(StringArgumentType.getString(context, (String)"to")).get();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (fromplayer == null && toplayer == null) {
            try {
                fromplayer = EntityArgument.m_91474_(context, (String)"from").m_36316_();
                toplayer = EntityArgument.m_91474_(context, (String)"to").m_36316_();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        MoneyWSD wsd = MoneyWSD.get(((CommandSourceStack)context.getSource()).m_81377_().m_129783_());
        double value = DoubleArgumentType.getDouble(context, (String)"amount");
        if (fromplayer == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"message.command.playernotfound"));
            return 1;
        }
        if (toplayer == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"message.command.playernotfound"));
            return 1;
        }
        boolean result = wsd.transferFunds(MoneyMod.AcctTypes.PLAYER.key, fromplayer.getId(), MoneyMod.AcctTypes.PLAYER.key, toplayer.getId(), value);
        if (result) {
            if (((Boolean)Config.ENABLE_HISTORY.get()).booleanValue()) {
                boolean isPlayer = ((CommandSourceStack)context.getSource()).m_81373_() instanceof ServerPlayer;
                UUID srcID = isPlayer ? ((CommandSourceStack)context.getSource()).m_81373_().m_20148_() : DatabaseManager.NIL;
                String srcName = isPlayer ? ((GameProfile)((CommandSourceStack)context.getSource()).m_81377_().m_129927_().m_11002_(srcID).get()).getName() : "Console";
                MoneyMod.dbm.postEntry(System.currentTimeMillis(), fromplayer.getId(), MoneyMod.AcctTypes.PLAYER.key, fromplayer.getName(), toplayer.getId(), MoneyMod.AcctTypes.PLAYER.key, toplayer.getName(), value, "Admin Transfer Command Executed by: " + srcName);
            }
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"message.command.transfer.success", (Object[])new Object[]{Config.getFormattedCurrency(value), toplayer.getName()}), true);
            return 0;
        }
        ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"message.command.transfer.failure"));
        return 1;
    }
}

