/*
 * Decompiled with CFR 0.152.
 */
package dicemc.money.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dicemc.money.MoneyMod;
import dicemc.money.setup.Config;
import dicemc.money.storage.MoneyWSD;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class AccountCommandTransfer
implements Command<CommandSourceStack> {
    private static final AccountCommandTransfer CMD = new AccountCommandTransfer();

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return Commands.m_82127_((String)"transfer").then(Commands.m_82129_((String)"value", (ArgumentType)DoubleArgumentType.doubleArg((double)0.0)).then(Commands.m_82129_((String)"recipient", (ArgumentType)StringArgumentType.word()).executes((Command)CMD)));
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ServerLevel world = ((CommandSourceStack)context.getSource()).m_81377_().m_129783_();
        double value = DoubleArgumentType.getDouble(context, (String)"value");
        UUID recipient = ((GameProfile)((CommandSourceStack)context.getSource()).m_81377_().m_129927_().m_10996_(StringArgumentType.getString(context, (String)"recipient")).get()).getId();
        if (MoneyWSD.get(world).transferFunds(MoneyMod.AcctTypes.PLAYER.key, player.m_20148_(), MoneyMod.AcctTypes.PLAYER.key, recipient, value)) {
            if (((Boolean)Config.ENABLE_HISTORY.get()).booleanValue()) {
                MoneyMod.dbm.postEntry(System.currentTimeMillis(), player.m_20148_(), MoneyMod.AcctTypes.PLAYER.key, player.m_7755_().getString(), recipient, MoneyMod.AcctTypes.PLAYER.key, ((GameProfile)((CommandSourceStack)context.getSource()).m_81377_().m_129927_().m_11002_(recipient).get()).getName(), value, "Player Transfer Command. From is who executed");
            }
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237110_((String)"message.command.transfer.success", (Object[])new Object[]{Config.getFormattedCurrency(Math.abs(value)), StringArgumentType.getString(context, (String)"recipient")}), true);
        } else {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237115_((String)"message.command.transfer.failure"), false);
        }
        return 0;
    }
}

