/*
 * Decompiled with CFR 0.152.
 */
package dicemc.money.storage;

import com.mojang.authlib.GameProfile;
import dicemc.money.MoneyMod;
import dicemc.money.api.IMoneyManager;
import dicemc.money.setup.Config;
import dicemc.money.storage.DatabaseManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class MoneyWSD
extends SavedData
implements IMoneyManager {
    private static final String DATA_NAME = "dicemcmm_data";
    private Map<ResourceLocation, Map<UUID, Double>> accounts = new HashMap<ResourceLocation, Map<UUID, Double>>();

    public MoneyWSD(CompoundTag nbt) {
        this.load(nbt);
    }

    public MoneyWSD() {
    }

    public Map<UUID, Double> getAccountMap(ResourceLocation res) {
        return this.accounts.getOrDefault(res, new HashMap());
    }

    @Override
    public double getBalance(ResourceLocation type, UUID owner) {
        this.accountChecker(type, owner);
        return (Double)((Map)this.accounts.getOrDefault(type, new HashMap())).get(owner);
    }

    @Override
    public boolean setBalance(ResourceLocation type, UUID id, double value) {
        if (type != null && this.accounts.containsKey(type) && id != null) {
            this.accounts.get(type).put(id, value);
            this.m_77762_();
            if (((Boolean)Config.ENABLE_HISTORY.get()).booleanValue()) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean changeBalance(ResourceLocation type, UUID id, double value) {
        if (type == null || id == null) {
            return false;
        }
        double current = this.getBalance(type, id);
        double future = current + value;
        return this.setBalance(type, id, future);
    }

    @Override
    public boolean transferFunds(ResourceLocation fromType, UUID fromID, ResourceLocation toType, UUID toID, double value) {
        if (fromType == null || fromID == null || toType == null || toID == null) {
            return false;
        }
        double funds = Math.abs(value);
        double fromBal = this.getBalance(fromType, fromID);
        if (fromBal < funds) {
            return false;
        }
        if (this.changeBalance(fromType, fromID, -funds) && this.changeBalance(toType, toID, funds)) {
            this.m_77762_();
            return true;
        }
        return false;
    }

    public void accountChecker(ResourceLocation type, UUID owner) {
        if (type != null && !this.accounts.containsKey(type)) {
            this.accounts.put(type, new HashMap());
            this.m_77762_();
        }
        if (owner != null && !this.accounts.get(type).containsKey(owner)) {
            this.accounts.get(type).put(owner, (Double)Config.STARTING_FUNDS.get());
            if (((Boolean)Config.ENABLE_HISTORY.get()).booleanValue()) {
                MoneyMod.dbm.postEntry(System.currentTimeMillis(), DatabaseManager.NIL, MoneyMod.AcctTypes.SERVER.key, "Server", owner, type, ((GameProfile)MoneyMod.dbm.server.m_129927_().m_11002_(owner).get()).getName(), (Double)Config.STARTING_FUNDS.get(), "Starting Funds Deposit");
            }
            this.m_77762_();
        }
    }

    public void load(CompoundTag nbt) {
        ListTag baseList = nbt.m_128437_("types", 10);
        for (int b = 0; b < baseList.size(); ++b) {
            CompoundTag entry = baseList.m_128728_(b);
            ResourceLocation res = new ResourceLocation(entry.m_128461_("type"));
            HashMap<UUID, Double> data = new HashMap<UUID, Double>();
            ListTag list = entry.m_128437_("data", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag snbt = list.m_128728_(i);
                UUID id = snbt.m_128342_("id");
                double balance = snbt.m_128459_("balance");
                data.put(id, balance);
            }
            this.accounts.put(res, data);
        }
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag baseList = new ListTag();
        for (Map.Entry<ResourceLocation, Map<UUID, Double>> base : this.accounts.entrySet()) {
            CompoundTag entry = new CompoundTag();
            ListTag list = new ListTag();
            entry.m_128359_("type", base.getKey().toString());
            for (Map.Entry<UUID, Double> data : base.getValue().entrySet()) {
                CompoundTag dataNBT = new CompoundTag();
                dataNBT.m_128362_("id", data.getKey());
                dataNBT.m_128347_("balance", data.getValue().doubleValue());
                list.add((Object)dataNBT);
            }
            entry.m_128365_("data", (Tag)list);
            baseList.add((Object)entry);
        }
        nbt.m_128365_("types", (Tag)baseList);
        return nbt;
    }

    public static MoneyWSD get(ServerLevel world) {
        return (MoneyWSD)world.m_8895_().m_164861_(MoneyWSD::new, MoneyWSD::new, DATA_NAME);
    }
}

