/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.inventory.recipe;

import doggytalents.DoggyRecipeSerializers;
import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.registry.IBeddingMaterial;
import doggytalents.api.registry.ICasingMaterial;
import doggytalents.common.util.DogBedUtil;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.IShapedRecipe;

public class DogBedRecipe
extends CustomRecipe
implements IShapedRecipe<CraftingContainer> {
    public DogBedRecipe(ResourceLocation resource) {
        super(resource);
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        Object beddingId = null;
        Object casingId = null;
        for (int col = 0; col < 3; ++col) {
            for (int row = 0; row < 3; ++row) {
                Object id;
                if (col == 1 && row < 2) {
                    id = DogBedUtil.getBeddingFromStack(DoggyTalentsAPI.BEDDING_MATERIAL.get(), inv.m_8020_(row * inv.m_39347_() + col));
                    if (id == null) {
                        return false;
                    }
                    if (beddingId == null) {
                        beddingId = id;
                        continue;
                    }
                    if (beddingId == id) continue;
                    return false;
                }
                id = DogBedUtil.getCasingFromStack(DoggyTalentsAPI.CASING_MATERIAL.get(), inv.m_8020_(row * inv.m_39347_() + col));
                if (id == null) {
                    return false;
                }
                if (casingId == null) {
                    casingId = id;
                    continue;
                }
                if (casingId == id) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack assemble(CraftingContainer inv) {
        IBeddingMaterial beddingId = DogBedUtil.getBeddingFromStack(DoggyTalentsAPI.BEDDING_MATERIAL.get(), inv.m_8020_(1));
        ICasingMaterial casingId = DogBedUtil.getCasingFromStack(DoggyTalentsAPI.CASING_MATERIAL.get(), inv.m_8020_(0));
        return DogBedUtil.createItemStack(casingId, beddingId);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.m_8020_(i);
            nonnulllist.set(i, (Object)ForgeHooks.getCraftingRemainingItem((ItemStack)itemstack));
        }
        return nonnulllist;
    }

    public boolean m_8004_(int width, int height) {
        return width >= 3 && height >= 3;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)DoggyRecipeSerializers.DOG_BED.get();
    }

    public int getRecipeWidth() {
        return 3;
    }

    public int getRecipeHeight() {
        return 3;
    }
}

