/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.api.inferface.AbstractDogEntity;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import doggytalents.common.util.EntityUtil;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class PuppyEyesTalent
extends TalentInstance {
    private int cooldown;

    public PuppyEyesTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public TalentInstance copy() {
        PuppyEyesTalent inst = new PuppyEyesTalent(this.getTalent(), this.level);
        inst.cooldown = this.cooldown;
        return inst;
    }

    @Override
    public void init(AbstractDogEntity dogIn) {
        this.cooldown = dogIn.f_19797_;
    }

    @Override
    public void writeToNBT(AbstractDogEntity dogIn, CompoundTag compound) {
        super.writeToNBT(dogIn, compound);
        int timeLeft = this.cooldown - dogIn.f_19797_;
        compound.m_128405_("cooldown", timeLeft);
    }

    @Override
    public void readFromNBT(AbstractDogEntity dogIn, CompoundTag compound) {
        super.readFromNBT(dogIn, compound);
        this.cooldown = dogIn.f_19797_ + compound.m_128451_("cooldown");
    }

    @Override
    public void onRead(AbstractDogEntity dogIn, CompoundTag compound) {
        if (compound.m_128441_("charmercharge")) {
            this.cooldown = dogIn.f_19797_ + compound.m_128451_("charmercharge");
        }
    }

    @Override
    public void livingTick(AbstractDogEntity dogIn) {
        if (dogIn.f_19797_ % 40 != 0) {
            return;
        }
        if (dogIn.f_19853_.f_46443_ || !dogIn.m_21824_()) {
            return;
        }
        if (this.level() <= 0) {
            return;
        }
        int timeLeft = this.cooldown - dogIn.f_19797_;
        if (timeLeft <= 0) {
            LivingEntity owner = dogIn.m_21826_();
            if (owner == null) {
                return;
            }
            LivingEntity villager = this.getClosestVisibleVillager(dogIn, 5.0);
            if (villager != null) {
                int rewardId = dogIn.m_217043_().m_188503_(this.level()) + (this.level() >= 5 ? 1 : 0);
                if (rewardId == 0) {
                    owner.m_213846_((Component)Component.m_237110_((String)"talent.doggytalents.puppy_eyes.msg.1.line.1", (Object[])new Object[]{dogIn.getGenderPronoun()}));
                    owner.m_213846_((Component)Component.m_237110_((String)"talent.doggytalents.puppy_eyes.msg.1.line.2", (Object[])new Object[]{dogIn.getGenderSubject()}));
                    villager.m_20000_((ItemLike)Items.f_42485_, 2);
                } else if (rewardId == 1) {
                    owner.m_213846_((Component)Component.m_237110_((String)"talent.doggytalents.puppy_eyes.msg.2.line.1", (Object[])new Object[]{dogIn.getGenderTitle()}));
                    owner.m_213846_((Component)Component.m_237110_((String)"talent.doggytalents.puppy_eyes.msg.2.line.2", (Object[])new Object[]{dogIn.getGenderTitle()}));
                    owner.m_213846_((Component)Component.m_237110_((String)"talent.doggytalents.puppy_eyes.msg.2.line.3", (Object[])new Object[]{dogIn.getGenderTitle()}));
                    villager.m_20000_((ItemLike)Items.f_42485_, 5);
                } else if (rewardId == 2) {
                    owner.m_213846_((Component)Component.m_237115_((String)"talent.doggytalents.puppy_eyes.msg.3.line.1"));
                    owner.m_213846_((Component)Component.m_237115_((String)"talent.doggytalents.puppy_eyes.msg.3.line.2"));
                    owner.m_213846_((Component)Component.m_237115_((String)"talent.doggytalents.puppy_eyes.msg.3.line.3"));
                    villager.m_20000_((ItemLike)Items.f_42416_, 3);
                } else if (rewardId == 3) {
                    owner.m_213846_((Component)Component.m_237115_((String)"talent.doggytalents.puppy_eyes.msg.4.line.1"));
                    owner.m_213846_((Component)Component.m_237115_((String)"talent.doggytalents.puppy_eyes.msg.4.line.2"));
                    owner.m_213846_((Component)Component.m_237115_((String)"talent.doggytalents.puppy_eyes.msg.4.line.3"));
                    villager.m_20000_((ItemLike)Items.f_42417_, 2);
                } else if (rewardId == 4) {
                    owner.m_213846_((Component)Component.m_237115_((String)"talent.doggytalents.puppy_eyes.msg.5.line.1"));
                    owner.m_213846_((Component)Component.m_237115_((String)"talent.doggytalents.puppy_eyes.msg.5.line.2"));
                    owner.m_213846_((Component)Component.m_237115_((String)"talent.doggytalents.puppy_eyes.msg.5.line.3"));
                    villager.m_20000_((ItemLike)Items.f_42415_, 1);
                } else if (rewardId == 5) {
                    owner.m_213846_((Component)Component.m_237115_((String)"talent.doggytalents.puppy_eyes.msg.6.line.1"));
                    owner.m_213846_((Component)Component.m_237115_((String)"talent.doggytalents.puppy_eyes.msg.6.line.2"));
                    owner.m_213846_((Component)Component.m_237115_((String)"talent.doggytalents.puppy_eyes.msg.6.line.3"));
                    villager.m_20000_((ItemLike)Items.f_42410_, 1);
                    villager.m_20000_((ItemLike)Blocks.f_50145_, 1);
                    villager.m_20000_((ItemLike)Items.f_42518_, 3);
                    villager.m_20000_((ItemLike)Items.f_42485_, 5);
                }
                this.cooldown = dogIn.f_19797_ + (this.level() >= 5 ? 24000 : 48000);
            }
        }
    }

    public LivingEntity getClosestVisibleVillager(AbstractDogEntity dogIn, double radiusIn) {
        List list = dogIn.f_19853_.m_6443_(AbstractVillager.class, dogIn.m_20191_().m_82377_(radiusIn, radiusIn, radiusIn), village -> village.m_142582_((Entity)dogIn));
        return (LivingEntity)EntityUtil.getClosestTo((Entity)dogIn, list);
    }
}

