/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.easier_sleeping.elements.commands.sleep;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.geheimagentnr1.easier_sleeping.config.DimensionListType;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;

class DimensionListTypeParser {
    private static final DynamicCommandExceptionType DIMENSION_LIST_TYPE_INVALID = new DynamicCommandExceptionType(function -> Component.m_237113_((String)"Invalid Dimension List Type"));
    private static final Set<String> DIMENSION_LIST_TYPES = DimensionListTypeParser.getItemKeySet();
    private final StringReader reader;
    private DimensionListType dimensionListType;
    private Function<SuggestionsBuilder, CompletableFuture<Suggestions>> suggestionsBuilder;

    DimensionListTypeParser(StringReader _reader) {
        this.reader = _reader;
    }

    private static Set<String> getItemKeySet() {
        TreeSet<String> keySet = new TreeSet<String>();
        for (DimensionListType dimensionListType : DimensionListType.values()) {
            keySet.add(dimensionListType.name());
        }
        return keySet;
    }

    DimensionListType getDimensionListType() {
        return this.dimensionListType;
    }

    private void readDimensionListType() throws CommandSyntaxException {
        int cursor = this.reader.getCursor();
        while (this.reader.canRead() && this.reader.peek() != ' ') {
            this.reader.skip();
        }
        String dimensionListTypeString = this.reader.getString().substring(cursor, this.reader.getCursor());
        this.dimensionListType = this.getItemForRegistry(dimensionListTypeString).orElseThrow(() -> {
            this.reader.setCursor(cursor);
            return DIMENSION_LIST_TYPE_INVALID.createWithContext((ImmutableStringReader)this.reader, (Object)dimensionListTypeString);
        });
    }

    private Optional<DimensionListType> getItemForRegistry(String dimensionListTypeString) {
        for (DimensionListType forDimensionListType : DimensionListType.values()) {
            if (!forDimensionListType.name().equals(dimensionListTypeString)) continue;
            return Optional.of(forDimensionListType);
        }
        return Optional.empty();
    }

    DimensionListTypeParser parse() throws CommandSyntaxException {
        this.suggestionsBuilder = this::suggestDimensionListType;
        this.readDimensionListType();
        this.suggestionsBuilder = this::suggestDimensionListTypeFuture;
        return this;
    }

    private CompletableFuture<Suggestions> suggestDimensionListTypeFuture(SuggestionsBuilder builder) {
        return builder.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestDimensionListType(SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82970_(DIMENSION_LIST_TYPES, (SuggestionsBuilder)builder);
    }

    CompletableFuture<Suggestions> fillSuggestions(SuggestionsBuilder builder) {
        return this.suggestionsBuilder.apply(builder.createOffset(this.reader.getCursor()));
    }
}

