/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.easier_sleeping.elements.commands.sleep;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.geheimagentnr1.easier_sleeping.config.DimensionListType;
import de.geheimagentnr1.easier_sleeping.config.ServerConfig;
import de.geheimagentnr1.easier_sleeping.elements.commands.sleep.DimensionListTypeArgument;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class SleepCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder sleep = (LiteralArgumentBuilder)Commands.m_82127_((String)"sleep").requires(source -> source.m_6761_(2));
        sleep.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"sleep_percent").executes(SleepCommand::showSleepPercent)).then(Commands.m_82129_((String)"sleep_percent", (ArgumentType)IntegerArgumentType.integer((int)0, (int)100)).executes(SleepCommand::changeSleepPercent)));
        sleep.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"message").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"wake").executes(SleepCommand::showWakeMessage)).then(Commands.m_82129_((String)"message", (ArgumentType)MessageArgument.m_96832_()).executes(SleepCommand::changeWakeMessage)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"sleep").executes(SleepCommand::showSleepMessage)).then(Commands.m_82129_((String)"message", (ArgumentType)MessageArgument.m_96832_()).executes(SleepCommand::changeSleepMessage)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"morning").executes(SleepCommand::showMorningMessage)).then(Commands.m_82129_((String)"message", (ArgumentType)MessageArgument.m_96832_()).executes(SleepCommand::changeMorningMessage))));
        sleep.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"all_players_rest").executes(SleepCommand::showAllPlayersRest)).then(Commands.m_82129_((String)"all_players_rest", (ArgumentType)BoolArgumentType.bool()).executes(SleepCommand::setAllPlayersRest)));
        sleep.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"dimension").executes(SleepCommand::showDimensions)).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(SleepCommand::addDimension)))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(SleepCommand::removeDimension)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"list_type").executes(SleepCommand::showDimensionListType)).then(Commands.m_82129_((String)"list_type", (ArgumentType)DimensionListTypeArgument.dimensionListType()).then(Commands.m_82129_((String)"invert_list", (ArgumentType)BoolArgumentType.bool()).executes(SleepCommand::changeDimensionListType)))));
        dispatcher.register(sleep);
    }

    private static int showSleepPercent(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)String.format("Sleep Percent: %d", ServerConfig.getSleepPercent())), false);
        return 1;
    }

    private static int changeSleepPercent(CommandContext<CommandSourceStack> context) {
        ServerConfig.setSleepPercent(IntegerArgumentType.getInteger(context, (String)"sleep_percent"));
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)String.format("Sleep Percent is now: %d", ServerConfig.getSleepPercent())), true);
        return 1;
    }

    private static int showWakeMessage(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)String.format("Wake Message: %s", ServerConfig.getWakeMessage())), false);
        return 1;
    }

    private static int changeWakeMessage(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerConfig.setWakeMessage(MessageArgument.m_96835_(context, (String)"message").getString());
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)String.format("Wake Message is now: %s", ServerConfig.getWakeMessage())), true);
        return 1;
    }

    private static int showSleepMessage(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)String.format("Sleep Message: %s", ServerConfig.getSleepMessage())), false);
        return 1;
    }

    private static int changeSleepMessage(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerConfig.setSleepMessage(MessageArgument.m_96835_(context, (String)"message").getString());
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)String.format("Sleep Message is now: %s", ServerConfig.getSleepMessage())), true);
        return 1;
    }

    private static int showMorningMessage(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)String.format("Morning Message: %s", ServerConfig.getMorningMessage())), false);
        return 1;
    }

    private static int changeMorningMessage(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerConfig.setMorningMessage(MessageArgument.m_96835_(context, (String)"message").getString());
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)String.format("Morning Message is now: %s", ServerConfig.getMorningMessage())), true);
        return 1;
    }

    private static int showAllPlayersRest(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)String.format("All players rest is: %s", ServerConfig.getAllPlayersRest())), true);
        return 1;
    }

    private static int setAllPlayersRest(CommandContext<CommandSourceStack> context) {
        ServerConfig.setAllPlayersRest(BoolArgumentType.getBool(context, (String)"all_players_rest"));
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)String.format("All players rest is now : %s", ServerConfig.getAllPlayersRest())), true);
        return 1;
    }

    private static int showDimensions(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.m_81354_((Component)Component.m_237113_((String)"Dimensions:"), false);
        for (ResourceKey<Level> dimension : ServerConfig.getDimensions()) {
            source.m_81354_((Component)Component.m_237113_((String)String.format(" - %s", dimension.m_135782_())), false);
        }
        return 1;
    }

    private static int addDimension(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ResourceKey dimension = DimensionArgument.m_88808_(context, (String)"dimension").m_46472_();
        ServerConfig.addDimension((ResourceKey<Level>)dimension);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)String.format("Added Dimension: %s", dimension.m_135782_())), true);
        return 1;
    }

    private static int removeDimension(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ResourceKey dimension = DimensionArgument.m_88808_(context, (String)"dimension").m_46472_();
        ServerConfig.removeDimension((ResourceKey<Level>)dimension);
        ((CommandSourceStack)context.getSource()).m_81354_((Component)Component.m_237113_((String)String.format("Removed Dimension: %s", dimension.m_135782_())), true);
        return 1;
    }

    private static int showDimensionListType(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        source.m_81354_((Component)Component.m_237113_((String)String.format("Dimension List Type: %s", ServerConfig.getDimensionListType().name())), false);
        return 1;
    }

    private static int changeDimensionListType(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        DimensionListType dimensionListType = DimensionListTypeArgument.getDimensionListType(context, "list_type");
        boolean revert = BoolArgumentType.getBool(context, (String)"invert_list");
        ServerConfig.setDimensionListType(dimensionListType);
        if (revert) {
            ServerConfig.invertDimensions();
        }
        source.m_81354_((Component)Component.m_237113_((String)String.format("Dimension List Type set to: %s", ServerConfig.getDimensionListType().name())), false);
        source.m_81354_((Component)Component.m_237113_((String)"Dimensions:"), false);
        for (ResourceKey<Level> dimension : ServerConfig.getDimensions()) {
            source.m_81354_((Component)Component.m_237113_((String)String.format(" - %s", dimension.m_135782_())), false);
        }
        return 1;
    }
}

