/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.easier_sleeping.sleeping;

import de.geheimagentnr1.easier_sleeping.config.DimensionListType;
import de.geheimagentnr1.easier_sleeping.config.ServerConfig;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;

public class SleepingManager {
    private static TreeMap<ResourceKey<Level>, TreeSet<ServerPlayer>> SLEEPING;
    private static final Comparator<Player> PLAYER_COMPARATOR;

    public static void init() {
        SLEEPING = new TreeMap(Comparator.comparing(ResourceKey::m_135782_));
    }

    static void updateSleepingPlayers(MinecraftServer server) {
        for (ServerLevel level : server.m_129785_()) {
            ResourceKey registrykey = level.m_46472_();
            boolean containsDimension = ServerConfig.getDimensions().contains(registrykey);
            if (ServerConfig.getDimensionListType() == DimensionListType.SLEEP_ACTIVE && !containsDimension || ServerConfig.getDimensionListType() == DimensionListType.SLEEP_INACTIVE && containsDimension) continue;
            if (!SLEEPING.containsKey(registrykey)) {
                SLEEPING.put((ResourceKey<Level>)registrykey, new TreeSet<Player>(PLAYER_COMPARATOR));
            }
            TreeSet<ServerPlayer> sleeping_players = SLEEPING.get(registrykey);
            List level_players = level.m_6907_();
            int non_spectator_player_count = SleepingManager.countNonSpectatorPlayers(level_players);
            for (ServerPlayer player2 : level_players) {
                if (player2.m_5803_() && !sleeping_players.contains(player2)) {
                    if (!player2.m_21257_().stream().noneMatch(pos -> ServerConfig.getIgnoredBedBlocks().contains(Registry.f_122824_.m_7981_((Object)level.m_8055_(pos).m_60734_())))) continue;
                    sleeping_players.add(player2);
                    SleepingManager.sendSleepMessage(level_players, sleeping_players.size(), non_spectator_player_count, (Player)player2);
                    continue;
                }
                if (player2.m_5803_() || !sleeping_players.contains(player2)) continue;
                sleeping_players.remove(player2);
                SleepingManager.sendWakeMessage(level_players, sleeping_players.size(), non_spectator_player_count, (Player)player2);
            }
            int sleeping_percent = SleepingManager.caculateSleepingPercent(SleepingManager.countSleepingPlayers(sleeping_players), non_spectator_player_count);
            if (sleeping_percent < ServerConfig.getSleepPercent() && (non_spectator_player_count <= 0 || non_spectator_player_count != sleeping_players.size())) continue;
            if (level.m_46469_().m_46207_(GameRules.f_46140_)) {
                long currentDayTime = level.m_46468_();
                long newDayTime = currentDayTime + 24000L - currentDayTime % 24000L;
                newDayTime = ForgeEventFactory.onSleepFinished((ServerLevel)level, (long)newDayTime, (long)currentDayTime);
                level.m_8615_(newDayTime);
            }
            sleeping_players.forEach(player -> {
                player.m_21257_().ifPresent(pos -> player.m_9158_(level.m_46472_(), pos, player.m_146908_(), false, false));
                player.m_5796_();
            });
            if (level.m_46469_().m_46207_(GameRules.f_46150_)) {
                level.m_8606_(0, 0, false, false);
            }
            if (ServerConfig.getAllPlayersRest()) {
                level_players.forEach(player -> player.m_7166_(Stats.f_12988_.m_12902_((Object)Stats.f_12992_)));
            }
            SleepingManager.sendMorningMessage(level_players);
            sleeping_players.clear();
        }
    }

    private static int countNonSpectatorPlayers(List<? extends Player> players) {
        int count = 0;
        for (Player player : players) {
            if (player.m_5833_()) continue;
            ++count;
        }
        return count;
    }

    private static int countSleepingPlayers(TreeSet<ServerPlayer> players) {
        int count = 0;
        for (ServerPlayer player : players) {
            if (!player.m_36317_()) continue;
            ++count;
        }
        return count;
    }

    private static void sendWakeMessage(List<? extends Player> players, int sleep_player_count, int non_spectator_player_count, Player wake_player) {
        SleepingManager.sendMessage(players, SleepingManager.buildWakeSleepMessage(wake_player, sleep_player_count, non_spectator_player_count, ServerConfig.getWakeMessage()));
    }

    private static void sendSleepMessage(List<? extends Player> players, int sleep_player_count, int non_spectator_player_count, Player wake_player) {
        SleepingManager.sendMessage(players, SleepingManager.buildWakeSleepMessage(wake_player, sleep_player_count, non_spectator_player_count, ServerConfig.getSleepMessage()));
    }

    private static void sendMorningMessage(List<? extends Player> players) {
        SleepingManager.sendMessage(players, Component.m_237113_((String)ServerConfig.getMorningMessage()));
    }

    private static void sendMessage(List<? extends Player> players, MutableComponent message) {
        for (Player player : players) {
            player.m_213846_((Component)message.m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GRAY))));
        }
    }

    private static MutableComponent buildWakeSleepMessage(Player player, int sleep_player_count, int player_count, String message) {
        return Component.m_237113_((String)"").m_7220_(player.m_5446_()).m_130946_(String.format(" %s - %d/%d (%d%%)", message, sleep_player_count, player_count, SleepingManager.caculateSleepingPercent(sleep_player_count, player_count)));
    }

    private static int caculateSleepingPercent(int sleep_player_count, int non_spectator_player_count) {
        return non_spectator_player_count == 0 ? 0 : sleep_player_count * 100 / non_spectator_player_count;
    }

    static {
        PLAYER_COMPARATOR = Comparator.comparing(Entity::m_20148_);
    }
}

