/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.network;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.chaosthedude.explorerscompass.items.ExplorersCompassItem;
import com.chaosthedude.explorerscompass.util.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class CompassSearchPacket {
    private ResourceLocation groupKey;
    private List<ResourceLocation> structureKeys;
    private int x;
    private int y;
    private int z;

    public CompassSearchPacket() {
    }

    public CompassSearchPacket(ResourceLocation groupKey, List<ResourceLocation> structureKeys, BlockPos pos) {
        this.groupKey = groupKey;
        this.structureKeys = structureKeys;
        this.x = pos.m_123341_();
        this.y = pos.m_123342_();
        this.z = pos.m_123343_();
    }

    public CompassSearchPacket(FriendlyByteBuf buf) {
        this.groupKey = buf.m_130281_();
        this.structureKeys = new ArrayList<ResourceLocation>();
        int numStructures = buf.readInt();
        for (int i = 0; i < numStructures; ++i) {
            this.structureKeys.add(buf.m_130281_());
        }
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130085_(this.groupKey);
        buf.writeInt(this.structureKeys.size());
        for (ResourceLocation key : this.structureKeys) {
            buf.m_130085_(key);
        }
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ItemStack stack = ItemUtils.getHeldItem((Player)((NetworkEvent.Context)ctx.get()).getSender(), ExplorersCompass.explorersCompass);
            if (!stack.m_41619_()) {
                ExplorersCompassItem explorersCompass = (ExplorersCompassItem)stack.m_41720_();
                explorersCompass.searchForStructure((Level)((NetworkEvent.Context)ctx.get()).getSender().m_9236_(), (Player)((NetworkEvent.Context)ctx.get()).getSender(), this.groupKey, this.structureKeys, new BlockPos(this.x, this.y, this.z), stack);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

