/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.client.recipebook;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.RecipeBookCategories;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.client.event.RegisterRecipeBookCategoriesEvent;
import vectorwing.farmersdelight.FarmersDelight;
import vectorwing.farmersdelight.client.recipebook.CookingPotRecipeBookTab;
import vectorwing.farmersdelight.common.crafting.CookingPotRecipe;
import vectorwing.farmersdelight.common.item.DrinkableItem;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.registry.ModRecipeTypes;

public class RecipeCategories {
    public static final Supplier<RecipeBookCategories> COOKING_SEARCH = Suppliers.memoize(() -> RecipeBookCategories.create((String)"COOKING_SEARCH", (ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.f_42522_)}));
    public static final Supplier<RecipeBookCategories> COOKING_MEALS = Suppliers.memoize(() -> RecipeBookCategories.create((String)"COOKING_MEALS", (ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ModItems.VEGETABLE_NOODLES.get())}));
    public static final Supplier<RecipeBookCategories> COOKING_DRINKS = Suppliers.memoize(() -> RecipeBookCategories.create((String)"COOKING_DRINKS", (ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ModItems.APPLE_CIDER.get())}));
    public static final Supplier<RecipeBookCategories> COOKING_MISC = Suppliers.memoize(() -> RecipeBookCategories.create((String)"COOKING_MISC", (ItemStack[])new ItemStack[]{new ItemStack((ItemLike)ModItems.DUMPLINGS.get()), new ItemStack((ItemLike)ModItems.TOMATO_SAUCE.get())}));

    public static void init(RegisterRecipeBookCategoriesEvent event) {
        event.registerBookCategories(FarmersDelight.RECIPE_TYPE_COOKING, (List)ImmutableList.of((Object)COOKING_SEARCH.get(), (Object)COOKING_MEALS.get(), (Object)COOKING_DRINKS.get(), (Object)COOKING_MISC.get()));
        event.registerAggregateCategory(COOKING_SEARCH.get(), (List)ImmutableList.of((Object)COOKING_MEALS.get(), (Object)COOKING_DRINKS.get(), (Object)COOKING_MISC.get()));
        event.registerRecipeCategoryFinder((RecipeType)ModRecipeTypes.COOKING.get(), recipe -> {
            CookingPotRecipe cookingRecipe;
            CookingPotRecipeBookTab tab;
            if (recipe instanceof CookingPotRecipe && (tab = (cookingRecipe = (CookingPotRecipe)recipe).getRecipeBookTab()) != null) {
                return switch (tab) {
                    default -> throw new IncompatibleClassChangeError();
                    case CookingPotRecipeBookTab.MEALS -> COOKING_MEALS.get();
                    case CookingPotRecipeBookTab.DRINKS -> COOKING_DRINKS.get();
                    case CookingPotRecipeBookTab.MISC -> COOKING_MISC.get();
                };
            }
            if (recipe.m_8043_().m_41720_() instanceof DrinkableItem) {
                return COOKING_DRINKS.get();
            }
            return COOKING_MISC.get();
        });
    }
}

