/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.insanelib.base;

import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public abstract class ConfigOption<T> {
    String name;
    ForgeConfigSpec.Builder builder;

    public ConfigOption(ForgeConfigSpec.Builder builder, String name, String description) {
        this.builder = builder;
        this.name = name;
        if (!"".equals(description)) {
            builder.comment(description);
        }
    }

    public abstract T get();

    public abstract void set(Object var1);

    public String toString() {
        return "ConfigOpt{name='%s'}".formatted(this.name);
    }

    public static class EnumOption<T extends Enum<T>>
    extends ConfigOption<T> {
        public final ForgeConfigSpec.ConfigValue<T> valueConfig;

        public EnumOption(ForgeConfigSpec.Builder builder, String name, String description, T defaultValue) {
            super(builder, name, description);
            this.valueConfig = builder.defineEnum(name, defaultValue);
        }

        @Override
        public T get() {
            return (T)((Enum)this.valueConfig.get());
        }

        @Override
        public void set(Object value) {
            this.valueConfig.set((Object)((Enum)value));
        }
    }

    public static class StringListOption
    extends ConfigOption<List<? extends String>> {
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> valueConfig;

        public StringListOption(ForgeConfigSpec.Builder builder, String name, String description, List<String> defaultValue) {
            super(builder, name, description);
            this.valueConfig = builder.defineList(this.name, defaultValue, o -> o instanceof String);
        }

        @Override
        public List<? extends String> get() {
            return (List)this.valueConfig.get();
        }

        @Override
        public void set(Object value) {
            this.valueConfig.set((Object)((List)value));
        }
    }

    public static class StringOption
    extends ConfigOption<String> {
        public final ForgeConfigSpec.ConfigValue<String> valueConfig;

        public StringOption(ForgeConfigSpec.Builder builder, String name, String description, String defaultValue) {
            super(builder, name, description);
            this.valueConfig = builder.define(this.name, (Object)defaultValue);
        }

        @Override
        public String get() {
            return (String)this.valueConfig.get();
        }

        @Override
        public void set(Object value) {
            this.valueConfig.set((Object)((String)value));
        }
    }

    public static class BoolOption
    extends ConfigOption<Boolean> {
        public final ForgeConfigSpec.BooleanValue valueConfig;

        public BoolOption(ForgeConfigSpec.Builder builder, String name, String description, boolean defaultValue) {
            super(builder, name, description);
            this.valueConfig = builder.define(name, defaultValue);
        }

        @Override
        public Boolean get() {
            return (Boolean)this.valueConfig.get();
        }

        @Override
        public void set(Object value) {
            this.valueConfig.set((Object)((Boolean)value));
        }
    }

    public static class IntOption
    extends ConfigOption<Integer> {
        public final ForgeConfigSpec.IntValue valueConfig;

        public IntOption(ForgeConfigSpec.Builder builder, String name, String description, int defaultValue, int min, int max) {
            super(builder, name, description);
            this.valueConfig = builder.defineInRange(name, defaultValue, min, max);
        }

        @Override
        public Integer get() {
            return (Integer)this.valueConfig.get();
        }

        @Override
        public void set(Object value) {
            this.valueConfig.set((Object)((Integer)value));
        }
    }

    public static class DoubleOption
    extends ConfigOption<Double> {
        public final ForgeConfigSpec.DoubleValue valueConfig;

        public DoubleOption(ForgeConfigSpec.Builder builder, String name, String description, double defaultValue, double min, double max) {
            super(builder, name, description);
            this.valueConfig = builder.defineInRange(name, defaultValue, min, max);
        }

        @Override
        public Double get() {
            return (Double)this.valueConfig.get();
        }

        @Override
        public void set(Object value) {
            this.valueConfig.set((Object)((Double)value));
        }
    }

    public static class GenericOption
    extends ConfigOption<Object> {
        public final ForgeConfigSpec.ConfigValue<Object> valueConfig;

        public GenericOption(ForgeConfigSpec.Builder builder, String name, String description, Object defaultValue) {
            super(builder, name, description);
            this.valueConfig = builder.define(name, defaultValue);
        }

        @Override
        public Object get() {
            return this.valueConfig.get();
        }

        @Override
        public void set(Object value) {
            this.valueConfig.set(value);
        }
    }
}

