/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.InfestedBlock;
import net.minecraft.world.level.block.TrappedChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.addon.vanilla.VanillaPlugin;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.gui.HomeConfigScreen;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.overlay.WailaTickHandler;
import snownee.jade.util.ClientPlatformProxy;
import snownee.jade.util.ModIdentification;
import snownee.jade.util.PlatformProxy;

public final class JadeClient {
    public static KeyMapping openConfig;
    public static KeyMapping showOverlay;
    public static KeyMapping toggleLiquid;
    public static KeyMapping showDetails;
    public static KeyMapping narrate;
    public static KeyMapping showRecipes;
    public static KeyMapping showUses;
    private static boolean translationChecked;
    public static boolean hideModName;
    private static float savedProgress;
    private static float progressAlpha;
    private static boolean canHarvest;

    public static void initClient() {
        for (int i = 320; i < 330; ++i) {
            InputConstants.Key key = InputConstants.Type.KEYSYM.m_84895_(i);
            key.f_84856_ = new LazyLoadedValue(() -> Component.m_237115_((String)key.m_84874_()));
        }
        openConfig = ClientPlatformProxy.registerKeyBinding("config", 320);
        showOverlay = ClientPlatformProxy.registerKeyBinding("show_overlay", 321);
        toggleLiquid = ClientPlatformProxy.registerKeyBinding("toggle_liquid", 322);
        if (ClientPlatformProxy.shouldRegisterRecipeViewerKeys()) {
            showRecipes = ClientPlatformProxy.registerKeyBinding("show_recipes", 323);
            showUses = ClientPlatformProxy.registerKeyBinding("show_uses", 324);
        }
        narrate = ClientPlatformProxy.registerKeyBinding("narrate", 325);
        showDetails = ClientPlatformProxy.registerKeyBinding("show_details", 340);
        ClientPlatformProxy.registerReloadListener(ModIdentification.INSTANCE);
    }

    public static void onKeyPressed(int action) {
        IWailaConfig.DisplayMode mode;
        if (action != 1) {
            return;
        }
        if (openConfig.m_90857_()) {
            Jade.CONFIG.invalidate();
            Minecraft.m_91087_().m_91152_((Screen)new HomeConfigScreen(null));
        }
        WailaConfig.ConfigGeneral general = Jade.CONFIG.get().getGeneral();
        if (showOverlay.m_90857_() && (mode = general.getDisplayMode()) == IWailaConfig.DisplayMode.TOGGLE) {
            general.setDisplayTooltip(!general.shouldDisplayTooltip());
            if (!general.shouldDisplayTooltip() && general.hintOverlayToggle) {
                SystemToast.m_94855_((ToastComponent)Minecraft.m_91087_().m_91300_(), (SystemToast.SystemToastIds)SystemToast.SystemToastIds.UNSECURE_SERVER_WARNING, (Component)Component.m_237115_((String)"toast.jade.toggle_hint.1"), (Component)Component.m_237110_((String)"toast.jade.toggle_hint.2", (Object[])new Object[]{showOverlay.m_90863_()}));
                general.hintOverlayToggle = false;
            }
            Jade.CONFIG.save();
        }
        if (toggleLiquid.m_90857_()) {
            general.setDisplayFluids(!general.shouldDisplayFluids());
            Jade.CONFIG.save();
        }
        if (narrate.m_90857_()) {
            if (general.getTTSMode() == IWailaConfig.TTSMode.TOGGLE) {
                general.toggleTTS();
                Jade.CONFIG.save();
            } else if (WailaTickHandler.instance().tooltipRenderer != null) {
                WailaTickHandler.narrate(WailaTickHandler.instance().tooltipRenderer.getTooltip(), false);
            }
        }
    }

    public static void onGui(Screen screen) {
        if (!translationChecked && screen instanceof TitleScreen && PlatformProxy.isDevEnv()) {
            translationChecked = true;
            ArrayList keys = Lists.newArrayList();
            for (ResourceLocation id : PluginConfig.INSTANCE.getKeys()) {
                String key = "config.jade.plugin_%s.%s".formatted(id.m_135827_(), id.m_135815_());
                if (I18n.m_118936_((String)key)) continue;
                keys.add(key);
            }
            if (!keys.isEmpty()) {
                throw new AssertionError((Object)"Missing config translation: %s".formatted(Joiner.on((char)',').join((Iterable)keys)));
            }
        }
    }

    public static void onTooltip(List<Component> tooltip, ItemStack stack) {
        JadeClient.appendModName(tooltip, stack);
        if (Jade.CONFIG.get().getGeneral().isDebug() && stack.m_41782_()) {
            tooltip.add(NbtUtils.m_178061_((Tag)stack.m_41783_()));
        }
    }

    private static void appendModName(List<Component> tooltip, ItemStack stack) {
        if (hideModName || !Jade.CONFIG.get().getGeneral().showItemModNameTooltip()) {
            return;
        }
        String name = String.format(Jade.CONFIG.get().getFormatting().getModName(), ModIdentification.getModName(stack));
        tooltip.add((Component)Component.m_237113_((String)name));
    }

    @Nullable
    public static Accessor<?> builtInOverrides(HitResult hitResult, @Nullable Accessor<?> accessor, @Nullable Accessor<?> originalAccessor) {
        if (accessor instanceof BlockAccessor) {
            BlockAccessor target = (BlockAccessor)accessor;
            Player player = accessor.getPlayer();
            if (player.m_7500_() || player.m_5833_()) {
                return accessor;
            }
            IWailaClientRegistration client = VanillaPlugin.CLIENT_REGISTRATION;
            if (client.getConfig().getPlugin().get(Identifiers.CORE_BLOCK_FACE)) {
                return accessor;
            }
            if (target.getBlock() instanceof TrappedChestBlock) {
                BlockState state = VanillaPlugin.getCorrespondingNormalChest(target.getBlockState());
                if (state != target.getBlockState()) {
                    return client.blockAccessor().from(target).blockState(state).build();
                }
            } else {
                if (target.getBlock() instanceof InfestedBlock) {
                    Block block = ((InfestedBlock)target.getBlock()).m_54192_();
                    return client.blockAccessor().from(target).blockState(block.m_49966_()).build();
                }
                if (target.getBlock() == Blocks.f_152499_) {
                    Block block = Blocks.f_50127_;
                    return client.blockAccessor().from(target).blockState(block.m_49966_()).build();
                }
            }
        }
        return accessor;
    }

    public static void drawBreakingProgress(ITooltip tooltip, Rect2i rect, PoseStack matrixStack, Accessor<?> accessor) {
        if (!PluginConfig.INSTANCE.get(Identifiers.MC_BREAKING_PROGRESS)) {
            progressAlpha = 0.0f;
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        MultiPlayerGameMode playerController = mc.f_91072_;
        if (playerController == null || playerController.f_105191_ == null) {
            return;
        }
        BlockState state = mc.f_91073_.m_8055_(playerController.f_105191_);
        if (playerController.m_105296_()) {
            canHarvest = PlatformProxy.isCorrectToolForDrops(state, (Player)mc.f_91074_);
        }
        int color = canHarvest ? 0xFFFFFF : 0xFF4444;
        int height = rect.m_110091_();
        int width = rect.m_110090_();
        if (!IWailaConfig.get().getOverlay().getSquare()) {
            --height;
            width -= 2;
        }
        progressAlpha += mc.m_91297_() * (playerController.m_105296_() ? 0.1f : -0.1f);
        if (playerController.m_105296_()) {
            progressAlpha = Math.min(progressAlpha, 0.53f);
            float progress = state.m_60625_((Player)mc.f_91074_, (BlockGetter)mc.f_91074_.f_19853_, playerController.f_105191_);
            if (playerController.f_105193_ + progress >= 1.0f) {
                progressAlpha = 1.0f;
            }
            progress = playerController.f_105193_ + mc.m_91296_() * progress;
            savedProgress = progress = Mth.m_14036_((float)progress, (float)0.0f, (float)1.0f);
        } else {
            progressAlpha = Math.max(progressAlpha, 0.0f);
        }
        color = IWailaConfig.IConfigOverlay.applyAlpha(color, progressAlpha);
        DisplayHelper.fill(matrixStack, 0.0f, (float)(height - 1), (float)width * savedProgress, (float)height, color);
    }

    public static MutableComponent format(String s, Object ... objects) {
        try {
            return Component.m_237113_((String)MessageFormat.format(I18n.m_118938_((String)s, (Object[])new Object[0]), objects));
        }
        catch (Exception e) {
            return Component.m_237110_((String)s, (Object[])objects);
        }
    }
}

