/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.harvest;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import snownee.jade.addon.harvest.ShearsToolHandler;
import snownee.jade.addon.harvest.SimpleToolHandler;
import snownee.jade.addon.harvest.SpecialToolHandler;
import snownee.jade.addon.harvest.ToolHandler;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.impl.ui.SubTextElement;
import snownee.jade.util.PlatformProxy;

public enum HarvestToolProvider implements IBlockComponentProvider,
ResourceManagerReloadListener
{
    INSTANCE;

    public static final Cache<BlockState, ImmutableList<ItemStack>> resultCache;
    public static final Map<String, ToolHandler> TOOL_HANDLERS;
    private static final Component UNBREAKABLE_TEXT;
    private static final Component CHECK;
    private static final Component X;
    private static final Vec2 ITEM_SIZE;

    @Nullable
    public static ImmutableList<ItemStack> getTool(BlockState state, Level world, BlockPos pos) {
        ImmutableList.Builder tools = ImmutableList.builder();
        for (ToolHandler handler : TOOL_HANDLERS.values()) {
            ItemStack tool = handler.test(state, world, pos);
            if (tool.m_41619_()) continue;
            tools.add((Object)tool);
        }
        return tools.build();
    }

    public static synchronized void registerHandler(ToolHandler handler) {
        TOOL_HANDLERS.put(handler.getName(), handler);
    }

    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        Player player = accessor.getPlayer();
        if (player.m_7500_() || player.m_5833_()) {
            return;
        }
        IElementHelper helper = tooltip.getElementHelper();
        BlockState state = accessor.getBlockState();
        float hardness = state.m_60800_((BlockGetter)accessor.getLevel(), accessor.getPosition());
        if (hardness < 0.0f) {
            if (config.get(Identifiers.MC_SHOW_UNBREAKABLE)) {
                tooltip.add(helper.text(UNBREAKABLE_TEXT).message(null));
            }
            return;
        }
        boolean newLine = config.get(Identifiers.MC_HARVEST_TOOL_NEW_LINE);
        List<IElement> elements = this.getText(accessor, config, tooltip.getElementHelper());
        if (elements.isEmpty()) {
            return;
        }
        elements.forEach(e -> e.message(null));
        if (newLine) {
            tooltip.add(elements);
        } else {
            elements.forEach(e -> e.align(IElement.Align.RIGHT));
            tooltip.append(0, elements);
        }
    }

    public List<IElement> getText(BlockAccessor accessor, IPluginConfig config, IElementHelper helper) {
        BlockState state = accessor.getBlockState();
        List tools = Collections.EMPTY_LIST;
        try {
            tools = (List)resultCache.get((Object)state, () -> HarvestToolProvider.getTool(state, accessor.getLevel(), accessor.getPosition()));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        if (tools.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        if (!state.m_60834_() && !config.get(Identifiers.MC_EFFECTIVE_TOOL)) {
            return Collections.EMPTY_LIST;
        }
        int offsetY = 0;
        if (!config.get(Identifiers.MC_HARVEST_TOOL_NEW_LINE)) {
            offsetY = -3;
        }
        ArrayList elements = Lists.newArrayList();
        for (ItemStack tool : tools) {
            elements.add(helper.item(tool, 0.75f).translate(new Vec2(-1.0f, (float)offsetY)).size(ITEM_SIZE).message(null));
        }
        if (!elements.isEmpty()) {
            elements.add(0, helper.spacer(5, 0));
            ItemStack held = accessor.getPlayer().m_21205_();
            boolean canHarvest = held.m_41735_(state);
            if (PlatformProxy.isShearable(state) && PlatformProxy.isShears(held)) {
                canHarvest = true;
            }
            if (state.m_60834_()) {
                Component sub = canHarvest ? CHECK : X;
                elements.add(new SubTextElement(sub).translate(new Vec2(-3.0f, (float)(7 + offsetY))));
            } else if (canHarvest) {
                elements.add(new SubTextElement(CHECK).translate(new Vec2(-3.0f, (float)(7 + offsetY))));
            }
        }
        return elements;
    }

    public void m_6213_(ResourceManager resourceManager) {
        resultCache.invalidateAll();
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.MC_HARVEST_TOOL;
    }

    @Override
    public int getDefaultPriority() {
        return -8000;
    }

    static {
        resultCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
        TOOL_HANDLERS = Maps.newLinkedHashMap();
        UNBREAKABLE_TEXT = Component.m_237115_((String)"jade.harvest_tool.unbreakable").m_130940_(ChatFormatting.DARK_RED);
        CHECK = Component.m_237113_((String)"\u2714").m_130940_(ChatFormatting.GREEN);
        X = Component.m_237113_((String)"\u2715").m_130940_(ChatFormatting.RED);
        ITEM_SIZE = new Vec2(10.0f, 0.0f);
        HarvestToolProvider.registerHandler(new SimpleToolHandler("pickaxe", (TagKey<Block>)BlockTags.f_144282_, Items.f_42422_, Items.f_42427_, Items.f_42385_, Items.f_42390_, Items.f_42395_));
        HarvestToolProvider.registerHandler(new SimpleToolHandler("axe", (TagKey<Block>)BlockTags.f_144280_, Items.f_42423_, Items.f_42428_, Items.f_42386_, Items.f_42391_, Items.f_42396_));
        HarvestToolProvider.registerHandler(new SimpleToolHandler("shovel", (TagKey<Block>)BlockTags.f_144283_, Items.f_42421_, Items.f_42426_, Items.f_42384_, Items.f_42389_, Items.f_42394_));
        HarvestToolProvider.registerHandler(new SimpleToolHandler("hoe", (TagKey<Block>)BlockTags.f_144281_, Items.f_42424_, Items.f_42429_, Items.f_42387_, Items.f_42392_, Items.f_42397_));
        SpecialToolHandler handler = new SpecialToolHandler("sword", Items.f_42420_.m_7968_());
        handler.blocks.add(Blocks.f_50033_);
        HarvestToolProvider.registerHandler(handler);
        HarvestToolProvider.registerHandler(new ShearsToolHandler());
    }
}

