/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.oreberriesreplanted.datagen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mrbysco.oreberriesreplanted.registry.OreBerryRegistry;
import com.mrbysco.oreberriesreplanted.worldgen.OreBerryFeatures;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.JsonCodecProvider;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class OreberryDatagen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        RegistryOps ops = RegistryOps.m_206821_((DynamicOps)JsonOps.INSTANCE, (RegistryAccess)RegistryAccess.m_206197_());
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper helper = event.getExistingFileHelper();
        if (event.includeServer()) {
            generator.m_236039_(event.includeServer(), (DataProvider)new OreBerryLoot(generator));
            OreberryBlockTags blockTagsProvider = new OreberryBlockTags(generator, helper);
            generator.m_236039_(event.includeServer(), (DataProvider)blockTagsProvider);
            generator.m_236039_(event.includeServer(), (DataProvider)new OreberryItemTags(generator, blockTagsProvider, helper));
            generator.m_236039_(event.includeServer(), (DataProvider)JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)helper, (String)"oreberriesreplanted", (RegistryOps)ops, (ResourceKey)Registry.f_194567_, OreberryDatagen.getConfiguredFeatures((RegistryOps<JsonElement>)ops)));
            generator.m_236039_(event.includeServer(), (DataProvider)JsonCodecProvider.forDatapackRegistry((DataGenerator)generator, (ExistingFileHelper)helper, (String)"oreberriesreplanted", (RegistryOps)ops, (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, OreberryDatagen.getBiomeModifiers((RegistryOps<JsonElement>)ops)));
        }
        if (event.includeClient()) {
            generator.m_236039_(event.includeServer(), (DataProvider)new OreBerryLanguage(generator));
            generator.m_236039_(event.includeServer(), (DataProvider)new OreBerryBlockStates(generator, helper));
            generator.m_236039_(event.includeServer(), (DataProvider)new OreBerryItemModels(generator, helper));
        }
    }

    public static Map<ResourceLocation, PlacedFeature> getConfiguredFeatures(RegistryOps<JsonElement> ops) {
        HashMap map = Maps.newHashMap();
        map.putAll(OreberryDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)OreBerryFeatures.IRON_OREBERRY_BUSH_FEATURE.m_203543_().orElseThrow()).m_195975_(Registry.f_122881_).get(), OreBerryFeatures.getPlacedFeature(-64, 64, 5)));
        map.putAll(OreberryDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)OreBerryFeatures.GOLD_OREBERRY_BUSH_FEATURE.m_203543_().orElseThrow()).m_195975_(Registry.f_122881_).get(), OreBerryFeatures.getPlacedFeature(-64, 32, 8)));
        map.putAll(OreberryDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)OreBerryFeatures.COPPER_OREBERRY_BUSH_FEATURE.m_203543_().orElseThrow()).m_195975_(Registry.f_122881_).get(), OreBerryFeatures.getPlacedFeature(-44, 60, 3)));
        map.putAll(OreberryDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)OreBerryFeatures.TIN_OREBERRY_BUSH_FEATURE.m_203543_().orElseThrow()).m_195975_(Registry.f_122881_).get(), OreBerryFeatures.getPlacedFeature(-44, 60, 3)));
        map.putAll(OreberryDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)OreBerryFeatures.ALUMINUM_OREBERRY_BUSH_FEATURE.m_203543_().orElseThrow()).m_195975_(Registry.f_122881_).get(), OreBerryFeatures.getPlacedFeature(-44, 60, 2)));
        map.putAll(OreberryDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)OreBerryFeatures.LEAD_OREBERRY_BUSH_FEATURE.m_203543_().orElseThrow()).m_195975_(Registry.f_122881_).get(), OreBerryFeatures.getPlacedFeature(-64, 40, 7)));
        map.putAll(OreberryDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)OreBerryFeatures.NICKEL_OREBERRY_BUSH_FEATURE.m_203543_().orElseThrow()).m_195975_(Registry.f_122881_).get(), OreBerryFeatures.getPlacedFeature(-64, 120, 5)));
        map.putAll(OreberryDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)OreBerryFeatures.URANIUM_OREBERRY_BUSH_FEATURE.m_203543_().orElseThrow()).m_195975_(Registry.f_122881_).get(), OreBerryFeatures.getPlacedFeature(-64, 60, 5)));
        map.putAll(OreberryDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)OreBerryFeatures.OSMIUM_OREBERRY_BUSH_FEATURE.m_203543_().orElseThrow()).m_195975_(Registry.f_122881_).get(), OreBerryFeatures.getPlacedFeature(-64, 60, 6)));
        map.putAll(OreberryDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)OreBerryFeatures.ZINC_OREBERRY_BUSH_FEATURE.m_203543_().orElseThrow()).m_195975_(Registry.f_122881_).get(), OreBerryFeatures.getPlacedFeature(-64, 70, 6)));
        map.putAll(OreberryDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)OreBerryFeatures.SILVER_OREBERRY_BUSH_FEATURE.m_203543_().orElseThrow()).m_195975_(Registry.f_122881_).get(), OreBerryFeatures.getPlacedFeature(-64, 40, 7)));
        map.putAll(OreberryDatagen.generateConfiguredFeature(ops, (ResourceKey)((ResourceKey)OreBerryFeatures.ESSENCE_BERRY_BUSH_FEATURE.m_203543_().orElseThrow()).m_195975_(Registry.f_122881_).get(), OreBerryFeatures.getPlacedFeature(-64, 32, 6)));
        return map;
    }

    private static Map<ResourceLocation, PlacedFeature> generateConfiguredFeature(RegistryOps<JsonElement> ops, ResourceKey<ConfiguredFeature<?, ?>> featureKey, List<PlacementModifier> modifiers) {
        Holder featureKeyHolder = ((Registry)ops.m_206826_(Registry.f_122881_).get()).m_214121_(featureKey);
        PlacedFeature feature = new PlacedFeature(featureKeyHolder, modifiers);
        return Map.of(featureKey.m_135782_(), feature);
    }

    public static Map<ResourceLocation, BiomeModifier> getBiomeModifiers(RegistryOps<JsonElement> ops) {
        HashMap map = Maps.newHashMap();
        map.putAll(OreberryDatagen.generateBiomeModifier(ops, ((ResourceKey)OreBerryFeatures.IRON_OREBERRY_BUSH_FEATURE.m_203543_().get()).m_135782_(), GenerationStep.Decoration.UNDERGROUND_ORES));
        map.putAll(OreberryDatagen.generateBiomeModifier(ops, ((ResourceKey)OreBerryFeatures.GOLD_OREBERRY_BUSH_FEATURE.m_203543_().get()).m_135782_(), GenerationStep.Decoration.UNDERGROUND_ORES));
        map.putAll(OreberryDatagen.generateBiomeModifier(ops, ((ResourceKey)OreBerryFeatures.COPPER_OREBERRY_BUSH_FEATURE.m_203543_().get()).m_135782_(), GenerationStep.Decoration.UNDERGROUND_ORES));
        map.putAll(OreberryDatagen.generateBiomeModifier(ops, ((ResourceKey)OreBerryFeatures.TIN_OREBERRY_BUSH_FEATURE.m_203543_().get()).m_135782_(), GenerationStep.Decoration.UNDERGROUND_ORES));
        map.putAll(OreberryDatagen.generateBiomeModifier(ops, ((ResourceKey)OreBerryFeatures.ALUMINUM_OREBERRY_BUSH_FEATURE.m_203543_().get()).m_135782_(), GenerationStep.Decoration.UNDERGROUND_ORES));
        map.putAll(OreberryDatagen.generateBiomeModifier(ops, ((ResourceKey)OreBerryFeatures.LEAD_OREBERRY_BUSH_FEATURE.m_203543_().get()).m_135782_(), GenerationStep.Decoration.UNDERGROUND_ORES));
        map.putAll(OreberryDatagen.generateBiomeModifier(ops, ((ResourceKey)OreBerryFeatures.NICKEL_OREBERRY_BUSH_FEATURE.m_203543_().get()).m_135782_(), GenerationStep.Decoration.UNDERGROUND_ORES));
        map.putAll(OreberryDatagen.generateBiomeModifier(ops, ((ResourceKey)OreBerryFeatures.URANIUM_OREBERRY_BUSH_FEATURE.m_203543_().get()).m_135782_(), GenerationStep.Decoration.UNDERGROUND_ORES));
        map.putAll(OreberryDatagen.generateBiomeModifier(ops, ((ResourceKey)OreBerryFeatures.OSMIUM_OREBERRY_BUSH_FEATURE.m_203543_().get()).m_135782_(), GenerationStep.Decoration.UNDERGROUND_ORES));
        map.putAll(OreberryDatagen.generateBiomeModifier(ops, ((ResourceKey)OreBerryFeatures.ZINC_OREBERRY_BUSH_FEATURE.m_203543_().get()).m_135782_(), GenerationStep.Decoration.UNDERGROUND_ORES));
        map.putAll(OreberryDatagen.generateBiomeModifier(ops, ((ResourceKey)OreBerryFeatures.SILVER_OREBERRY_BUSH_FEATURE.m_203543_().get()).m_135782_(), GenerationStep.Decoration.UNDERGROUND_ORES));
        map.putAll(OreberryDatagen.generateBiomeModifier(ops, ((ResourceKey)OreBerryFeatures.ESSENCE_BERRY_BUSH_FEATURE.m_203543_().get()).m_135782_(), GenerationStep.Decoration.UNDERGROUND_ORES));
        return map;
    }

    private static Map<ResourceLocation, BiomeModifier> generateBiomeModifier(RegistryOps<JsonElement> ops, ResourceLocation location, GenerationStep.Decoration decorationType) {
        HolderSet.Named IS_OVERWORLD = new HolderSet.Named((Registry)ops.m_206826_(Registry.f_122885_).orElseThrow(), BiomeTags.f_215817_);
        ForgeBiomeModifiers.AddFeaturesBiomeModifier addFeature = new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)IS_OVERWORLD, (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{((Registry)ops.m_206826_(Registry.f_194567_).get()).m_214121_(ResourceKey.m_135785_((ResourceKey)Registry.f_194567_, (ResourceLocation)location))}), decorationType);
        return Map.of(location, addFeature);
    }

    private static class OreBerryLoot
    extends LootTableProvider {
        public OreBerryLoot(DataGenerator gen) {
            super(gen);
        }

        protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
            return ImmutableList.of((Object)Pair.of(OreBerryBlocks::new, (Object)LootContextParamSets.f_81421_));
        }

        protected void validate(Map<ResourceLocation, LootTable> map, @Nonnull ValidationContext validationContext) {
            map.forEach((name, table) -> LootTables.m_79202_((ValidationContext)validationContext, (ResourceLocation)name, (LootTable)table));
        }

        private static class OreBerryBlocks
        extends BlockLoot {
            private OreBerryBlocks() {
            }

            protected void addTables() {
                this.m_124288_((Block)OreBerryRegistry.IRON_OREBERRY_BUSH.get());
                this.m_124288_((Block)OreBerryRegistry.GOLD_OREBERRY_BUSH.get());
                this.m_124288_((Block)OreBerryRegistry.COPPER_OREBERRY_BUSH.get());
                this.m_124288_((Block)OreBerryRegistry.TIN_OREBERRY_BUSH.get());
                this.m_124288_((Block)OreBerryRegistry.ALUMINUM_OREBERRY_BUSH.get());
                this.m_124288_((Block)OreBerryRegistry.LEAD_OREBERRY_BUSH.get());
                this.m_124288_((Block)OreBerryRegistry.NICKEL_OREBERRY_BUSH.get());
                this.m_124288_((Block)OreBerryRegistry.URANIUM_OREBERRY_BUSH.get());
                this.m_124288_((Block)OreBerryRegistry.OSMIUM_OREBERRY_BUSH.get());
                this.m_124288_((Block)OreBerryRegistry.ZINC_OREBERRY_BUSH.get());
                this.m_124288_((Block)OreBerryRegistry.SILVER_OREBERRY_BUSH.get());
                this.m_124288_((Block)OreBerryRegistry.ESSENCE_BERRY_BUSH.get());
                this.m_124252_((Block)OreBerryRegistry.POTTED_IRON_OREBERRY_BUSH.get());
                this.m_124252_((Block)OreBerryRegistry.POTTED_GOLD_OREBERRY_BUSH.get());
                this.m_124252_((Block)OreBerryRegistry.POTTED_COPPER_OREBERRY_BUSH.get());
                this.m_124252_((Block)OreBerryRegistry.POTTED_TIN_OREBERRY_BUSH.get());
                this.m_124252_((Block)OreBerryRegistry.POTTED_ALUMINUM_OREBERRY_BUSH.get());
                this.m_124252_((Block)OreBerryRegistry.POTTED_LEAD_OREBERRY_BUSH.get());
                this.m_124252_((Block)OreBerryRegistry.POTTED_NICKEL_OREBERRY_BUSH.get());
                this.m_124252_((Block)OreBerryRegistry.POTTED_URANIUM_OREBERRY_BUSH.get());
                this.m_124252_((Block)OreBerryRegistry.POTTED_OSMIUM_OREBERRY_BUSH.get());
                this.m_124252_((Block)OreBerryRegistry.POTTED_ZINC_OREBERRY_BUSH.get());
                this.m_124252_((Block)OreBerryRegistry.POTTED_SILVER_OREBERRY_BUSH.get());
                this.m_124252_((Block)OreBerryRegistry.POTTED_ESSENCE_BERRY_BUSH.get());
                this.m_124288_((Block)OreBerryRegistry.OAK_VAT.get());
                this.m_124288_((Block)OreBerryRegistry.SPRUCE_VAT.get());
                this.m_124288_((Block)OreBerryRegistry.BIRCH_VAT.get());
                this.m_124288_((Block)OreBerryRegistry.JUNGLE_VAT.get());
                this.m_124288_((Block)OreBerryRegistry.ACACIA_VAT.get());
                this.m_124288_((Block)OreBerryRegistry.DARK_OAK_VAT.get());
                this.m_124288_((Block)OreBerryRegistry.MANGROVE_VAT.get());
                this.m_124288_((Block)OreBerryRegistry.CRIMSON_VAT.get());
                this.m_124288_((Block)OreBerryRegistry.WARPED_VAT.get());
            }

            protected Iterable<Block> getKnownBlocks() {
                return OreBerryRegistry.BLOCKS.getEntries().stream().map(RegistryObject::get)::iterator;
            }
        }
    }

    public static class OreberryBlockTags
    extends BlockTagsProvider {
        public OreberryBlockTags(DataGenerator generator, @Nullable ExistingFileHelper existingFileHelper) {
            super(generator, "oreberriesreplanted", existingFileHelper);
        }

        protected void m_6577_() {
            this.m_206424_(BlockTags.f_144280_).m_126584_((Object[])new Block[]{(Block)OreBerryRegistry.OAK_VAT.get(), (Block)OreBerryRegistry.SPRUCE_VAT.get(), (Block)OreBerryRegistry.BIRCH_VAT.get(), (Block)OreBerryRegistry.JUNGLE_VAT.get(), (Block)OreBerryRegistry.ACACIA_VAT.get(), (Block)OreBerryRegistry.DARK_OAK_VAT.get(), (Block)OreBerryRegistry.MANGROVE_VAT.get(), (Block)OreBerryRegistry.CRIMSON_VAT.get(), (Block)OreBerryRegistry.WARPED_VAT.get()});
        }
    }

    public static class OreberryItemTags
    extends ItemTagsProvider {
        public static final TagKey<Item> NUGGETS_COPPER = OreberryItemTags.forgeTag("nuggets/copper");

        public OreberryItemTags(DataGenerator dataGenerator, BlockTagsProvider blockTagsProvider, @Nullable ExistingFileHelper existingFileHelper) {
            super(dataGenerator, blockTagsProvider, "oreberriesreplanted", existingFileHelper);
        }

        private static TagKey<Item> forgeTag(String name) {
            return ItemTags.create((ResourceLocation)new ResourceLocation("forge", name));
        }

        protected void m_6577_() {
            this.m_206424_(NUGGETS_COPPER).m_126582_((Object)((Item)OreBerryRegistry.COPPER_NUGGET.get()));
            this.m_206424_(Tags.Items.NUGGETS).m_206428_(NUGGETS_COPPER);
        }
    }

    private static class OreBerryLanguage
    extends LanguageProvider {
        public OreBerryLanguage(DataGenerator gen) {
            super(gen, "oreberriesreplanted", "en_us");
        }

        protected void addTranslations() {
            this.add("itemGroup.oreberriesreplanted", "Oreberries Replanted");
            this.addBlock((Supplier)OreBerryRegistry.IRON_OREBERRY_BUSH, "Iron Oreberry Bush");
            this.addBlock((Supplier)OreBerryRegistry.GOLD_OREBERRY_BUSH, "Gold Oreberry Bush");
            this.addBlock((Supplier)OreBerryRegistry.COPPER_OREBERRY_BUSH, "Copper Oreberry Bush");
            this.addBlock((Supplier)OreBerryRegistry.TIN_OREBERRY_BUSH, "Tin Oreberry Bush");
            this.addBlock((Supplier)OreBerryRegistry.ALUMINUM_OREBERRY_BUSH, "Aluminum Oreberry Bush");
            this.addBlock((Supplier)OreBerryRegistry.LEAD_OREBERRY_BUSH, "Lead Oreberry Bush");
            this.addBlock((Supplier)OreBerryRegistry.NICKEL_OREBERRY_BUSH, "Nickel Oreberry Bush");
            this.addBlock((Supplier)OreBerryRegistry.URANIUM_OREBERRY_BUSH, "Uranium Oreberry Bush");
            this.addBlock((Supplier)OreBerryRegistry.OSMIUM_OREBERRY_BUSH, "Osmium Oreberry Bush");
            this.addBlock((Supplier)OreBerryRegistry.ZINC_OREBERRY_BUSH, "Zinc Oreberry Bush");
            this.addBlock((Supplier)OreBerryRegistry.SILVER_OREBERRY_BUSH, "Silver Oreberry Bush");
            this.addBlock((Supplier)OreBerryRegistry.ESSENCE_BERRY_BUSH, "Essence Berry Bush");
            this.addBlock((Supplier)OreBerryRegistry.POTTED_IRON_OREBERRY_BUSH, "Potted Iron Oreberry Bush");
            this.addBlock((Supplier)OreBerryRegistry.POTTED_GOLD_OREBERRY_BUSH, "Potted Gold Oreberry Bush");
            this.addBlock((Supplier)OreBerryRegistry.POTTED_COPPER_OREBERRY_BUSH, "Potted Copper Oreberry Bush");
            this.addBlock((Supplier)OreBerryRegistry.POTTED_TIN_OREBERRY_BUSH, "Potted Tin Oreberry Bush");
            this.addBlock((Supplier)OreBerryRegistry.POTTED_ALUMINUM_OREBERRY_BUSH, "Potted Aluminum Oreberry Bush");
            this.addBlock((Supplier)OreBerryRegistry.POTTED_LEAD_OREBERRY_BUSH, "Potted Lead Oreberry Bush");
            this.addBlock((Supplier)OreBerryRegistry.POTTED_NICKEL_OREBERRY_BUSH, "Potted Nickel Oreberry Bush");
            this.addBlock((Supplier)OreBerryRegistry.POTTED_URANIUM_OREBERRY_BUSH, "Potted Uranium Oreberry Bush");
            this.addBlock((Supplier)OreBerryRegistry.POTTED_OSMIUM_OREBERRY_BUSH, "Potted Osmium Oreberry Bush");
            this.addBlock((Supplier)OreBerryRegistry.POTTED_ZINC_OREBERRY_BUSH, "Potted Zinc Oreberry Bush");
            this.addBlock((Supplier)OreBerryRegistry.POTTED_SILVER_OREBERRY_BUSH, "Potted Silver Oreberry Bush");
            this.addBlock((Supplier)OreBerryRegistry.POTTED_ESSENCE_BERRY_BUSH, "Potted Essence Berry Bush");
            this.addBlock((Supplier)OreBerryRegistry.OAK_VAT, "Oak Vat");
            this.addBlock((Supplier)OreBerryRegistry.SPRUCE_VAT, "Spruce Vat");
            this.addBlock((Supplier)OreBerryRegistry.BIRCH_VAT, "Birch Vat");
            this.addBlock((Supplier)OreBerryRegistry.JUNGLE_VAT, "Jungle Vat");
            this.addBlock((Supplier)OreBerryRegistry.ACACIA_VAT, "Acacia Vat");
            this.addBlock((Supplier)OreBerryRegistry.DARK_OAK_VAT, "Oak Vat");
            this.addBlock((Supplier)OreBerryRegistry.MANGROVE_VAT, "Mangrove Vat");
            this.addBlock((Supplier)OreBerryRegistry.CRIMSON_VAT, "Crimson Vat");
            this.addBlock((Supplier)OreBerryRegistry.WARPED_VAT, "Warped Vat");
            this.addItem((Supplier)OreBerryRegistry.IRON_OREBERRY, "Iron Oreberry");
            this.addItem((Supplier)OreBerryRegistry.GOLD_OREBERRY, "Gold Oreberry");
            this.addItem((Supplier)OreBerryRegistry.COPPER_OREBERRY, "Copper Oreberry");
            this.addItem((Supplier)OreBerryRegistry.TIN_OREBERRY, "Tin Oreberry");
            this.addItem((Supplier)OreBerryRegistry.ALUMINUM_OREBERRY, "Aluminum Oreberry");
            this.addItem((Supplier)OreBerryRegistry.LEAD_OREBERRY, "Lead Oreberry");
            this.addItem((Supplier)OreBerryRegistry.NICKEL_OREBERRY, "Nickel Oreberry");
            this.addItem((Supplier)OreBerryRegistry.URANIUM_OREBERRY, "Uranium Oreberry");
            this.addItem((Supplier)OreBerryRegistry.OSMIUM_OREBERRY, "Osmium Oreberry");
            this.addItem((Supplier)OreBerryRegistry.ZINC_OREBERRY, "Zinc Oreberry");
            this.addItem((Supplier)OreBerryRegistry.SILVER_OREBERRY, "Silver Oreberry");
            this.addItem((Supplier)OreBerryRegistry.ESSENCE_BERRY, "Concentrated Essence Berry");
            this.addItem((Supplier)OreBerryRegistry.IRON_OREBERRY_JUICE.getBucket(), "Iron Oreberry Juice Bucket");
            this.addItem((Supplier)OreBerryRegistry.GOLD_OREBERRY_JUICE.getBucket(), "Gold Oreberry Juice Bucket");
            this.addItem((Supplier)OreBerryRegistry.COPPER_OREBERRY_JUICE.getBucket(), "Copper Oreberry Juice Bucket");
            this.addItem((Supplier)OreBerryRegistry.TIN_OREBERRY_JUICE.getBucket(), "Tin Oreberry Juice Bucket");
            this.addItem((Supplier)OreBerryRegistry.ALUMINUM_OREBERRY_JUICE.getBucket(), "Aluminum Oreberry Juice Bucket");
            this.addItem((Supplier)OreBerryRegistry.LEAD_OREBERRY_JUICE.getBucket(), "Lead Oreberry Juice Bucket");
            this.addItem((Supplier)OreBerryRegistry.NICKEL_OREBERRY_JUICE.getBucket(), "Nickel Oreberry Juice Bucket");
            this.addItem((Supplier)OreBerryRegistry.URANIUM_OREBERRY_JUICE.getBucket(), "Uranium Oreberry Juice Bucket");
            this.addItem((Supplier)OreBerryRegistry.OSMIUM_OREBERRY_JUICE.getBucket(), "Osmium Oreberry Juice Bucket");
            this.addItem((Supplier)OreBerryRegistry.ZINC_OREBERRY_JUICE.getBucket(), "Zinc Oreberry Juice Bucket");
            this.addItem((Supplier)OreBerryRegistry.SILVER_OREBERRY_JUICE.getBucket(), "Silver Oreberry Juice Bucket");
            this.addItem((Supplier)OreBerryRegistry.COPPER_NUGGET, "Copper Nugget");
            this.addFluid(OreBerryRegistry.IRON_OREBERRY_JUICE.getSource(), "Iron Oreberry Juice");
            this.addFluid(OreBerryRegistry.GOLD_OREBERRY_JUICE.getSource(), "Gold Oreberry Juice");
            this.addFluid(OreBerryRegistry.COPPER_OREBERRY_JUICE.getSource(), "Copper Oreberry Juice");
            this.addFluid(OreBerryRegistry.TIN_OREBERRY_JUICE.getSource(), "Tin Oreberry Juice");
            this.addFluid(OreBerryRegistry.ALUMINUM_OREBERRY_JUICE.getSource(), "Aluminum Oreberry Juice");
            this.addFluid(OreBerryRegistry.LEAD_OREBERRY_JUICE.getSource(), "Lead Oreberry Juice");
            this.addFluid(OreBerryRegistry.NICKEL_OREBERRY_JUICE.getSource(), "Nickel Oreberry Juice");
            this.addFluid(OreBerryRegistry.URANIUM_OREBERRY_JUICE.getSource(), "Uranium Oreberry Juice");
            this.addFluid(OreBerryRegistry.OSMIUM_OREBERRY_JUICE.getSource(), "Osmium Oreberry Juice");
            this.addFluid(OreBerryRegistry.ZINC_OREBERRY_JUICE.getSource(), "Zinc Oreberry Juice");
            this.addFluid(OreBerryRegistry.SILVER_OREBERRY_JUICE.getSource(), "Silver Oreberry Juice");
            this.add("oreberriesreplanted.iron_oreberry.tooltip", "Sweet Irony");
            this.add("oreberriesreplanted.gold_oreberry.tooltip", "To barter for");
            this.add("oreberriesreplanted.copper_oreberry.tooltip", "Tastes like metal");
            this.add("oreberriesreplanted.tin_oreberry.tooltip", "Tin Man");
            this.add("oreberriesreplanted.aluminum_oreberry.tooltip", "White Chocolate");
            this.add("oreberriesreplanted.silver_oreberry.tooltip", "Now with less werewolves");
            this.add("oreberriesreplanted.lead_oreberry.tooltip", "Would not eat, may be poisonous");
            this.add("oreberriesreplanted.nickel_oreberry.tooltip", "If I had a nickel for every one I found");
            this.add("oreberriesreplanted.uranium_oreberry.tooltip", "RADIOACTIVE, RADIOACTIVE!");
            this.add("oreberriesreplanted.osmium_oreberry.tooltip", "I am blue Da ba dee da ba di");
            this.add("oreberriesreplanted.zinc_oreberry.tooltip", "Let that one Zinc in");
            this.add("oreberriesreplanted.essence_berry.tooltip", "Tastes like Creeper");
            this.add("oreberriesreplanted.gui.jei.category.vat", "Vat Crushing");
            this.add("oreberriesreplanted.gui.jei.category.vat.tooltip", "Produces approximately %s to %smb worth of %s");
            this.add("oreberriesreplanted.gui.jei.category.vat_output.tooltip", "Produces 1 nugget per %smb");
        }

        private void addFluid(RegistryObject<ForgeFlowingFluid> fluid, String name) {
            ResourceLocation id = fluid.getId();
            this.add("fluid." + id.m_135827_() + "." + id.m_135815_(), name);
        }
    }

    private static class OreBerryBlockStates
    extends BlockStateProvider {
        public OreBerryBlockStates(DataGenerator gen, ExistingFileHelper helper) {
            super(gen, "oreberriesreplanted", helper);
        }

        protected void registerStatesAndModels() {
            this.makeBush((Block)OreBerryRegistry.IRON_OREBERRY_BUSH.get(), "iron");
            this.makeBush((Block)OreBerryRegistry.GOLD_OREBERRY_BUSH.get(), "gold");
            this.makeBush((Block)OreBerryRegistry.COPPER_OREBERRY_BUSH.get(), "copper");
            this.makeBush((Block)OreBerryRegistry.TIN_OREBERRY_BUSH.get(), "tin");
            this.makeBush((Block)OreBerryRegistry.ALUMINUM_OREBERRY_BUSH.get(), "aluminum");
            this.makeBush((Block)OreBerryRegistry.LEAD_OREBERRY_BUSH.get(), "lead");
            this.makeBush((Block)OreBerryRegistry.NICKEL_OREBERRY_BUSH.get(), "nickel");
            this.makeBush((Block)OreBerryRegistry.URANIUM_OREBERRY_BUSH.get(), "uranium");
            this.makeBush((Block)OreBerryRegistry.OSMIUM_OREBERRY_BUSH.get(), "osmium");
            this.makeBush((Block)OreBerryRegistry.ZINC_OREBERRY_BUSH.get(), "zinc");
            this.makeBush((Block)OreBerryRegistry.SILVER_OREBERRY_BUSH.get(), "silver");
            this.makeBush((Block)OreBerryRegistry.ESSENCE_BERRY_BUSH.get(), "essence");
            this.makePottedBush((Block)OreBerryRegistry.POTTED_IRON_OREBERRY_BUSH.get(), "iron");
            this.makePottedBush((Block)OreBerryRegistry.POTTED_GOLD_OREBERRY_BUSH.get(), "gold");
            this.makePottedBush((Block)OreBerryRegistry.POTTED_COPPER_OREBERRY_BUSH.get(), "copper");
            this.makePottedBush((Block)OreBerryRegistry.POTTED_TIN_OREBERRY_BUSH.get(), "tin");
            this.makePottedBush((Block)OreBerryRegistry.POTTED_ALUMINUM_OREBERRY_BUSH.get(), "aluminum");
            this.makePottedBush((Block)OreBerryRegistry.POTTED_LEAD_OREBERRY_BUSH.get(), "lead");
            this.makePottedBush((Block)OreBerryRegistry.POTTED_NICKEL_OREBERRY_BUSH.get(), "nickel");
            this.makePottedBush((Block)OreBerryRegistry.POTTED_URANIUM_OREBERRY_BUSH.get(), "uranium");
            this.makePottedBush((Block)OreBerryRegistry.POTTED_OSMIUM_OREBERRY_BUSH.get(), "osmium");
            this.makePottedBush((Block)OreBerryRegistry.POTTED_ZINC_OREBERRY_BUSH.get(), "zinc");
            this.makePottedBush((Block)OreBerryRegistry.POTTED_SILVER_OREBERRY_BUSH.get(), "silver");
            this.makePottedBush((Block)OreBerryRegistry.POTTED_ESSENCE_BERRY_BUSH.get(), "essence");
            this.makeVat((Block)OreBerryRegistry.OAK_VAT.get(), this.mcLoc("block/oak_planks"));
            this.makeVat((Block)OreBerryRegistry.SPRUCE_VAT.get(), this.mcLoc("block/spruce_planks"));
            this.makeVat((Block)OreBerryRegistry.BIRCH_VAT.get(), this.mcLoc("block/birch_planks"));
            this.makeVat((Block)OreBerryRegistry.JUNGLE_VAT.get(), this.mcLoc("block/jungle_planks"));
            this.makeVat((Block)OreBerryRegistry.ACACIA_VAT.get(), this.mcLoc("block/acacia_planks"));
            this.makeVat((Block)OreBerryRegistry.DARK_OAK_VAT.get(), this.mcLoc("block/dark_oak_planks"));
            this.makeVat((Block)OreBerryRegistry.MANGROVE_VAT.get(), this.mcLoc("block/mangrove_planks"));
            this.makeVat((Block)OreBerryRegistry.CRIMSON_VAT.get(), this.mcLoc("block/crimson_planks"));
            this.makeVat((Block)OreBerryRegistry.WARPED_VAT.get(), this.mcLoc("block/warped_planks"));
        }

        private void makeBush(Block block, String type) {
            ModelBuilder age0 = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_() + "_stage0")).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/base/oreberry_stage0")))).texture("all", "block/" + type + "_oreberry")).renderType("cutout_mipped");
            ModelBuilder age1 = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_() + "_stage1")).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/base/oreberry_stage1")))).texture("all", "block/" + type + "_oreberry")).renderType("cutout_mipped");
            ModelBuilder age2 = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_() + "_stage2")).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/base/oreberry_stage2")))).texture("all", "block/" + type + "_oreberry")).renderType("cutout_mipped");
            ModelBuilder age3 = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_() + "_stage3")).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/base/oreberry_stage2")))).texture("all", "block/" + type + "_oreberry_ripe")).renderType("cutout_mipped");
            ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().with((Property)BlockStateProperties.f_61407_, (Comparable)Integer.valueOf(0)).modelForState().modelFile((ModelFile)age0).addModel()).partialState().with((Property)BlockStateProperties.f_61407_, (Comparable)Integer.valueOf(1)).modelForState().modelFile((ModelFile)age1).addModel()).partialState().with((Property)BlockStateProperties.f_61407_, (Comparable)Integer.valueOf(2)).modelForState().modelFile((ModelFile)age2).addModel()).partialState().with((Property)BlockStateProperties.f_61407_, (Comparable)Integer.valueOf(3)).modelForState().modelFile((ModelFile)age3).addModel();
        }

        private void makePottedBush(Block block, String type) {
            ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_())).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/base/flower_pot_bush")))).texture("bush", "block/" + type + "_oreberry_ripe")).renderType("cutout_mipped");
            this.getVariantBuilder(block).forAllStates(arg_0 -> OreBerryBlockStates.lambda$makePottedBush$0((ModelFile)model, arg_0));
        }

        private void makeVat(Block block, ResourceLocation planks) {
            ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_())).parent((ModelFile)this.models().getExistingFile(this.modLoc("block/vat/vat_base")))).texture("0", planks);
            this.getVariantBuilder(block).forAllStates(arg_0 -> OreBerryBlockStates.lambda$makeVat$1((ModelFile)model, arg_0));
        }

        private static /* synthetic */ ConfiguredModel[] lambda$makeVat$1(ModelFile model, BlockState state) {
            return ConfiguredModel.builder().modelFile(model).build();
        }

        private static /* synthetic */ ConfiguredModel[] lambda$makePottedBush$0(ModelFile model, BlockState state) {
            return ConfiguredModel.builder().modelFile(model).build();
        }
    }

    private static class OreBerryItemModels
    extends ItemModelProvider {
        public OreBerryItemModels(DataGenerator gen, ExistingFileHelper helper) {
            super(gen, "oreberriesreplanted", helper);
        }

        protected void registerModels() {
            this.withParent((Item)OreBerryRegistry.IRON_OREBERRY_BUSH_ITEM.get(), this.modLoc("block/iron_oreberry_bush_stage1"));
            this.withParent((Item)OreBerryRegistry.GOLD_OREBERRY_BUSH_ITEM.get(), this.modLoc("block/gold_oreberry_bush_stage1"));
            this.withParent((Item)OreBerryRegistry.COPPER_OREBERRY_BUSH_ITEM.get(), this.modLoc("block/copper_oreberry_bush_stage1"));
            this.withParent((Item)OreBerryRegistry.TIN_OREBERRY_BUSH_ITEM.get(), this.modLoc("block/tin_oreberry_bush_stage1"));
            this.withParent((Item)OreBerryRegistry.ALUMINUM_OREBERRY_BUSH_ITEM.get(), this.modLoc("block/aluminum_oreberry_bush_stage1"));
            this.withParent((Item)OreBerryRegistry.LEAD_OREBERRY_BUSH_ITEM.get(), this.modLoc("block/lead_oreberry_bush_stage1"));
            this.withParent((Item)OreBerryRegistry.NICKEL_OREBERRY_BUSH_ITEM.get(), this.modLoc("block/nickel_oreberry_bush_stage1"));
            this.withParent((Item)OreBerryRegistry.URANIUM_OREBERRY_BUSH_ITEM.get(), this.modLoc("block/uranium_oreberry_bush_stage1"));
            this.withParent((Item)OreBerryRegistry.OSMIUM_OREBERRY_BUSH_ITEM.get(), this.modLoc("block/osmium_oreberry_bush_stage1"));
            this.withParent((Item)OreBerryRegistry.ZINC_OREBERRY_BUSH_ITEM.get(), this.modLoc("block/zinc_oreberry_bush_stage1"));
            this.withParent((Item)OreBerryRegistry.SILVER_OREBERRY_BUSH_ITEM.get(), this.modLoc("block/silver_oreberry_bush_stage1"));
            this.withParent((Item)OreBerryRegistry.ESSENCE_BERRY_BUSH_ITEM.get(), this.modLoc("block/essence_berry_bush_stage1"));
            this.withParent((Item)OreBerryRegistry.OAK_VAT_ITEM.get(), this.modLoc("block/" + OreBerryRegistry.OAK_VAT.getId().m_135815_()));
            this.withParent((Item)OreBerryRegistry.SPRUCE_VAT_ITEM.get(), this.modLoc("block/" + OreBerryRegistry.SPRUCE_VAT.getId().m_135815_()));
            this.withParent((Item)OreBerryRegistry.BIRCH_VAT_ITEM.get(), this.modLoc("block/" + OreBerryRegistry.BIRCH_VAT.getId().m_135815_()));
            this.withParent((Item)OreBerryRegistry.JUNGLE_VAT_ITEM.get(), this.modLoc("block/" + OreBerryRegistry.JUNGLE_VAT.getId().m_135815_()));
            this.withParent((Item)OreBerryRegistry.ACACIA_VAT_ITEM.get(), this.modLoc("block/" + OreBerryRegistry.ACACIA_VAT.getId().m_135815_()));
            this.withParent((Item)OreBerryRegistry.DARK_OAK_VAT_ITEM.get(), this.modLoc("block/" + OreBerryRegistry.DARK_OAK_VAT.getId().m_135815_()));
            this.withParent((Item)OreBerryRegistry.MANGROVE_VAT_ITEM.get(), this.modLoc("block/" + OreBerryRegistry.MANGROVE_VAT.getId().m_135815_()));
            this.withParent((Item)OreBerryRegistry.CRIMSON_VAT_ITEM.get(), this.modLoc("block/" + OreBerryRegistry.CRIMSON_VAT.getId().m_135815_()));
            this.withParent((Item)OreBerryRegistry.WARPED_VAT_ITEM.get(), this.modLoc("block/" + OreBerryRegistry.WARPED_VAT.getId().m_135815_()));
            this.singleTexture(OreBerryRegistry.COPPER_NUGGET.getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/copper_nugget"));
            this.singleTexture(OreBerryRegistry.IRON_OREBERRY.getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/iron_oreberry"));
            this.singleTexture(OreBerryRegistry.GOLD_OREBERRY.getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/gold_oreberry"));
            this.singleTexture(OreBerryRegistry.COPPER_OREBERRY.getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/copper_oreberry"));
            this.singleTexture(OreBerryRegistry.TIN_OREBERRY.getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/tin_oreberry"));
            this.singleTexture(OreBerryRegistry.ALUMINUM_OREBERRY.getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/aluminum_oreberry"));
            this.singleTexture(OreBerryRegistry.LEAD_OREBERRY.getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/lead_oreberry"));
            this.singleTexture(OreBerryRegistry.NICKEL_OREBERRY.getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/nickel_oreberry"));
            this.singleTexture(OreBerryRegistry.URANIUM_OREBERRY.getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/uranium_oreberry"));
            this.singleTexture(OreBerryRegistry.OSMIUM_OREBERRY.getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/osmium_oreberry"));
            this.singleTexture(OreBerryRegistry.ZINC_OREBERRY.getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/zinc_oreberry"));
            this.singleTexture(OreBerryRegistry.SILVER_OREBERRY.getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/silver_oreberry"));
            this.singleTexture(OreBerryRegistry.ESSENCE_BERRY.getId().m_135815_(), this.mcLoc("item/generated"), "layer0", this.modLoc("item/essence_berry"));
        }

        private void withParent(Item item, ResourceLocation parent) {
            this.withExistingParent(ForgeRegistries.ITEMS.getKey((Object)item).m_135815_(), parent);
        }
    }
}

