/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.dragon.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.Label;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.base.config.LoadFeature;
import insane96mcp.insanelib.entity.AreaEffectCloud3DEntity;
import insane96mcp.insanelib.util.MathHelper;
import insane96mcp.progressivebosses.module.dragon.feature.DifficultyFeature;
import insane96mcp.progressivebosses.setup.Reflection;
import insane96mcp.progressivebosses.utils.DifficultyHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonChargePlayerPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonStrafePlayerPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.DragonFireball;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Label(name="Attack", description="Makes the dragon hit harder in various different ways")
@LoadFeature(module="progressivebosses:ender_dragon")
public class AttackFeature
extends Feature {
    @Config(min=0.0)
    @Label(name="Bonus Direct Damage", description="How much more damage at max difficulty (percentage) does the Ender Dragon deal per difficulty?")
    public static Double increasedDirectDamage = 2.25;
    @Config(min=0.0)
    @Label(name="Bonus Acid Pool Damage", description="How much more damage at max difficulty (percentage) does the Ender Dragon's Acid fireball and pool deal per difficulty?")
    public static Double increasedAcidPoolDamage = 2.4;
    @Config(min=0.0)
    @Label(name="Charge Player Max Chance", description="Normally the Ender Dragon attacks only when leaving the center platform. With this active she has a chance when she has finished charging / fireballing or before checking if she should land in the center to charge the player.\nThis is the chance to start a charge attack when the difficulty is at max. Otherwise it scales accordingly.\nThe actual chance is: (this_value * (difficulty / max difficulty)).")
    public static Double chargePlayerMaxChance = 0.45;
    @Config(min=0.0)
    @Label(name="Fireball Max Chance", description="Normally the Ender Dragon spits fireballs when a Crystal is destroyed and rarely during the fight. With this active she has a chance when she has finished charging / fireballing or before checking if she should land in the center to spit a fireball.\nThis is the chance to start a fireball attack when the difficulty is at max. Otherwise it scales accordingly.\nThe actual chance is: (this_value * (difficulty / max difficulty)).")
    public static Double fireballMaxChance = 0.35;
    @Config
    @Label(name="Increase Max Rise and Fall", description="Since around 1.13/1.14 the Ender Dragon can no longer dive for more than about 3 blocks so she takes a lot to rise / fall. With this active the dragon will be able to rise and fall many more blocks, making easier to hit the player and approach the center.")
    public static Boolean increaseMaxRiseAndFall = true;
    @Config
    @Label(name="Fireball Explosion Magic Damage", description="On impact the Acid Fireball will deal magic damage in an area.")
    public static Boolean fireballExplosionDamages = true;
    @Config
    @Label(name="Fireball 3D Area Effect Cloud", description="On impact the Acid Fireball will generate a 3D area of effect cloud instead of a normal flat one. The 3D cloud lasts for half the time.")
    public static Boolean fireball3DEffectCloud = true;
    @Config(min=0.0)
    @Label(name="Fireball Velocity Multiplier", description="Speed multiplier for the Dragon Fireball.")
    public static Double fireballVelocityMultiplier = 2.5;
    @Config(min=0.0)
    @Label(name="Bonus Fireballs", description="The dragon will fire (up to) this more fireballs at max difficulty. The bonus fireballs have a slight shotting error so aren't all directly aimed at the player.")
    public static Double maxBonusFireball = 15.0;

    public AttackFeature(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    @SubscribeEvent
    public void onSpawn(EntityJoinLevelEvent event) {
        this.fireballSpeed(event.getEntity());
    }

    private void fireballSpeed(Entity entity) {
        if (!(entity instanceof DragonFireball)) {
            return;
        }
        DragonFireball fireball = (DragonFireball)entity;
        if (!this.isEnabled() || fireballVelocityMultiplier == 0.0) {
            return;
        }
        if (Math.abs(fireball.f_36813_) > 10.0 || Math.abs(fireball.f_36814_) > 10.0 || Math.abs(fireball.f_36815_) > 10.0) {
            entity.m_6074_();
            return;
        }
        fireball.f_36813_ *= fireballVelocityMultiplier.doubleValue();
        fireball.f_36814_ *= fireballVelocityMultiplier.doubleValue();
        fireball.f_36815_ *= fireballVelocityMultiplier.doubleValue();
    }

    @SubscribeEvent
    public void onDamageDealt(LivingHurtEvent event) {
        if (!this.isEnabled() || event.getEntity().m_20193_().f_46443_) {
            return;
        }
        AttackFeature.onDirectDamage(event);
        AttackFeature.onAcidDamage(event);
    }

    private static void onDirectDamage(LivingHurtEvent event) {
        EnderDragon dragon;
        block3: {
            block2: {
                Entity entity = event.getSource().m_7640_();
                if (!(entity instanceof EnderDragon)) break block2;
                dragon = (EnderDragon)entity;
                if (!(event.getEntity() instanceof EnderDragon)) break block3;
            }
            return;
        }
        event.setAmount(event.getAmount() * (float)(1.0 + increasedDirectDamage * (double)DifficultyHelper.getScalingDifficulty((LivingEntity)dragon)));
    }

    private static void onAcidDamage(LivingHurtEvent event) {
        EnderDragon dragon;
        block3: {
            block2: {
                Entity entity = event.getSource().m_7639_();
                if (!(entity instanceof EnderDragon)) break block2;
                dragon = (EnderDragon)entity;
                if (event.getSource().m_7640_() instanceof AreaEffectCloud) break block3;
            }
            return;
        }
        event.setAmount(event.getAmount() * (float)(1.0 + increasedAcidPoolDamage * (double)DifficultyHelper.getScalingDifficulty((LivingEntity)dragon)));
    }

    public static boolean onPhaseEnd(EnderDragon dragon) {
        boolean chargePlayer = AttackFeature.shouldChargePlayer(dragon);
        boolean fireballPlayer = AttackFeature.shouldFireballPlayer(dragon);
        if (chargePlayer && fireballPlayer) {
            if (dragon.m_217043_().m_188501_() < 0.5f) {
                AttackFeature.chargePlayer(dragon);
            } else {
                AttackFeature.fireballPlayer(dragon);
            }
        } else if (chargePlayer) {
            AttackFeature.chargePlayer(dragon);
        } else if (fireballPlayer) {
            AttackFeature.fireballPlayer(dragon);
        }
        return chargePlayer || fireballPlayer;
    }

    private static boolean shouldChargePlayer(EnderDragon dragon) {
        double rng;
        if (chargePlayerMaxChance == 0.0) {
            return false;
        }
        if (dragon.m_31158_() == null) {
            return false;
        }
        CompoundTag tags = dragon.getPersistentData();
        float difficulty = tags.m_128457_("progressivebosses:difficulty");
        double chance = chargePlayerMaxChance * (double)(difficulty / (float)DifficultyFeature.maxDifficulty.intValue());
        BlockPos centerPodium = dragon.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.f_65714_);
        AABB boundingBox = new AABB(centerPodium).m_82400_(64.0);
        List players = dragon.f_19853_.m_6443_(Player.class, boundingBox, EntitySelector.f_20406_);
        for (Player player : players) {
            List endCrystals = player.f_19853_.m_45976_(EndCrystal.class, player.m_20191_().m_82400_(10.0));
            if (endCrystals.size() <= 0) continue;
            chance *= 2.0;
            break;
        }
        return (rng = dragon.m_217043_().m_188500_()) < chance;
    }

    private static void chargePlayer(EnderDragon dragon) {
        BlockPos centerPodium = dragon.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.f_65714_);
        AABB bb = new AABB(centerPodium).m_82400_(64.0);
        ServerPlayer player = (ServerPlayer)AttackFeature.getRandomPlayerNearCrystal(dragon.f_19853_, bb);
        if (player == null) {
            return;
        }
        dragon.m_31157_().m_31416_(EnderDragonPhase.f_31385_);
        Vec3 targetPos = player.m_20182_();
        targetPos = targetPos.f_82480_ < dragon.m_20186_() ? targetPos.m_82520_(0.0, -5.0, 0.0) : targetPos.m_82520_(0.0, 6.0, 0.0);
        ((DragonChargePlayerPhase)dragon.m_31157_().m_31418_(EnderDragonPhase.f_31385_)).m_31207_(targetPos);
    }

    private static boolean shouldFireballPlayer(EnderDragon dragon) {
        if (fireballMaxChance == 0.0 || dragon.m_31158_() == null) {
            return false;
        }
        CompoundTag tags = dragon.getPersistentData();
        float difficulty = tags.m_128457_("progressivebosses:difficulty");
        if (difficulty == 0.0f) {
            return false;
        }
        double chance = fireballMaxChance * (double)(difficulty / (float)DifficultyFeature.maxDifficulty.intValue());
        double rng = dragon.m_217043_().m_188500_();
        return rng < chance;
    }

    private static void fireballPlayer(EnderDragon dragon) {
        BlockPos centerPodium = dragon.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.f_65714_);
        AABB bb = new AABB(centerPodium).m_82400_(64.0);
        ServerPlayer player = (ServerPlayer)AttackFeature.getRandomPlayer(dragon.f_19853_, bb);
        if (player == null) {
            return;
        }
        dragon.m_31157_().m_31416_(EnderDragonPhase.f_31378_);
        ((DragonStrafePlayerPhase)dragon.m_31157_().m_31418_(EnderDragonPhase.f_31378_)).m_31358_((LivingEntity)player);
    }

    public static boolean onFireballImpact(DragonFireball fireball, @Nullable Entity shooter, HitResult result) {
        if (!AttackFeature.isEnabled(AttackFeature.class)) {
            return false;
        }
        AttackFeature.onImpactExplosion(fireball, shooter, result);
        return AttackFeature.onImpact3DCloud(fireball, result);
    }

    private static void onImpactExplosion(DragonFireball fireball, @Nullable Entity shooter, HitResult result) {
        if (!fireballExplosionDamages.booleanValue()) {
            return;
        }
        float difficultyScaling = 0.0f;
        if (shooter instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)shooter;
            difficultyScaling = DifficultyHelper.getScalingDifficulty(livingEntity);
        }
        float damage = 6.0f * (1.0f + (float)(increasedAcidPoolDamage * (double)difficultyScaling));
        AABB axisAlignedBB = new AABB(result.m_82450_(), result.m_82450_()).m_82400_(4.0);
        List livingEntities = fireball.f_19853_.m_45976_(LivingEntity.class, axisAlignedBB);
        for (LivingEntity livingEntity : livingEntities) {
            if (!(livingEntity.m_20238_(fireball.m_20182_()) < 20.25)) continue;
            livingEntity.m_6469_(new IndirectEntityDamageSource("progressivebosses:dragon_fireball", (Entity)fireball, shooter).m_19380_().m_19366_().m_19389_(), damage);
        }
    }

    private static boolean onImpact3DCloud(DragonFireball fireball, HitResult result) {
        if (!fireball3DEffectCloud.booleanValue()) {
            return false;
        }
        HitResult.Type hitResult$type = result.m_6662_();
        if (hitResult$type == HitResult.Type.ENTITY) {
            Reflection.Projectile_onHitEntity((Projectile)fireball, (EntityHitResult)result);
        } else if (hitResult$type == HitResult.Type.BLOCK) {
            Reflection.Projectile_onHitBlock((Projectile)fireball, (BlockHitResult)result);
        }
        Entity entity = fireball.m_37282_();
        if (!(entity == null || result.m_6662_() == HitResult.Type.ENTITY && ((EntityHitResult)result).m_82443_().m_7306_(entity) || fireball.f_19853_.f_46443_)) {
            List list = fireball.f_19853_.m_45976_(LivingEntity.class, fireball.m_20191_().m_82377_(4.0, 2.0, 4.0));
            AreaEffectCloud3DEntity areaeffectcloudentity = new AreaEffectCloud3DEntity(fireball.f_19853_, fireball.m_20185_(), fireball.m_20186_(), fireball.m_20189_());
            if (entity instanceof LivingEntity) {
                areaeffectcloudentity.m_19718_((LivingEntity)entity);
            }
            areaeffectcloudentity.m_19724_((ParticleOptions)ParticleTypes.f_123799_);
            areaeffectcloudentity.m_19712_(3.0f);
            areaeffectcloudentity.m_19734_(300);
            areaeffectcloudentity.m_19740_(10);
            areaeffectcloudentity.m_19738_((7.0f - areaeffectcloudentity.m_19743_()) / (float)areaeffectcloudentity.m_19748_());
            areaeffectcloudentity.m_19716_(new MobEffectInstance(MobEffects.f_19602_, 1, 1));
            if (!list.isEmpty()) {
                for (LivingEntity livingentity : list) {
                    double d0 = fireball.m_20280_((Entity)livingentity);
                    if (!(d0 < 16.0)) continue;
                    areaeffectcloudentity.m_6034_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
                    break;
                }
            }
            fireball.f_19853_.m_46796_(2006, fireball.m_20183_(), fireball.m_20067_() ? -1 : 1);
            fireball.f_19853_.m_7967_((Entity)areaeffectcloudentity);
            fireball.m_146870_();
        }
        return true;
    }

    public static void fireFireball(EnderDragon dragon, LivingEntity attackTarget) {
        Vec3 vector3d2 = dragon.m_20252_(1.0f);
        double x = dragon.f_31080_.m_20185_() - vector3d2.f_82479_;
        double y = dragon.f_31080_.m_20227_(0.5) + 0.5;
        double z = dragon.f_31080_.m_20189_() - vector3d2.f_82481_;
        double xPower = attackTarget.m_20185_() - x;
        double yPower = attackTarget.m_20227_(0.5) - y;
        double zPower = attackTarget.m_20189_() - z;
        if (!dragon.m_20067_()) {
            dragon.f_19853_.m_5898_(null, 1017, dragon.m_20183_(), 0);
        }
        DragonFireball dragonfireballentity = new DragonFireball(dragon.f_19853_, (LivingEntity)dragon, xPower, yPower, zPower);
        dragonfireballentity.m_7678_(x, y, z, 0.0f, 0.0f);
        dragon.f_19853_.m_7967_((Entity)dragonfireballentity);
        float fireballs = Mth.m_216267_((RandomSource)dragon.m_217043_(), (float)0.0f, (float)((float)(maxBonusFireball * (double)DifficultyHelper.getScalingDifficulty((LivingEntity)dragon))));
        fireballs = MathHelper.getAmountWithDecimalChance((RandomSource)dragon.m_217043_(), (float)fireballs);
        if (fireballs == 0.0f) {
            return;
        }
        int i = 0;
        while ((float)i < fireballs) {
            x = dragon.f_31080_.m_20185_() - vector3d2.f_82479_;
            y = dragon.f_31080_.m_20227_(0.5) + 0.5;
            z = dragon.f_31080_.m_20189_() - vector3d2.f_82481_;
            xPower = attackTarget.m_20185_() + Mth.m_216263_((RandomSource)dragon.m_217043_(), (double)(-fireballs), (double)fireballs) - x;
            yPower = attackTarget.m_20227_(0.5) + Mth.m_216263_((RandomSource)dragon.m_217043_(), (double)(-fireballs), (double)fireballs) - y;
            zPower = attackTarget.m_20189_() + Mth.m_216263_((RandomSource)dragon.m_217043_(), (double)(-fireballs), (double)fireballs) - z;
            if (!dragon.m_20067_()) {
                dragon.f_19853_.m_5898_(null, 1017, dragon.m_20183_(), 0);
            }
            dragonfireballentity = new DragonFireball(dragon.f_19853_, (LivingEntity)dragon, xPower, yPower, zPower);
            dragonfireballentity.m_7678_(x, y, z, 0.0f, 0.0f);
            dragon.f_19853_.m_7967_((Entity)dragonfireballentity);
            ++i;
        }
    }

    @Nullable
    public static Player getRandomPlayer(Level world, AABB boundingBox) {
        List players = world.m_6443_(Player.class, boundingBox, EntitySelector.f_20406_);
        if (players.isEmpty()) {
            return null;
        }
        int r = Mth.m_216271_((RandomSource)world.f_46441_, (int)0, (int)(players.size() - 1));
        return (Player)players.get(r);
    }

    @Nullable
    public static Player getRandomPlayerNearCrystal(Level world, AABB boundingBox) {
        List players = world.m_45976_(Player.class, boundingBox);
        if (players.isEmpty()) {
            return null;
        }
        ArrayList<Player> playersNearCrystals = new ArrayList<Player>();
        for (Player player : players) {
            List endCrystals = player.f_19853_.m_6443_(EndCrystal.class, player.m_20191_().m_82400_(10.0), EntitySelector.f_20406_);
            if (endCrystals.size() <= 0) continue;
            playersNearCrystals.add(player);
        }
        if (playersNearCrystals.isEmpty()) {
            int r = Mth.m_216271_((RandomSource)world.f_46441_, (int)0, (int)(players.size() - 1));
            return (Player)players.get(r);
        }
        int r = Mth.m_216271_((RandomSource)world.f_46441_, (int)0, (int)(playersNearCrystals.size() - 1));
        return (Player)playersNearCrystals.get(r);
    }
}

