/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.progressivebosses.module.wither.ai;

import java.util.EnumSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;

public class WitherRangedAttackGoal
extends Goal {
    private final WitherBoss wither;
    private LivingEntity target;
    private int attackTime = -1;
    private int seeTime;
    private final int attackInterval;
    private final float attackRadius;
    private final float attackRadiusSqr;
    private final double bonusASWhenNear;

    public WitherRangedAttackGoal(WitherBoss wither, int attackInterval, float attackRadius, double bonusASWhenNear) {
        this.wither = wither;
        this.attackInterval = attackInterval;
        this.attackRadius = attackRadius;
        this.attackRadiusSqr = attackRadius * attackRadius;
        this.bonusASWhenNear = bonusASWhenNear;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.wither.m_31502_() > 0) {
            return false;
        }
        int targetId = this.wither.m_31512_(0);
        Entity entity = this.wither.f_19853_.m_6815_(targetId);
        if (entity == null) {
            return false;
        }
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (!livingEntity.m_6084_()) {
            return false;
        }
        this.target = livingEntity;
        return true;
    }

    public boolean m_8045_() {
        return this.m_8036_() || !this.wither.m_21573_().m_26571_();
    }

    public void m_8041_() {
        this.target = null;
        this.seeTime = 0;
        this.attackTime = -1;
    }

    public void m_8037_() {
        CompoundTag witherTags = this.wither.getPersistentData();
        double distanceSq = this.wither.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        boolean canSee = this.wither.m_21574_().m_148306_((Entity)this.target);
        int unseenPlayerTicks = witherTags.m_128451_("progressivebosses:unseen_player_ticks");
        if (canSee) {
            ++this.seeTime;
            if (unseenPlayerTicks > 0) {
                witherTags.m_128405_("progressivebosses:unseen_player_ticks", unseenPlayerTicks - 1);
            }
        } else {
            this.seeTime = 0;
            if (this.target instanceof Player && unseenPlayerTicks < 300) {
                witherTags.m_128405_("progressivebosses:unseen_player_ticks", unseenPlayerTicks + 2);
            }
        }
        if (distanceSq <= (double)this.attackRadiusSqr && this.seeTime > 0) {
            this.wither.m_20334_(0.0, this.wither.m_20184_().f_82480_, 0.0);
        } else if (this.seeTime <= 0 && !this.wither.f_19853_.m_8055_(this.wither.m_20183_().m_7495_()).m_60815_() && !this.wither.f_19853_.m_45527_(this.wither.m_20183_())) {
            this.wither.m_20334_(this.wither.m_20184_().f_82479_, -1.0, this.wither.m_20184_().f_82481_);
        }
        this.wither.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
        int barrageAttackTick = witherTags.m_128451_("progressivebosses:barrage_attack");
        if (barrageAttackTick > 0) {
            if (!canSee) {
                return;
            }
            witherTags.m_128405_("progressivebosses:barrage_attack", barrageAttackTick - 1);
            if (barrageAttackTick % 4 == 0) {
                this.wither.m_31448_(Mth.m_216271_((RandomSource)this.wither.m_217043_(), (int)0, (int)2), this.target.m_20185_() + Mth.m_216263_((RandomSource)this.wither.m_217043_(), (double)-2.0, (double)2.0), this.target.m_20186_() + (double)this.target.m_20192_() * 0.5 + Mth.m_216263_((RandomSource)this.wither.m_217043_(), (double)-2.0, (double)2.0), this.target.m_20189_() + Mth.m_216263_((RandomSource)this.wither.m_217043_(), (double)-2.0, (double)2.0), false);
            }
        } else if (--this.attackTime <= 0) {
            float distance;
            if (!canSee) {
                return;
            }
            this.wither.m_31448_(0, this.target.m_20185_(), this.target.m_20186_() + (double)this.target.m_20192_() * 0.5, this.target.m_20189_(), this.wither.m_217043_().m_188500_() < 0.001);
            this.attackTime = this.attackInterval;
            if (this.bonusASWhenNear > 0.0 && (distance = this.wither.m_20270_((Entity)this.target)) < this.attackRadius) {
                int nearBonusAS = (int)Math.round((double)this.attackInterval * this.bonusASWhenNear * (1.0 - (double)(distance / this.attackRadius)));
                this.attackTime -= nearBonusAS;
            }
        }
    }

    public boolean m_183429_() {
        return true;
    }
}

