/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.proxy;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.Month;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import vazkii.quark.base.Quark;
import vazkii.quark.base.client.config.IngameConfigHandler;
import vazkii.quark.base.client.config.external.ExternalConfigHandler;
import vazkii.quark.base.client.config.screen.QuarkConfigHomeScreen;
import vazkii.quark.base.handler.ContributorRewardHandler;
import vazkii.quark.base.handler.DyeHandler;
import vazkii.quark.base.handler.RenderLayerHandler;
import vazkii.quark.base.handler.WoodSetHandler;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.base.module.config.IConfigCallback;
import vazkii.quark.base.proxy.CommonProxy;
import vazkii.quark.mixin.client.accessor.AccessorMultiPlayerGameMode;

@OnlyIn(value=Dist.CLIENT)
public class ClientProxy
extends CommonProxy {
    public static boolean jingleBellsMotherfucker = false;

    @Override
    public void start() {
        LocalDateTime now = LocalDateTime.now();
        if (now.getMonth() == Month.DECEMBER && now.getDayOfMonth() >= 16 || now.getMonth() == Month.JANUARY && now.getDayOfMonth() <= 6) {
            jingleBellsMotherfucker = true;
        }
        super.start();
        ModuleLoader.INSTANCE.clientStart();
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((minecraft, screen) -> new QuarkConfigHomeScreen((Screen)screen)));
        ClientProxy.copyProgrammerArtIfMissing();
        new ExternalConfigHandler().setAPIHandler();
    }

    @Override
    public void registerListeners(IEventBus bus) {
        super.registerListeners(bus);
        bus.addListener(this::clientSetup);
        bus.addListener(this::registerReloadListeners);
        bus.addListener(this::modelBake);
        bus.addListener(this::modelLayers);
        bus.addListener(this::textureStitch);
        bus.addListener(this::postTextureStitch);
        bus.addListener(this::registerKeybinds);
        bus.addListener(this::registerAdditionalModels);
        bus.addListener(this::registerClientTooltipComponentFactories);
    }

    public void clientSetup(FMLClientSetupEvent event) {
        RenderLayerHandler.init();
        WoodSetHandler.clientSetup(event);
        DyeHandler.clientSetup((ParallelDispatchEvent)event);
        ModuleLoader.INSTANCE.clientSetup((ParallelDispatchEvent)event);
    }

    public void registerReloadListeners(RegisterClientReloadListenersEvent event) {
        ModuleLoader.INSTANCE.registerReloadListeners(event);
    }

    public void modelBake(ModelEvent.BakingCompleted event) {
        ModuleLoader.INSTANCE.modelBake(event);
    }

    public void modelLayers(EntityRenderersEvent.AddLayers event) {
        ModuleLoader.INSTANCE.modelLayers(event);
    }

    public void textureStitch(TextureStitchEvent.Pre event) {
        ModuleLoader.INSTANCE.textureStitch(event);
    }

    public void postTextureStitch(TextureStitchEvent.Post event) {
        ModuleLoader.INSTANCE.postTextureStitch(event);
    }

    public void registerKeybinds(RegisterKeyMappingsEvent event) {
        ModuleLoader.INSTANCE.registerKeybinds(event);
    }

    public void registerAdditionalModels(ModelEvent.RegisterAdditional event) {
        ModuleLoader.INSTANCE.registerAdditionalModels(event);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerClientTooltipComponentFactories(RegisterClientTooltipComponentFactoriesEvent event) {
        ModuleLoader.INSTANCE.registerClientTooltipComponentFactories(event);
    }

    @Override
    public void handleQuarkConfigChange() {
        super.handleQuarkConfigChange();
        ModuleLoader.INSTANCE.configChangedClient();
        IngameConfigHandler.INSTANCE.refresh();
        Minecraft mc = Minecraft.m_91087_();
        mc.m_18707_(() -> {
            if (mc.m_91091_() && mc.f_91074_ != null && mc.m_91092_() != null) {
                for (int i = 0; i < 3; ++i) {
                    mc.f_91074_.m_213846_((Component)Component.m_237115_((String)("quark.misc.reloaded" + i)).m_130940_(i == 0 ? ChatFormatting.AQUA : ChatFormatting.WHITE));
                }
            }
        });
    }

    @Override
    public InteractionResult clientUseItem(Player player, Level level, InteractionHand hand, BlockHitResult hit) {
        if (player instanceof LocalPlayer) {
            LocalPlayer lPlayer = (LocalPlayer)player;
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91072_ != null && mc.f_91073_ != null) {
                if (!mc.f_91073_.m_6857_().m_61937_(hit.m_82425_())) {
                    return InteractionResult.FAIL;
                }
                return ((AccessorMultiPlayerGameMode)mc.f_91072_).quark$performUseItemOn(lPlayer, hand, hit);
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    protected void initContributorRewards() {
        ContributorRewardHandler.getLocalName();
        super.initContributorRewards();
    }

    @Override
    public IConfigCallback getConfigCallback() {
        return IngameConfigHandler.INSTANCE;
    }

    @Override
    public boolean isClientPlayerHoldingShift() {
        return Screen.m_96638_();
    }

    private static void copyProgrammerArtIfMissing() {
        File dir = new File(".", "resourcepacks");
        File target = new File(dir, "Quark Programmer Art.zip");
        if (!target.exists()) {
            try {
                int len;
                dir.mkdirs();
                InputStream in = Quark.class.getResourceAsStream("/assets/quark/programmer_art.zip");
                FileOutputStream out = new FileOutputStream(target);
                byte[] buf = new byte[16384];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
                in.close();
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

