/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing.client;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import com.teamderpy.shouldersurfing.client.ShoulderHelper;
import com.teamderpy.shouldersurfing.client.ShoulderInstance;
import com.teamderpy.shouldersurfing.config.Config;
import com.teamderpy.shouldersurfing.math.Vec2f;
import com.teamderpy.shouldersurfing.mixins.CameraAccessor;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ShoulderRenderer {
    private static final ShoulderRenderer INSTANCE = new ShoulderRenderer();
    private double cameraDistance;
    private Vec2f lastTranslation = Vec2f.ZERO;
    private Vec2f translation = Vec2f.ZERO;
    private Vec2f projected;

    public void offsetCrosshair(PoseStack poseStack, Window window, float partialTicks) {
        if (this.projected != null) {
            Vec2f scaledDimensions = new Vec2f(window.m_85445_(), window.m_85446_());
            Vec2f dimensions = new Vec2f(window.m_85443_(), window.m_85444_());
            Vec2f scale = scaledDimensions.divide(dimensions);
            Vec2f center = dimensions.divide(2.0f);
            Vec2f projectedOffset = this.projected.subtract(center).scale(scale);
            Vec2f interpolated = projectedOffset.subtract(this.lastTranslation).scale(partialTicks);
            this.translation = this.lastTranslation.add(interpolated);
        }
        if (Config.CLIENT.getCrosshairType().isDynamic() && ShoulderInstance.getInstance().doShoulderSurfing()) {
            poseStack.m_85836_();
            poseStack.m_85850_().m_85861_().m_27648_(new Vector3f(this.translation.getX(), -this.translation.getY(), 0.0f));
            this.lastTranslation = this.translation;
        } else {
            this.lastTranslation = Vec2f.ZERO;
        }
    }

    public void clearCrosshairOffset(PoseStack poseStack) {
        if (Config.CLIENT.getCrosshairType().isDynamic() && ShoulderInstance.getInstance().doShoulderSurfing() && !Vec2f.ZERO.equals(this.lastTranslation)) {
            poseStack.m_85849_();
        }
    }

    public void offsetCamera(Camera camera, Level level, double partialTick) {
        if (ShoulderInstance.getInstance().doShoulderSurfing() && level != null) {
            CameraAccessor accessor = (CameraAccessor)camera;
            double x = Mth.m_14139_((double)partialTick, (double)camera.m_90592_().f_19854_, (double)camera.m_90592_().m_20185_());
            double y = Mth.m_14139_((double)partialTick, (double)camera.m_90592_().f_19855_, (double)camera.m_90592_().m_20186_()) + Mth.m_14139_((double)partialTick, (double)accessor.getEyeHeightOld(), (double)accessor.getEyeHeight());
            double z = Mth.m_14139_((double)partialTick, (double)camera.m_90592_().f_19856_, (double)camera.m_90592_().m_20189_());
            accessor.invokeSetPosition(x, y, z);
            Vec3 offset = new Vec3(-Config.CLIENT.getOffsetZ(), Config.CLIENT.getOffsetY(), Config.CLIENT.getOffsetX());
            this.cameraDistance = this.calcCameraDistance(camera, level, accessor.invokeGetMaxZoom(offset.m_82553_()));
            Vec3 scaled = offset.m_82541_().m_82490_(this.cameraDistance);
            accessor.invokeMove(scaled.f_82479_, scaled.f_82480_, scaled.f_82481_);
        }
    }

    private double calcCameraDistance(Camera camera, Level level, double distance) {
        Vec3 cameraPos = camera.m_90583_();
        Vec3 cameraOffset = ShoulderHelper.calcCameraOffset(camera, distance);
        for (int i = 0; i < 8; ++i) {
            double newDistance;
            Vec3 to;
            Vec3 offset = new Vec3((double)(i & 1), (double)(i >> 1 & 1), (double)(i >> 2 & 1)).m_82490_(2.0).m_82492_(1.0, 1.0, 1.0).m_82490_(0.075);
            Vec3 from = cameraPos.m_82549_(offset);
            ClipContext context = new ClipContext(from, to = from.m_82549_(cameraOffset), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, camera.m_90592_());
            BlockHitResult hitResult = level.m_45547_(context);
            if (hitResult == null || !((newDistance = hitResult.m_82450_().m_82554_(cameraPos)) < distance)) continue;
            distance = newDistance - 0.2;
        }
        return distance;
    }

    public void updateDynamicRaytrace(Camera camera, Matrix4f modelViewMatrix, Matrix4f projectionMatrix, float partialTick) {
        if (ShoulderInstance.getInstance().doShoulderSurfing()) {
            Minecraft minecraft = Minecraft.m_91087_();
            MultiPlayerGameMode gameMode = minecraft.f_91072_;
            HitResult hitResult = ShoulderHelper.traceBlocksAndEntities(camera, gameMode, this.getPlayerReach(), ClipContext.Fluid.NONE, partialTick, true, false);
            Vec3 position = hitResult.m_82450_().m_82546_(camera.m_90583_());
            this.projected = this.project2D(position, modelViewMatrix, projectionMatrix);
        }
    }

    @Nullable
    private Vec2f project2D(Vec3 position, Matrix4f modelView, Matrix4f projection) {
        Window window = Minecraft.m_91087_().m_91268_();
        int screenWidth = window.m_85443_();
        int screenHeight = window.m_85444_();
        if (screenWidth == 0 || screenHeight == 0) {
            return null;
        }
        Vector4f vec = new Vector4f((float)position.m_7096_(), (float)position.m_7098_(), (float)position.m_7094_(), 1.0f);
        vec.m_123607_(modelView);
        vec.m_123607_(projection);
        if (vec.m_123617_() == 0.0f) {
            return null;
        }
        float w = 1.0f / vec.m_123617_() * 0.5f;
        float x = (vec.m_123601_() * w + 0.5f) * (float)screenWidth;
        float y = (vec.m_123615_() * w + 0.5f) * (float)screenHeight;
        float z = vec.m_123616_() * w + 0.5f;
        vec.m_123602_(x, y, z, w);
        if (Float.isInfinite(x) || Float.isInfinite(y) || Float.isNaN(x) || Float.isNaN(y)) {
            return null;
        }
        return new Vec2f(x, y);
    }

    public boolean skipEntityRendering() {
        return Config.CLIENT.keepCameraOutOfHead() && this.cameraDistance < (double)(Minecraft.m_91087_().m_91288_().m_20205_() * 0.75f) && ShoulderInstance.getInstance().doShoulderSurfing();
    }

    public double getPlayerReach() {
        return Config.CLIENT.useCustomRaytraceDistance() ? Config.CLIENT.getCustomRaytraceDistance() : 0.0;
    }

    public double getCameraDistance() {
        return this.cameraDistance;
    }

    public static ShoulderRenderer getInstance() {
        return INSTANCE;
    }
}

