/*
 * Decompiled with CFR 0.152.
 */
package fuzs.stylisheffects.client;

import fuzs.puzzleslib.client.core.ClientCoreServices;
import fuzs.stylisheffects.client.StylishEffectsClient;
import fuzs.stylisheffects.client.handler.EffectScreenHandlerImpl;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;

@Mod.EventBusSubscriber(modid="stylisheffects", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class StylishEffectsForgeClient {
    @SubscribeEvent
    public static void onConstructMod(FMLConstructModEvent evt) {
        ClientCoreServices.FACTORIES.clientModConstructor("stylisheffects").accept(new StylishEffectsClient());
        StylishEffectsForgeClient.registerHandlers();
    }

    private static void registerHandlers() {
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            if (evt.phase == TickEvent.Phase.END) {
                EffectScreenHandlerImpl.INSTANCE.onClientTick(Minecraft.m_91087_());
            }
        });
        MinecraftForge.EVENT_BUS.addListener(evt -> EffectScreenHandlerImpl.INSTANCE.onScreenOpen(evt.getCurrentScreen(), evt.getNewScreen()).ifPresent(newScreen -> {
            if (newScreen == evt.getCurrentScreen()) {
                evt.setCanceled(true);
            } else {
                evt.setNewScreen(newScreen);
            }
        }));
        MinecraftForge.EVENT_BUS.addListener(evt -> EffectScreenHandlerImpl.INSTANCE.onScreenInit(evt.getScreen()));
        MinecraftForge.EVENT_BUS.addListener(evt -> EffectScreenHandlerImpl.INSTANCE.onDrawBackground(evt.getContainerScreen(), evt.getPoseStack(), evt.getMouseX(), evt.getMouseY()));
        MinecraftForge.EVENT_BUS.addListener(evt -> EffectScreenHandlerImpl.INSTANCE.onDrawForeground(evt.getContainerScreen(), evt.getPoseStack(), evt.getMouseX(), evt.getMouseY()));
        MinecraftForge.EVENT_BUS.addListener(evt -> evt.setCanceled(true));
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            if (evt.getOverlay() == VanillaGuiOverlay.POTION_ICONS.type()) {
                EffectScreenHandlerImpl.INSTANCE.onRenderMobEffectIconsOverlay(evt.getPoseStack(), evt.getWindow().m_85445_(), evt.getWindow().m_85446_());
                evt.setCanceled(true);
            }
        });
        MinecraftForge.EVENT_BUS.addListener(evt -> EffectScreenHandlerImpl.INSTANCE.onMouseClicked(evt.getScreen(), evt.getMouseX(), evt.getMouseY(), evt.getButton()));
    }
}

