/*
 * Decompiled with CFR 0.152.
 */
package fuzs.stylisheffects.client.handler;

import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.puzzleslib.client.core.ClientCoreServices;
import fuzs.puzzleslib.core.CoreServices;
import fuzs.stylisheffects.StylishEffects;
import fuzs.stylisheffects.api.client.EffectScreenHandler;
import fuzs.stylisheffects.api.client.MobEffectWidgetContext;
import fuzs.stylisheffects.client.core.ClientModServices;
import fuzs.stylisheffects.client.gui.effects.AbstractEffectRenderer;
import fuzs.stylisheffects.client.gui.effects.GuiCompactEffectRenderer;
import fuzs.stylisheffects.client.gui.effects.GuiSmallEffectRenderer;
import fuzs.stylisheffects.client.gui.effects.InventoryCompactEffectRenderer;
import fuzs.stylisheffects.client.gui.effects.InventoryFullSizeEffectRenderer;
import fuzs.stylisheffects.client.handler.EffectRendererEnvironment;
import fuzs.stylisheffects.config.ClientConfig;
import fuzs.stylisheffects.mixin.client.accessor.AbstractContainerMenuAccessor;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;

public class EffectScreenHandlerImpl
implements EffectScreenHandler {
    public static final EffectScreenHandlerImpl INSTANCE = new EffectScreenHandlerImpl();
    @Nullable
    private AbstractEffectRenderer guiRenderer;
    @Nullable
    private AbstractEffectRenderer inventoryRenderer;

    private EffectScreenHandlerImpl() {
    }

    @Override
    public void rebuildEffectRenderers() {
        MobEffectWidgetContext.Renderer rendererType = ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).guiRenderer().rendererType;
        if (rendererType != MobEffectWidgetContext.Renderer.NONE) {
            this.guiRenderer = EffectScreenHandlerImpl.createRenderer(rendererType, EffectRendererEnvironment.GUI);
        }
    }

    @Override
    public Optional<MobEffectWidgetContext> getInventoryHoveredEffect(Screen screen, double mouseX, double mouseY) {
        return EffectScreenHandlerImpl.getEffectRenderer(screen, this.inventoryRenderer).flatMap(renderer -> renderer.getHoveredEffect((int)mouseX, (int)mouseY).map(renderer::buildContext));
    }

    @Override
    public List<Rect2i> getInventoryRenderAreas(Screen screen) {
        return EffectScreenHandlerImpl.getEffectRenderer(screen, this.inventoryRenderer).map(AbstractEffectRenderer::getRenderAreas).orElse(List.of());
    }

    public void onClientTick(Minecraft minecraft) {
        this.createInventoryRenderer(minecraft.f_91080_, (Player)minecraft.f_91074_);
    }

    public void onScreenInit(Screen screen) {
        this.createInventoryRenderer(screen, (Player)ClientCoreServices.SCREENS.getMinecraft((Screen)screen).f_91074_);
    }

    private void createInventoryRenderer(@Nullable Screen screen, @Nullable Player player) {
        AbstractEffectRenderer renderer;
        AbstractEffectRenderer abstractEffectRenderer = renderer = screen != null ? EffectScreenHandlerImpl.createInventoryRendererOrFallback(screen) : null;
        if (renderer != null && player != null) {
            renderer.setActiveEffects(player.m_21220_());
        }
        this.inventoryRenderer = renderer;
    }

    public void onRenderMobEffectIconsOverlay(PoseStack poseStack, int screenWidth, int screenHeight) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (CoreServices.ENVIRONMENT.getModLoader().isForge() && minecraft.f_91066_.f_92063_) {
            return;
        }
        EffectScreenHandlerImpl.getEffectRenderer(minecraft.f_91080_, true, this.guiRenderer, minecraft.f_91074_.m_21220_()).ifPresent(renderer -> {
            MobEffectWidgetContext.ScreenSide screenSide = ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).guiRenderer().screenSide;
            renderer.setScreenDimensions((GuiComponent)minecraft.f_91065_, screenWidth, screenHeight, screenSide.right() ? screenWidth : 0, 0, screenSide);
            renderer.renderEffects(poseStack, minecraft);
        });
    }

    public void onDrawBackground(AbstractContainerScreen<?> screen, PoseStack poseStack, int mouseX, int mouseY) {
        Minecraft minecraft = ClientCoreServices.SCREENS.getMinecraft(screen);
        EffectScreenHandlerImpl.getEffectRenderer(screen, this.inventoryRenderer).ifPresent(renderer -> renderer.renderEffects(poseStack, minecraft));
    }

    public void onDrawForeground(AbstractContainerScreen<?> screen, PoseStack poseStack, int mouseX, int mouseY) {
        Minecraft minecraft = ClientCoreServices.SCREENS.getMinecraft(screen);
        EffectScreenHandlerImpl.getEffectRenderer(screen, this.inventoryRenderer).ifPresent(renderer -> {
            TooltipFlag.Default tooltipFlag = minecraft.f_91066_.f_92125_ ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL;
            renderer.getHoveredEffectTooltip(mouseX, mouseY, (TooltipFlag)tooltipFlag).ifPresent(tooltip -> {
                if (!screen.m_6262_().m_142621_().m_41619_()) {
                    return;
                }
                poseStack.m_85836_();
                poseStack.m_85837_((double)(-ClientCoreServices.SCREENS.getLeftPos(screen)), (double)(-ClientCoreServices.SCREENS.getTopPos(screen)), 0.0);
                screen.m_96597_(poseStack, tooltip, mouseX, mouseY);
                poseStack.m_85849_();
            });
        });
    }

    public void onMouseClicked(Screen screen, double mouseX, double mouseY, int button) {
        EffectScreenHandlerImpl.getEffectRenderer(screen, this.inventoryRenderer).ifPresent(renderer -> renderer.getHoveredEffect((int)mouseX, (int)mouseY).ifPresent(effectInstance -> ClientModServices.ABSTRACTIONS.onEffectMouseClicked(renderer.buildContext((MobEffectInstance)effectInstance), screen, mouseX, mouseY, button)));
    }

    public Optional<Screen> onScreenOpen(@Nullable Screen oldScreen, @Nullable Screen newScreen) {
        if (newScreen instanceof AbstractContainerScreen) {
            MenuType<?> type;
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)newScreen;
            if (((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).inventoryRenderer().debugContainerTypes && (type = ((AbstractContainerMenuAccessor)containerScreen.m_6262_()).getMenuType()) != null) {
                MutableComponent component = Component.m_237113_((String)Registry.f_122863_.m_7981_(type).toString());
                Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)Component.m_237110_((String)"debug.menu.opening", (Object[])new Object[]{ComponentUtils.m_130748_((Component)component)}));
            }
        }
        return Optional.empty();
    }

    private static Optional<AbstractEffectRenderer> getEffectRenderer(Screen screen, @Nullable AbstractEffectRenderer effectRenderer) {
        return EffectScreenHandlerImpl.getEffectRenderer(screen, false, effectRenderer, null);
    }

    private static Optional<AbstractEffectRenderer> getEffectRenderer(@Nullable Screen screen, boolean invertSupport, @Nullable AbstractEffectRenderer effectRenderer, @Nullable Collection<MobEffectInstance> activeEffects) {
        if ((!invertSupport && EffectScreenHandlerImpl.supportsEffectsDisplay(screen) || invertSupport && !EffectScreenHandlerImpl.supportsEffectsDisplay(screen)) && effectRenderer != null) {
            if (activeEffects != null) {
                effectRenderer.setActiveEffects(activeEffects);
            }
            if (effectRenderer.isActive()) {
                return Optional.of(effectRenderer);
            }
        }
        return Optional.empty();
    }

    public static AbstractEffectRenderer createRenderer(MobEffectWidgetContext.Renderer renderer, EffectRendererEnvironment environment) {
        return switch (renderer) {
            case MobEffectWidgetContext.Renderer.GUI_SMALL -> new GuiSmallEffectRenderer(environment);
            case MobEffectWidgetContext.Renderer.GUI_COMPACT -> new GuiCompactEffectRenderer(environment);
            case MobEffectWidgetContext.Renderer.INVENTORY_COMPACT -> new InventoryCompactEffectRenderer(environment);
            case MobEffectWidgetContext.Renderer.INVENTORY_FULL_SIZE -> new InventoryFullSizeEffectRenderer(environment);
            default -> throw new IllegalArgumentException(String.format("Cannot create effect renderer for type %s", new Object[]{renderer}));
        };
    }

    @Nullable
    private static AbstractEffectRenderer createInventoryRendererOrFallback(Screen screen) {
        MobEffectWidgetContext.Renderer rendererType = ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).inventoryRenderer().rendererType;
        if (rendererType != MobEffectWidgetContext.Renderer.NONE && EffectScreenHandlerImpl.supportsEffectsDisplay(screen)) {
            AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
            MobEffectWidgetContext.ScreenSide screenSide = ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).inventoryRenderer().screenSide;
            Consumer<AbstractEffectRenderer> setScreenDimensions = renderer -> {
                int leftPos = ClientCoreServices.SCREENS.getLeftPos(containerScreen);
                renderer.setScreenDimensions((GuiComponent)containerScreen, !screenSide.right() ? leftPos : containerScreen.f_96543_ - (leftPos + ClientCoreServices.SCREENS.getImageWidth(containerScreen)), ClientCoreServices.SCREENS.getImageHeight(containerScreen), !screenSide.right() ? leftPos : leftPos + ClientCoreServices.SCREENS.getImageWidth(containerScreen), ClientCoreServices.SCREENS.getTopPos(containerScreen), screenSide);
            };
            AbstractEffectRenderer renderer2 = EffectScreenHandlerImpl.createRenderer(rendererType, EffectRendererEnvironment.INVENTORY);
            setScreenDimensions.accept(renderer2);
            while (!renderer2.isValid()) {
                EffectRendererEnvironment.Factory rendererFactory = renderer2.getFallbackRenderer();
                if (rendererFactory == null) {
                    return null;
                }
                renderer2 = (AbstractEffectRenderer)rendererFactory.apply(EffectRendererEnvironment.INVENTORY);
                setScreenDimensions.accept(renderer2);
            }
            return renderer2;
        }
        return null;
    }

    private static boolean supportsEffectsDisplay(Screen screen) {
        AbstractContainerScreen containerScreen;
        MenuType<?> type;
        if (screen instanceof AbstractContainerScreen && (type = ((AbstractContainerMenuAccessor)(containerScreen = (AbstractContainerScreen)screen).m_6262_()).getMenuType()) != null && ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).inventoryRenderer().menuBlacklist.contains(type)) {
            return false;
        }
        if (screen instanceof EffectRenderingInventoryScreen || ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).inventoryRenderer().effectsEverywhere && screen instanceof AbstractContainerScreen) {
            RecipeUpdateListener listener;
            if (screen instanceof RecipeUpdateListener && (listener = (RecipeUpdateListener)screen).m_5564_().m_100385_()) {
                return ((ClientConfig)StylishEffects.CONFIG.get(ClientConfig.class)).inventoryRenderer().screenSide.right();
            }
            return true;
        }
        return false;
    }
}

