/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.travelerstitles.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.yungnickyoung.minecraft.travelerstitles.TravelersTitlesCommon;
import com.yungnickyoung.minecraft.travelerstitles.module.CompatModule;
import com.yungnickyoung.minecraft.travelerstitles.module.SoundModule;
import com.yungnickyoung.minecraft.travelerstitles.module.TagModule;
import com.yungnickyoung.minecraft.travelerstitles.render.TitleRenderer;
import com.yungnickyoung.minecraft.travelerstitles.services.Services;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.dimension.DimensionType;

public class TitleRenderManager {
    public final TitleRenderer<Biome> biomeTitleRenderer;
    public final TitleRenderer<DimensionType> dimensionTitleRenderer;

    public TitleRenderManager() {
        this.biomeTitleRenderer = new TitleRenderer(TravelersTitlesCommon.CONFIG.biomes.recentBiomeCacheSize, TravelersTitlesCommon.CONFIG.biomes.enabled, TravelersTitlesCommon.CONFIG.biomes.textFadeInTime, TravelersTitlesCommon.CONFIG.biomes.textDisplayTime, TravelersTitlesCommon.CONFIG.biomes.textFadeOutTime, TravelersTitlesCommon.CONFIG.biomes.textColor, TravelersTitlesCommon.CONFIG.biomes.renderShadow, TravelersTitlesCommon.CONFIG.biomes.textSize, TravelersTitlesCommon.CONFIG.biomes.textXOffset, TravelersTitlesCommon.CONFIG.biomes.textYOffset, TravelersTitlesCommon.CONFIG.biomes.centerText);
        this.dimensionTitleRenderer = new TitleRenderer(1, TravelersTitlesCommon.CONFIG.dimensions.enabled, TravelersTitlesCommon.CONFIG.dimensions.textFadeInTime, TravelersTitlesCommon.CONFIG.dimensions.textDisplayTime, TravelersTitlesCommon.CONFIG.dimensions.textFadeOutTime, TravelersTitlesCommon.CONFIG.dimensions.textColor, TravelersTitlesCommon.CONFIG.dimensions.renderShadow, TravelersTitlesCommon.CONFIG.dimensions.textSize, TravelersTitlesCommon.CONFIG.dimensions.textXOffset, TravelersTitlesCommon.CONFIG.dimensions.textYOffset, TravelersTitlesCommon.CONFIG.dimensions.centerText);
    }

    public void clientTick() {
        if (!Minecraft.m_91087_().m_91104_()) {
            this.dimensionTitleRenderer.tick();
            Services.WAYSTONES.clientTick();
            this.biomeTitleRenderer.tick();
        }
    }

    public void renderTitles(PoseStack poseStack, float partialTicks) {
        if (!Minecraft.m_91087_().f_91066_.f_92063_) {
            this.dimensionTitleRenderer.renderText(partialTicks, poseStack);
            this.biomeTitleRenderer.renderText(partialTicks, poseStack);
            Services.WAYSTONES.renderText(partialTicks, poseStack);
        }
    }

    public void playerTick(Player player) {
        if (player instanceof LocalPlayer && player.f_19853_.m_46749_(player.m_20183_())) {
            BlockPos playerPos = player.m_20183_();
            Level world = player.f_19853_;
            boolean isPlayerUnderground = world.m_6042_().f_223549_() && !world.m_45527_(playerPos);
            this.updateDimensionTitle(world, player, isPlayerUnderground);
            boolean isRenderingWaystoneTitle = this.updateWaystoneTitle(player, isPlayerUnderground);
            if (!TravelersTitlesCommon.CONFIG.waystones.waystonesOverrideBiomeTitle || !isRenderingWaystoneTitle) {
                this.updateBiomeTitle(world, playerPos, player, isPlayerUnderground);
            } else {
                this.biomeTitleRenderer.clearTimer();
            }
        }
    }

    public void playerChangedDimension(Object entity) {
        if (entity instanceof Player) {
            if (TravelersTitlesCommon.CONFIG.biomes.enabled && TravelersTitlesCommon.CONFIG.biomes.resetBiomeCacheOnDimensionChange) {
                this.biomeTitleRenderer.clearTimer();
                this.biomeTitleRenderer.recentEntries.clear();
                this.biomeTitleRenderer.displayedTitle = null;
            }
            if (CompatModule.isWaystonesLoaded && TravelersTitlesCommon.CONFIG.waystones.enabled && TravelersTitlesCommon.CONFIG.waystones.resetWaystoneCacheOnDimensionChange) {
                Services.WAYSTONES.reset();
            }
        }
    }

    private void updateDimensionTitle(Level world, Player player, boolean isPlayerUnderground) {
        if (isPlayerUnderground && TravelersTitlesCommon.CONFIG.dimensions.onlyUpdateAtSurface) {
            return;
        }
        DimensionType currDimension = world.m_6042_();
        if (this.dimensionTitleRenderer.enabled && !this.dimensionTitleRenderer.matchesAnyRecentEntry(d -> d == currDimension)) {
            ResourceLocation dimensionBaseKey = world.m_46472_().m_135782_();
            String dimensionNameKey = Util.m_137492_((String)"travelerstitles", (ResourceLocation)dimensionBaseKey);
            if (!TravelersTitlesCommon.CONFIG.dimensions.dimensionBlacklist.contains(dimensionBaseKey.toString())) {
                MutableComponent dimensionTitle = Language.m_128107_().m_6722_(dimensionNameKey) ? Component.m_237115_((String)dimensionNameKey) : Component.m_237113_((String)"???");
                String dimensionColorKey = dimensionNameKey + ".color";
                String dimensionColorStr = Language.m_128107_().m_6722_(dimensionColorKey) ? Language.m_128107_().m_6834_(dimensionColorKey) : this.dimensionTitleRenderer.titleDefaultTextColor;
                this.dimensionTitleRenderer.setColor(dimensionColorStr);
                this.dimensionTitleRenderer.displayTitle((Component)dimensionTitle, null);
                this.dimensionTitleRenderer.addRecentEntry(currDimension);
                player.m_5496_((SoundEvent)SoundModule.DIMENSION.get(), (float)TravelersTitlesCommon.CONFIG.sound.dimensionVolume, (float)TravelersTitlesCommon.CONFIG.sound.dimensionPitch);
            }
        }
    }

    private void updateBiomeTitle(Level world, BlockPos playerPos, Player player, boolean isPlayerUnderground) {
        boolean isUndergroundBiome;
        Holder biomeHolder = world.m_204166_(playerPos);
        boolean bl = isUndergroundBiome = biomeHolder.m_203565_(Biomes.f_151785_) || biomeHolder.m_203565_(Biomes.f_151784_) || biomeHolder.m_203656_(TagModule.IS_UNDERGROUND);
        if (isPlayerUnderground && TravelersTitlesCommon.CONFIG.biomes.onlyUpdateAtSurface && !isUndergroundBiome) {
            return;
        }
        ResourceLocation biomeBaseKey = world.m_5962_().m_175515_(Registry.f_122885_).m_7981_((Object)((Biome)biomeHolder.m_203334_()));
        if (this.biomeTitleRenderer.enabled && this.biomeTitleRenderer.cooldownTimer <= 0 && !this.biomeTitleRenderer.matchesAnyRecentEntry(b -> world.m_5962_().m_175515_(Registry.f_122885_).m_7981_(b) == biomeBaseKey)) {
            String overrideBiomeNameKey = Util.m_137492_((String)"travelerstitles.biome", (ResourceLocation)biomeBaseKey);
            String normalBiomeNameKey = Util.m_137492_((String)"biome", (ResourceLocation)biomeBaseKey);
            if (biomeBaseKey != null && !TravelersTitlesCommon.CONFIG.biomes.biomeBlacklist.contains(biomeBaseKey.toString())) {
                MutableComponent biomeTitle;
                if (Language.m_128107_().m_6722_(overrideBiomeNameKey)) {
                    biomeTitle = Component.m_237115_((String)overrideBiomeNameKey);
                } else if (Language.m_128107_().m_6722_(normalBiomeNameKey)) {
                    biomeTitle = Component.m_237115_((String)normalBiomeNameKey);
                } else {
                    return;
                }
                String overrideBiomeColorKey = overrideBiomeNameKey + ".color";
                String normalBiomeColorKey = normalBiomeNameKey + ".color";
                String biomeColorStr = Language.m_128107_().m_6722_(overrideBiomeColorKey) ? Language.m_128107_().m_6834_(overrideBiomeColorKey) : (Language.m_128107_().m_6722_(normalBiomeColorKey) ? Language.m_128107_().m_6834_(normalBiomeColorKey) : this.biomeTitleRenderer.titleDefaultTextColor);
                if (this.biomeTitleRenderer.displayedTitle != null && biomeTitle.getString().equals(this.biomeTitleRenderer.displayedTitle.getString())) {
                    return;
                }
                this.biomeTitleRenderer.setColor(biomeColorStr);
                this.biomeTitleRenderer.displayTitle((Component)biomeTitle, null);
                this.biomeTitleRenderer.cooldownTimer = TravelersTitlesCommon.CONFIG.biomes.textCooldownTime;
                this.biomeTitleRenderer.addRecentEntry((Biome)biomeHolder.m_203334_());
                if (!(this.dimensionTitleRenderer.titleTimer > 0 || CompatModule.isWaystonesLoaded && Services.WAYSTONES.isRendering())) {
                    player.m_5496_((SoundEvent)SoundModule.BIOME.get(), (float)TravelersTitlesCommon.CONFIG.sound.biomeVolume, (float)TravelersTitlesCommon.CONFIG.sound.biomePitch);
                }
            }
        }
    }

    private boolean updateWaystoneTitle(Player player, boolean isPlayerUnderground) {
        if (isPlayerUnderground && TravelersTitlesCommon.CONFIG.waystones.onlyUpdateAtSurface) {
            return false;
        }
        if (CompatModule.isWaystonesLoaded && TravelersTitlesCommon.CONFIG.waystones.enabled) {
            return Services.WAYSTONES.updateWaystoneTitle(player);
        }
        return false;
    }
}

