/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.data.culling;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.oitsjustjose.vtweaks.VTweaks;
import com.oitsjustjose.vtweaks.common.tweaks.entity.culling.EntityCullingHandler;
import com.oitsjustjose.vtweaks.common.tweaks.entity.culling.EntityCullingRule;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class EntityCullingDataLoader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public EntityCullingDataLoader() {
        super(GSON, "culled_entities");
    }

    protected void apply(Map<ResourceLocation, JsonElement> dataMap, @Nonnull ResourceManager mgr, @NotNull ProfilerFiller prof) {
        EntityCullingHandler.AllRules.clear();
        dataMap.forEach((rl, json) -> {
            try {
                if (json == null) {
                    return;
                }
                JsonObject obj = json.getAsJsonObject();
                ArrayList<String> eRaw = new ArrayList<String>();
                ArrayList<String> bRaw = new ArrayList<String>();
                ArrayList<String> dRaw = new ArrayList<String>();
                obj.get("entities").getAsJsonArray().forEach(x -> eRaw.add(x.getAsString()));
                if (obj.has("dimensions")) {
                    obj.get("dimensions").getAsJsonArray().forEach(x -> dRaw.add(x.getAsString()));
                }
                if (obj.has("biomes")) {
                    obj.get("biomes").getAsJsonArray().forEach(x -> bRaw.add(x.getAsString()));
                }
                EntityCullingRule rule = new EntityCullingRule(bRaw, dRaw, eRaw);
                EntityCullingHandler.AllRules.add(rule);
                VTweaks.getInstance().LOGGER.info("Loaded {} into {}", rl, (Object)rule);
            }
            catch (NullPointerException ex) {
                VTweaks.getInstance().LOGGER.error("Skipping registration of Entity Culling Rule {} due to errors", rl);
                ex.printStackTrace();
            }
        });
    }
}

