/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.tweaks.block;

import com.oitsjustjose.vtweaks.common.core.Tweak;
import com.oitsjustjose.vtweaks.common.core.VTweak;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.ItemHandlerHelper;

@Tweak(eventClass=PlayerInteractEvent.RightClickBlock.class, category="block")
public class CropInteractTweak
extends VTweak {
    public static final TagKey<Block> CROP_BLACKLIST = BlockTags.create((ResourceLocation)new ResourceLocation("vtweaks", "blacklisted_harvest_crops"));
    public ForgeConfigSpec.BooleanValue enabled;

    @Override
    public void registerConfigs(ForgeConfigSpec.Builder builder) {
        this.enabled = builder.comment(new String[0]).define("enableCropTweaks", true);
    }

    @SubscribeEvent
    public void process(PlayerInteractEvent.RightClickBlock evt) {
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            return;
        }
        if (evt.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        BlockPos pos = evt.getPos();
        BlockState state = evt.getLevel().m_8055_(pos);
        Player player = evt.getEntity();
        if (state.m_204336_(CROP_BLACKLIST)) {
            return;
        }
        if (!this.canHarvest(state)) {
            return;
        }
        Level level = evt.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLvl = (ServerLevel)level;
            this.harvest(serverLvl, pos, state, player);
        }
        player.m_6674_(InteractionHand.MAIN_HAND);
        evt.setCanceled(true);
    }

    private boolean canHarvest(BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof CropBlock) {
            CropBlock crop = (CropBlock)block;
            return crop.m_52307_(state);
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61405_)) {
            return (Integer)state.m_61143_((Property)BlockStateProperties.f_61405_) == 1;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61406_)) {
            return (Integer)state.m_61143_((Property)BlockStateProperties.f_61406_) == 2;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61407_)) {
            return (Integer)state.m_61143_((Property)BlockStateProperties.f_61407_) == 3;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_222999_)) {
            return (Integer)state.m_61143_((Property)BlockStateProperties.f_222999_) == 4;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61408_)) {
            return (Integer)state.m_61143_((Property)BlockStateProperties.f_61408_) == 5;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61409_)) {
            return (Integer)state.m_61143_((Property)BlockStateProperties.f_61409_) == 7;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61410_)) {
            return (Integer)state.m_61143_((Property)BlockStateProperties.f_61410_) == 15;
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61411_)) {
            return (Integer)state.m_61143_((Property)BlockStateProperties.f_61411_) == 25;
        }
        return false;
    }

    private void harvest(ServerLevel level, BlockPos pos, BlockState state, Player player) {
        List drops = Block.m_49869_((BlockState)state, (ServerLevel)level, (BlockPos)pos, null);
        level.m_46961_(pos, false);
        AtomicBoolean planted = new AtomicBoolean(false);
        drops.forEach(drop -> {
            if (!planted.get() && this.tryPlant(level, pos, (ItemStack)drop)) {
                planted.set(true);
            }
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)drop);
        });
    }

    private boolean tryPlant(ServerLevel level, BlockPos pos, ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem bi = (BlockItem)item;
            DirectionalPlaceContext ctx = new DirectionalPlaceContext((Level)level, pos, Direction.DOWN, stack, Direction.UP);
            return bi.m_40576_((BlockPlaceContext)ctx) == InteractionResult.SUCCESS;
        }
        return false;
    }
}

