/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.tweaks.entity.challenger;

import com.oitsjustjose.vtweaks.common.entity.ChallengerEntityModifier;
import com.oitsjustjose.vtweaks.common.util.WeightedCollection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class ChallengerHelpers {
    public static boolean hasChallengerEntityModifier(Entity entity) {
        CompoundTag comp = entity.getPersistentData();
        return comp.m_128441_("challenger_mob_data");
    }

    public static ChallengerEntityModifier getChallengerEntityModifier(Entity monster) {
        CompoundTag comp = monster.getPersistentData();
        if (comp.m_128441_("challenger_mob_data")) {
            CompoundTag cmd = comp.m_128469_("challenger_mob_data");
            String type = cmd.m_128461_("variant");
            return ChallengerHelpers.getChallengerEntityModifierByName(type);
        }
        return null;
    }

    @Nullable
    public static ChallengerEntityModifier getChallengerEntityModifierByName(String name) {
        for (ChallengerEntityModifier t : ChallengerEntityModifier.AllVariants.getCollection()) {
            if (!t.getUnlocalizedName().equals(name)) continue;
            return t;
        }
        return null;
    }

    public static WeightedCollection<ChallengerEntityModifier> filterForEntity(Entity entity) {
        HashMap<ChallengerEntityModifier, Integer> orig = ChallengerEntityModifier.AllVariants.getWeightMap();
        WeightedCollection<ChallengerEntityModifier> filtered = new WeightedCollection<ChallengerEntityModifier>();
        for (Map.Entry<ChallengerEntityModifier, Integer> entry : orig.entrySet()) {
            if (!ChallengerHelpers.canBeChallenger(entry.getKey(), entity)) continue;
            filtered.add(entry.getKey(), entry.getValue());
        }
        return filtered;
    }

    public static boolean canBeChallenger(ChallengerEntityModifier mob, Entity entity) {
        ResourceLocation type = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        boolean isBl = mob.isEntityFilterIsBlacklist();
        List<ResourceLocation> types = mob.getEntityFilter();
        return types.contains(type) && !isBl || !types.contains(type) && isBl;
    }
}

