/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.tweaks.entity.challenger;

import com.oitsjustjose.vtweaks.common.core.Tweak;
import com.oitsjustjose.vtweaks.common.core.VTweak;
import com.oitsjustjose.vtweaks.common.entity.ChallengerEntityModifier;
import com.oitsjustjose.vtweaks.common.tweaks.entity.challenger.ChallengerHelpers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@Tweak(eventClass=LivingSpawnEvent.CheckSpawn.class, category="entity")
public class ChallengerModifierHandler
extends VTweak {
    private ForgeConfigSpec.BooleanValue enabled;
    private ForgeConfigSpec.DoubleValue globalChance;

    @Override
    public void registerConfigs(ForgeConfigSpec.Builder builder) {
        this.enabled = builder.comment("A data-driven way to make some special mobs with abilities, effects, specialized loot and more!").define("enableChallengerMobs", true);
        this.globalChance = builder.comment("This controls the overall chance for V-Tweaks to attempt converting a monster to a Challenger.\nThis chance is applied before any Challenger Mob weights or entity filters.").defineInRange("challengerMobGlobalChance", 0.25, 0.0, 1.0);
    }

    @SubscribeEvent
    public void process(LivingSpawnEvent.CheckSpawn evt) {
        Mob mob;
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            return;
        }
        if ((Double)this.globalChance.get() <= 0.0) {
            return;
        }
        if (evt.getEntity() != null && (mob = evt.getEntity()) instanceof Monster) {
            Monster monster = (Monster)mob;
            if (evt.getLevel().m_5776_()) {
                return;
            }
            if (evt.getEntity().getPersistentData().m_128441_("challenger_mob_data")) {
                return;
            }
            if (evt.getLevel().m_213780_().m_188500_() > (Double)this.globalChance.get()) {
                return;
            }
            if (ChallengerHelpers.hasChallengerEntityModifier((Entity)monster)) {
                return;
            }
            ChallengerEntityModifier modifier = ChallengerHelpers.filterForEntity((Entity)monster).pick();
            if (modifier != null && ChallengerHelpers.canBeChallenger(modifier, (Entity)monster)) {
                modifier.apply(monster);
            }
        }
    }
}

