/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.common.util;

import com.oitsjustjose.vtweaks.VTweaks;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;

public class WeightedCollection<T> {
    private final HashMap<T, Integer> items = new HashMap();
    final Random random = new Random();

    public void clear() {
        this.items.clear();
    }

    public void add(T item, Integer chance) {
        this.items.put(item, chance);
    }

    public Set<T> getCollection() {
        return this.items.keySet();
    }

    public HashMap<T, Integer> getWeightMap() {
        return (HashMap)this.items.clone();
    }

    @Nullable
    public T pick() {
        int total = 0;
        for (Integer x : this.items.values()) {
            total += x.intValue();
        }
        if (total <= 0) {
            return null;
        }
        int rng = this.random.nextInt(total);
        for (Map.Entry<T, Integer> entry : this.items.entrySet()) {
            Integer wt = entry.getValue();
            if (rng < wt) {
                return entry.getKey();
            }
            rng -= wt.intValue();
        }
        VTweaks.getInstance().LOGGER.error("Could not reach decision on WeightedCollection#pick");
        return null;
    }
}

