/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.vtweaks.integration.jei;

import com.oitsjustjose.vtweaks.VTweaks;
import com.oitsjustjose.vtweaks.integration.jei.FluidConversionRecipeCategory;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@mezz.jei.api.JeiPlugin
public class JeiPlugin
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("vtweaks", "jei_recipes");

    @NotNull
    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IJeiHelpers jeiHelpers = registration.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new FluidConversionRecipeCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        List<IJeiAnvilRecipe> anvilRecipes = VTweaks.getInstance().getAnvilRecipes().values().stream().map(x -> registration.getVanillaRecipeFactory().createAnvilRecipe(x.getLeft(), List.of(x.getRight()), List.of(x.getResult()))).toList();
        registration.addRecipes(RecipeTypes.ANVIL, anvilRecipes);
        registration.addRecipes(FluidConversionRecipeCategory.TYPE, VTweaks.getInstance().getFluidConversionRecipes().values().stream().toList());
    }
}

