/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.villagercomfort.comfort;

import dev.ghen.villagercomfort.common.capabilty.IComfortValuesCap;
import dev.ghen.villagercomfort.core.config.CommonConfig;
import dev.ghen.villagercomfort.room.RoomHelper;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class WorkplaceComfortValues {
    public static void setValuesToCap(Villager villager, IComfortValuesCap comfortValuesCap) {
        villager.m_6274_().m_21952_(MemoryModuleType.f_26360_).ifPresent(workstation -> {
            ServerLevel level = (ServerLevel)villager.f_19853_;
            BlockPos workstationPos = workstation.m_122646_();
            BlockState workstationBlock = level.m_8055_(workstationPos);
            AtomicInteger workstationsCount = new AtomicInteger(0);
            AtomicInteger roomSize = new AtomicInteger(0);
            AtomicInteger maxLightValue = new AtomicInteger(0);
            RoomHelper.runForEveryBlock(villager.f_19853_, workstationPos, ((Number)CommonConfig.MAX_WORKPLACE_DIAMETER.get()).intValue(), pos -> {
                if (!pos.equals((Object)workstationPos) && level.m_8055_(pos).m_60713_(workstationBlock.m_60734_())) {
                    workstationsCount.getAndIncrement();
                } else if (level.m_8055_(pos).m_60713_(Blocks.f_50016_)) {
                    if (level.m_45517_(LightLayer.SKY, pos) > maxLightValue.get()) {
                        maxLightValue.set(level.m_45517_(LightLayer.SKY, pos));
                    }
                    roomSize.getAndIncrement();
                }
            });
            comfortValuesCap.setWorkplaceSize(roomSize.get());
            comfortValuesCap.setWorkstationsCount(workstationsCount.get() / 2);
            comfortValuesCap.setWorkplaceLight(maxLightValue.get());
        });
    }
}

