/*
 * Decompiled with CFR 0.152.
 */
package dev.ghen.villagercomfort.room;

import dev.ghen.villagercomfort.room.IRoomBlockAction;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class RoomHelper {
    private static final int DEF_MAX_DISTANCE = 5;

    public static void runForEveryBlock(Level level, BlockPos roomStartPos, IRoomBlockAction action) {
        ArrayList<BlockPos> room = new ArrayList<BlockPos>();
        RoomHelper.addBlockToRoom(level, roomStartPos, room, 5, action);
    }

    public static void runForEveryBlock(Level level, BlockPos roomStartPos, int maxDistance, IRoomBlockAction action) {
        ArrayList<BlockPos> room = new ArrayList<BlockPos>();
        RoomHelper.addBlockToRoom(level, roomStartPos, room, maxDistance / 2, action);
    }

    static void addBlockToRoom(Level level, BlockPos pos, List<BlockPos> room, int maxDistance, IRoomBlockAction action) {
        if (!room.contains(pos) && RoomHelper.isPosInBounds(pos, room, maxDistance)) {
            if (room.isEmpty() || level.m_8055_(pos).m_60713_(Blocks.f_50016_) && level.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_50016_)) {
                room.add(pos);
                RoomHelper.addBlockToRoom(level, new BlockPos((Vec3i)pos.m_122012_()), room, maxDistance, action);
                RoomHelper.addBlockToRoom(level, new BlockPos((Vec3i)pos.m_122019_()), room, maxDistance, action);
                RoomHelper.addBlockToRoom(level, new BlockPos((Vec3i)pos.m_122024_()), room, maxDistance, action);
                RoomHelper.addBlockToRoom(level, new BlockPos((Vec3i)pos.m_122029_()), room, maxDistance, action);
                RoomHelper.addBlockToRoom(level, new BlockPos((Vec3i)pos.m_7494_()), room, maxDistance, action);
                RoomHelper.addBlockToRoom(level, new BlockPos((Vec3i)pos.m_7495_()), room, maxDistance, action);
            }
            action.run(pos);
        }
    }

    static boolean isPosInBounds(BlockPos pos, List<BlockPos> room, int distance) {
        if (room.isEmpty()) {
            return true;
        }
        BlockPos startingPos = room.get(0);
        return pos.m_123341_() > startingPos.m_123341_() - distance && pos.m_123341_() < startingPos.m_123341_() + distance && pos.m_123342_() > startingPos.m_123342_() - distance && pos.m_123342_() < startingPos.m_123342_() + distance && pos.m_123343_() > startingPos.m_123343_() - distance && pos.m_123343_() < startingPos.m_123343_() + distance;
    }
}

