/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mods.waterstrainer.block.BlockStrainerBase;
import mods.waterstrainer.inventory.ContainerStrainer;
import mods.waterstrainer.item.ItemStrainer;
import mods.waterstrainer.tileentity.TileEntityStrainer;
import mods.waterstrainer.util.APIUtils;
import mods.waterstrainer.util.WaterStrainerUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class GuiStrainer
extends AbstractContainerScreen<ContainerStrainer> {
    private static final ResourceLocation guiTexture = new ResourceLocation("waterstrainer", "textures/gui/strainer_base.png");
    private final TileEntityStrainer tile;
    private final Inventory playerInventory;
    private EnumStatus status = EnumStatus.GREEN;
    private List<String> statusText = new ArrayList<String>();
    private List<Component> statusTextComponent = new ArrayList<Component>();
    private long updateTime = System.currentTimeMillis();

    public GuiStrainer(ContainerStrainer container, Inventory playerInventory, Component text) {
        super((AbstractContainerMenu)container, playerInventory, text);
        this.playerInventory = playerInventory;
        this.tile = container.strainer;
        this.f_97727_ = 226;
        this.refreshStatus();
    }

    public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        Slot slot;
        this.m_7333_(matrix);
        super.m_6305_(matrix, mouseX, mouseY, partialTicks);
        this.m_7025_(matrix, mouseX, mouseY);
        if (Math.abs(System.currentTimeMillis() - this.updateTime) > 250L) {
            this.updateTime = System.currentTimeMillis();
            this.refreshStatus();
        }
        if ((slot = this.getSlotUnderMouse()) != null) {
            int slotIndex = slot.getSlotIndex();
            if (slot.m_6657_()) {
                return;
            }
            if (slotIndex == 0) {
                this.m_96602_(matrix, (Component)Component.m_237113_((String)"Strainer Slot"), mouseX, mouseY);
            } else if (slotIndex == 28) {
                this.m_96602_(matrix, (Component)Component.m_237113_((String)"Bait Slot"), mouseX, mouseY);
            } else if (slotIndex == 29) {
                this.m_96602_(matrix, (Component)Component.m_237113_((String)"Bait Pot Slot"), mouseX, mouseY);
            }
        }
        if (this.isMouseHovering(mouseX, mouseY, this.getGuiLeft() + 98, this.getGuiTop() + 21, 3, 16)) {
            int progress = this.status != EnumStatus.RED ? this.getProgressPercentage() : 0;
            this.m_96602_(matrix, (Component)Component.m_237113_((String)(progress + "%")), mouseX, mouseY);
        } else if (this.isMouseHovering(mouseX, mouseY, this.getGuiLeft() + 155, this.getGuiTop() + 22, 16, 16)) {
            this.m_96597_(matrix, this.statusTextComponent, mouseX, mouseY);
        } else if (this.isMouseHovering(mouseX, mouseY, this.getGuiLeft() + 155, this.getGuiTop() + 5, 16, 16) && !APIUtils.isJEILoaded()) {
            this.m_96597_(matrix, Arrays.asList(Component.m_237113_((String)"Show Recipes"), Component.m_237113_((String)"This function is only available if you"), Component.m_237113_((String)WaterStrainerUtils.ctext("have #BLUE#Just Enough Items (JEI)#RESET# installed."))), mouseX, mouseY);
        }
    }

    protected void m_7027_(PoseStack matrix, int mouseX, int mouseY) {
        String s = this.tile.m_5446_().getString();
        this.f_96547_.m_92883_(matrix, s, (float)(this.f_97726_ / 2 - this.f_96547_.m_92895_(s) / 2), 6.0f, 0x404040);
        this.f_96547_.m_92883_(matrix, this.playerInventory.m_5446_().getString(), 8.0f, (float)(this.f_97727_ - 96 + 2), 0x404040);
    }

    protected void m_7286_(PoseStack matrix, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)guiTexture);
        int k = this.getGuiLeft();
        int l = this.getGuiTop();
        this.m_93228_(matrix, k, l, 0, 0, this.f_97726_, this.f_97727_);
        if (this.tile.inv.getStackInSlot(0).m_41619_()) {
            this.m_93228_(matrix, k + 80, l + 21, 176, 0, 16, 16);
        }
        if (this.tile.inv.getStackInSlot(28).m_41619_()) {
            this.m_93228_(matrix, k + 70, l + 41, 176, 32, 16, 16);
        }
        if (this.tile.inv.getStackInSlot(29).m_41619_()) {
            this.m_93228_(matrix, k + 90, l + 41, 176, 16, 16, 16);
        }
        if (this.status == EnumStatus.RED) {
            this.m_93228_(matrix, k + 155, l + 22, 176, 48, 16, 16);
        } else if (this.status == EnumStatus.YELLOW) {
            this.m_93228_(matrix, k + 155, l + 22, 176, 64, 16, 16);
        } else {
            this.m_93228_(matrix, k + 155, l + 22, 176, 80, 16, 16);
        }
        int length = this.status != EnumStatus.RED ? this.getProgressBarLength() : 0;
        this.m_93228_(matrix, k + 99, l + 35 - length, 192, 13 - length, 1, length + 1);
    }

    public boolean isMouseHovering(int mouse_x, int mouse_y, int x, int y, int xsize, int ysize) {
        return mouse_x >= x && mouse_x < x + xsize && mouse_y >= y && mouse_y < y + ysize;
    }

    private void refreshStatus() {
        this.statusText.clear();
        this.statusTextComponent.clear();
        if (!(this.tile.getStrainer().m_41720_() instanceof ItemStrainer)) {
            this.statusText.add("- Strainer missing");
        }
        if (!BlockStrainerBase.isStrainerInLiquid(this.tile.m_58904_(), this.tile.m_58899_())) {
            this.statusText.add("- Water missing");
        }
        if (this.getBaitStatus() == EnumBaitStatus.REQUIRED) {
            this.statusText.add("- Bait missing");
        }
        if (this.statusText.isEmpty()) {
            if (this.getBaitStatus() == EnumBaitStatus.REDUNDANT) {
                this.status = EnumStatus.YELLOW;
                this.statusText.add(0, ChatFormatting.YELLOW + "Status");
                this.statusText.add("- Bait redundant");
            } else {
                this.status = EnumStatus.GREEN;
                this.statusText.add(0, ChatFormatting.GREEN + "Status");
                this.statusText.add("No problems detected");
            }
        } else {
            this.status = EnumStatus.RED;
            this.statusText.add(0, ChatFormatting.RED + "Status");
        }
        for (String s : this.statusText) {
            this.statusTextComponent.add((Component)Component.m_237113_((String)s));
        }
    }

    private EnumBaitStatus getBaitStatus() {
        ItemStack stack = this.tile.inv.getStackInSlot(0);
        ItemStack bait = this.tile.inv.getStackInSlot(28);
        if (stack.m_41720_() instanceof ItemStrainer) {
            ItemStrainer strainer = (ItemStrainer)stack.m_41720_();
            if (strainer.TYPE.category != ItemStrainer.StrainerCategory.FISHER) {
                if (!bait.m_41619_()) {
                    return EnumBaitStatus.REDUNDANT;
                }
            } else if (bait.m_41619_()) {
                return EnumBaitStatus.REQUIRED;
            }
        }
        return EnumBaitStatus.NONE;
    }

    private int getProgressPercentage() {
        int curIdle = ((ContainerStrainer)this.f_97732_).getCurIdle();
        int maxIdle = ((ContainerStrainer)this.f_97732_).getMaxIdle();
        return curIdle > 0 && maxIdle > 0 ? (int)(100.0f / (float)maxIdle * (float)curIdle) : 0;
    }

    private int getProgressBarLength() {
        return (int)(0.14f * (float)this.getProgressPercentage());
    }

    private static enum EnumStatus {
        GREEN,
        YELLOW,
        RED;

    }

    private static enum EnumBaitStatus {
        NONE,
        REDUNDANT,
        REQUIRED;

    }
}

