/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import mods.waterstrainer.inventory.ContainerWormBin;
import mods.waterstrainer.tileentity.TileEntityWormBin;
import mods.waterstrainer.util.APIUtils;
import mods.waterstrainer.util.WaterStrainerUtils;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class GuiWormBin
extends AbstractContainerScreen<ContainerWormBin> {
    private static final ResourceLocation guiTexture = new ResourceLocation("waterstrainer", "textures/gui/worm_bin.png");
    private final TileEntityWormBin tile;
    private final Inventory playerInventory;

    public GuiWormBin(ContainerWormBin container, Inventory playerInventory, Component text) {
        super((AbstractContainerMenu)container, playerInventory, text);
        this.playerInventory = playerInventory;
        this.tile = container.wormBin;
        this.f_97727_ = 139;
    }

    public void m_6305_(PoseStack matrix, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrix);
        super.m_6305_(matrix, mouseX, mouseY, partialTicks);
        this.m_7025_(matrix, mouseX, mouseY);
        Slot slot = this.getSlotUnderMouse();
        if (slot != null) {
            int slotIndex = slot.getSlotIndex();
            if (slot.m_6657_()) {
                return;
            }
            if (slotIndex == 0) {
                this.m_96602_(matrix, (Component)Component.m_237113_((String)"Food Slot"), mouseX, mouseY);
            } else if (slotIndex == 1) {
                this.m_96602_(matrix, (Component)Component.m_237113_((String)"Worm Slot"), mouseX, mouseY);
            } else if (slotIndex == 2) {
                this.m_96602_(matrix, (Component)Component.m_237113_((String)"Fertilizer Slot"), mouseX, mouseY);
            }
        }
        if (this.isMouseHovering(mouseX, mouseY, this.getGuiLeft() + 93, this.getGuiTop() + 23, 3, 16)) {
            progress = this.getProgressPercentageWorm();
            this.m_96602_(matrix, (Component)Component.m_237113_((String)(progress + "%")), mouseX, mouseY);
        } else if (this.isMouseHovering(mouseX, mouseY, this.getGuiLeft() + 136, this.getGuiTop() + 23, 3, 16)) {
            progress = this.getProgressPercentageFertilizer();
            this.m_96602_(matrix, (Component)Component.m_237113_((String)(progress + "%")), mouseX, mouseY);
        } else if (this.isMouseHovering(mouseX, mouseY, this.getGuiLeft() + 155, this.getGuiTop() + 5, 16, 16) && !APIUtils.isJEILoaded()) {
            this.m_96597_(matrix, Arrays.asList(Component.m_237113_((String)"Show Recipes"), Component.m_237113_((String)"This function is only available if you"), Component.m_237113_((String)WaterStrainerUtils.ctext("have #BLUE#Just Enough Items (JEI)#RESET# installed."))), mouseX, mouseY);
        }
    }

    protected void m_7027_(PoseStack matrix, int mouseX, int mouseY) {
        String s = this.tile.m_5446_().getString();
        this.f_96547_.m_92883_(matrix, s, (float)(this.f_97726_ / 2 - this.f_96547_.m_92895_(s) / 2), 6.0f, 0x404040);
        this.f_96547_.m_92883_(matrix, this.playerInventory.m_5446_().getString(), 8.0f, (float)(this.f_97727_ - 96 + 2), 0x404040);
    }

    protected void m_7286_(PoseStack matrix, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)guiTexture);
        int k = this.getGuiLeft();
        int l = this.getGuiTop();
        this.m_93228_(matrix, k, l, 0, 0, this.getXSize(), this.f_97727_);
        if (this.tile.inv.getStackInSlot(0).m_41619_()) {
            this.m_93228_(matrix, k + 38, l + 23, 176, 0, 16, 16);
        }
        if (this.tile.inv.getStackInSlot(1).m_41619_()) {
            this.m_93228_(matrix, k + 98, l + 23, 176, 32, 16, 16);
        }
        if (this.tile.inv.getStackInSlot(2).m_41619_()) {
            this.m_93228_(matrix, k + 118, l + 23, 176, 16, 16, 16);
        }
        int length = this.getProgressBarLengthWorm();
        this.m_93228_(matrix, k + 94, l + 37 - length, 192, 13 - length, 1, length + 1);
        length = this.getProgressBarLengthFertilizer();
        this.m_93228_(matrix, k + 137, l + 37 - length, 192, 13 - length, 1, length + 1);
    }

    public boolean isMouseHovering(int mouse_x, int mouse_y, int x, int y, int xsize, int ysize) {
        return mouse_x >= x && mouse_x < x + xsize && mouse_y >= y && mouse_y < y + ysize;
    }

    private int getProgressPercentageWorm() {
        int min = ((ContainerWormBin)this.f_97732_).getMinWorm();
        int max = 4;
        return min > 0 && max > 0 ? (int)(100.0f / (float)max * (float)min) : 0;
    }

    private int getProgressBarLengthWorm() {
        return (int)(0.14f * (float)this.getProgressPercentageWorm());
    }

    private int getProgressPercentageFertilizer() {
        int min = ((ContainerWormBin)this.f_97732_).getMinFertilizer();
        int max = 20;
        return min > 0 && max > 0 ? (int)(100.0f / (float)max * (float)min) : 0;
    }

    private int getProgressBarLengthFertilizer() {
        return (int)(0.14f * (float)this.getProgressPercentageFertilizer());
    }
}

