/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.core.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.RenderTypeHelper;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import xyz.apex.forge.apexcore.core.init.ACRegistry;
import xyz.apex.forge.apexcore.lib.block.BaseBlock;
import xyz.apex.forge.apexcore.lib.block.IMultiBlock;
import xyz.apex.forge.apexcore.lib.event.client.BlockVisualizerEvent;
import xyz.apex.forge.apexcore.lib.util.RegistryHelper;
import xyz.apex.forge.commonality.SideOnly;

@Mod.EventBusSubscriber(modid="apexcore", value={Dist.CLIENT})
@SideOnly(value=SideOnly.Side.CLIENT)
public final class BlockVisualizer {
    @Nullable
    private static MultiBufferSource.BufferSource ghostBuffers = null;

    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            Minecraft mc = Minecraft.m_91087_();
            PoseStack pose = event.getPoseStack();
            for (InteractionHand hand : InteractionHand.values()) {
                if (BlockVisualizer.tryRenderBlock(mc, pose, hand)) break;
            }
        }
    }

    private static boolean tryRenderBlock(Minecraft mc, PoseStack pose, InteractionHand hand) {
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return false;
        }
        ItemStack stack = mc.f_91074_.m_21120_(hand);
        Block block = Block.m_49814_((Item)stack.m_41720_());
        if (block == Blocks.f_50016_) {
            return false;
        }
        if (!RegistryHelper.hasTag(ForgeRegistries.BLOCKS, ACRegistry.TAG_VISUALIZER, block)) {
            return false;
        }
        HitResult hitResult = mc.f_91077_;
        if (!(hitResult instanceof BlockHitResult)) {
            return false;
        }
        BlockHitResult result = (BlockHitResult)hitResult;
        BlockPos pos = result.m_82425_();
        if (mc.f_91073_.m_46859_(pos)) {
            return false;
        }
        Context ctx = BlockVisualizer.getRenderBlockState(mc.f_91073_, mc.f_91074_, hand, stack, block, pos, result);
        if (ctx.blockState.m_60799_() != RenderShape.MODEL) {
            return false;
        }
        Vec3 position = mc.m_91290_().f_114358_.m_90583_();
        MultiBufferSource.BufferSource buffers = mc.m_91269_().m_110104_();
        RenderType type = RenderType.m_110504_();
        if (ghostBuffers == null) {
            ghostBuffers = BlockVisualizer.initBuffers(buffers);
        }
        pose.m_85836_();
        pose.m_85837_(-position.f_82479_, -position.f_82480_, -position.f_82481_);
        MinecraftForge.EVENT_BUS.post((Event)new BlockVisualizerEvent.Render.Pre(ctx));
        BlockVisualizer.renderBlock(mc, ctx, pose, ghostBuffers);
        MinecraftForge.EVENT_BUS.post((Event)new BlockVisualizerEvent.Render.Post(ctx));
        buffers.m_109912_(type);
        ghostBuffers.m_109911_();
        pose.m_85849_();
        return true;
    }

    private static Context getRenderBlockState(ClientLevel level, LocalPlayer player, InteractionHand hand, ItemStack stack, Block block, BlockPos pos, BlockHitResult result) {
        BlockPlaceContext placeContext = new BlockPlaceContext(new UseOnContext((Level)level, (Player)player, hand, stack, result));
        BlockState placeState = block.m_5573_(placeContext);
        boolean defaultState = false;
        if (placeState == null) {
            defaultState = true;
            placeState = block.m_49966_();
            Block block2 = placeState.m_60734_();
            if (block2 instanceof BaseBlock) {
                Direction facing;
                BaseBlock base = (BaseBlock)block2;
                if (BaseBlock.supportsFacing(placeState) && (facing = base.getFourWayFacing(placeContext)) != null) {
                    placeState = BaseBlock.setFacing(placeState, facing);
                }
            }
        }
        BlockState levelState = level.m_8055_(pos);
        BlockPos renderPos = pos;
        Direction direction = result.m_82434_();
        if (!levelState.m_60629_(placeContext)) {
            renderPos = pos.m_121945_(direction);
        }
        Context ctx = new Context(placeState, level, renderPos, player, hand, stack, direction, 0);
        if (defaultState) {
            ctx = BlockVisualizer.modifyBlockState(ctx, BlockVisualizerEvent.ModifyContext.Reason.DEFAULT_BLOCKSTATE);
        }
        ctx = BlockVisualizer.modifyBlockState(ctx, BlockVisualizerEvent.ModifyContext.Reason.EXISTING_BLOCKSTATE);
        placeState = BaseBlock.setWaterLogged(ctx.blockState, false);
        return ctx.with(placeState);
    }

    private static Context modifyBlockState(Context ctx, BlockVisualizerEvent.ModifyContext.Reason reason) {
        Block block;
        BlockVisualizerEvent.ModifyContext event = new BlockVisualizerEvent.ModifyContext(ctx, reason);
        MinecraftForge.EVENT_BUS.post((Event)event);
        ctx = event.getContext();
        if (reason == BlockVisualizerEvent.ModifyContext.Reason.DEFAULT_BLOCKSTATE && (block = ctx.blockState.m_60734_()) instanceof IMultiBlock) {
            IMultiBlock multiBlock = (IMultiBlock)block;
            ctx = ctx.with(multiBlock.setMultiBlockIndex(ctx.blockState, 0));
        }
        return ctx;
    }

    private static void renderBlock(Minecraft mc, Context ctx, PoseStack pose, MultiBufferSource.BufferSource bufferSource) {
        Block localPositions;
        boolean isValid = true;
        Block block = ctx.blockState.m_60734_();
        if (block instanceof IMultiBlock) {
            IMultiBlock multiBlock = (IMultiBlock)block;
            BlockPos origin = multiBlock.getMultiBlockOriginPos(ctx.blockState, ctx.pos);
            localPositions = multiBlock.getMultiBlockLocalPositions();
            for (int i = 0; i < localPositions.size(); ++i) {
                BlockPos localPos = (BlockPos)localPositions.get(i);
                BlockPos worldPos = multiBlock.getMultiBlockWorldSpaceFromLocalSpace(ctx.blockState, origin, localPos);
                BlockState renderState = multiBlock.setMultiBlockIndex(ctx.blockState, i);
                BlockState worldState = ctx.level.m_8055_(worldPos);
                if (!renderState.m_60710_((LevelReader)ctx.level, worldPos)) {
                    isValid = false;
                } else {
                    if (multiBlock.getMultiBlockPattern().passesPlacementTests(multiBlock, (LevelReader)ctx.level, worldPos, renderState, worldState)) continue;
                    isValid = false;
                }
                break;
            }
        } else {
            BlockState worldState = ctx.level.m_8055_(ctx.pos);
            if (!worldState.m_60767_().m_76336_()) {
                isValid = false;
            }
        }
        int overlay = isValid ? OverlayTexture.f_118083_ : OverlayTexture.m_118093_((int)0, (int)3);
        localPositions = ctx.blockState.m_60734_();
        if (localPositions instanceof IMultiBlock) {
            IMultiBlock multiBlock = (IMultiBlock)localPositions;
            BlockPos origin = multiBlock.getMultiBlockOriginPos(ctx.blockState, ctx.pos);
            List<BlockPos> localPositions2 = multiBlock.getMultiBlockLocalPositions();
            for (int i = 0; i < localPositions2.size(); ++i) {
                BlockPos localPos = localPositions2.get(i);
                BlockPos worldPos = multiBlock.getMultiBlockWorldSpaceFromLocalSpace(ctx.blockState, origin, localPos);
                BlockState renderState = multiBlock.setMultiBlockIndex(ctx.blockState, i);
                Context newRenderCtx = ctx.with(worldPos).with(renderState);
                BlockVisualizer.renderBlockState(mc, newRenderCtx, pose, bufferSource, overlay);
            }
        } else {
            BlockVisualizer.renderBlockState(mc, ctx, pose, bufferSource, overlay);
        }
    }

    private static void renderBlockState(Minecraft mc, Context ctx, PoseStack pose, MultiBufferSource.BufferSource bufferSource, int overlay) {
        Vec3 offset = ctx.blockState.m_60824_((BlockGetter)ctx.level, ctx.pos);
        double x = (double)ctx.pos.m_123341_() + offset.f_82479_;
        double y = (double)ctx.pos.m_123342_() + offset.f_82480_;
        double z = (double)ctx.pos.m_123343_() + offset.f_82481_;
        pose.m_85837_(x, y, z);
        pose.m_85836_();
        BlockRenderDispatcher blockRenderer = mc.m_91289_();
        if (ctx.blockState.m_60799_() == RenderShape.MODEL) {
            BakedModel model = blockRenderer.m_110910_(ctx.blockState);
            int blockColor = mc.m_91298_().m_92577_(ctx.blockState, null, null, ctx.tintIndex);
            float r = (float)FastColor.ARGB32.m_13665_((int)blockColor) / 255.0f;
            float g = (float)FastColor.ARGB32.m_13667_((int)blockColor) / 255.0f;
            float b = (float)FastColor.ARGB32.m_13669_((int)blockColor) / 255.0f;
            for (RenderType renderType : model.getRenderTypes(ctx.blockState, RandomSource.m_216335_((long)42L), ModelData.EMPTY)) {
                PoseStack.Pose last = pose.m_85850_();
                VertexConsumer buffer = bufferSource.m_6299_(RenderTypeHelper.getEntityRenderType((RenderType)renderType, (boolean)false));
                blockRenderer.m_110937_().renderModel(last, buffer, ctx.blockState, model, r, g, b, 240, overlay, ModelData.EMPTY, renderType);
            }
        } else {
            blockRenderer.renderSingleBlock(ctx.blockState, pose, (MultiBufferSource)bufferSource, 240, overlay, ModelData.EMPTY, null);
        }
        pose.m_85849_();
        pose.m_85837_(-x, -y, -z);
    }

    private static MultiBufferSource.BufferSource initBuffers(MultiBufferSource.BufferSource original) {
        Object2ObjectLinkedOpenHashMap remapped = new Object2ObjectLinkedOpenHashMap();
        for (Map.Entry entry : original.f_109905_.entrySet()) {
            remapped.put((Object)GhostRenderLayer.remap((RenderType)entry.getKey()), (Object)((BufferBuilder)entry.getValue()));
        }
        return new GhostBuffers(original.f_109904_, (Map<RenderType, BufferBuilder>)remapped);
    }

    public record Context(BlockState blockState, ClientLevel level, BlockPos pos, LocalPlayer player, InteractionHand hand, ItemStack stack, Direction face, int tintIndex) {
        public Context with(BlockState blockState) {
            return new Context(blockState, this.level, this.pos, this.player, this.hand, this.stack, this.face, this.tintIndex);
        }

        public Context with(ClientLevel level) {
            return new Context(this.blockState, level, this.pos, this.player, this.hand, this.stack, this.face, this.tintIndex);
        }

        public Context with(BlockPos pos) {
            return new Context(this.blockState, this.level, pos, this.player, this.hand, this.stack, this.face, this.tintIndex);
        }

        public Context with(LocalPlayer player) {
            return new Context(this.blockState, this.level, this.pos, player, this.hand, this.stack, this.face, this.tintIndex);
        }

        public Context with(InteractionHand hand) {
            return new Context(this.blockState, this.level, this.pos, this.player, hand, this.stack, this.face, this.tintIndex);
        }

        public Context with(ItemStack stack) {
            return new Context(this.blockState, this.level, this.pos, this.player, this.hand, stack, this.face, this.tintIndex);
        }

        public Context with(Direction face) {
            return new Context(this.blockState, this.level, this.pos, this.player, this.hand, this.stack, face, this.tintIndex);
        }

        public Context with(int tintIndex) {
            return new Context(this.blockState, this.level, this.pos, this.player, this.hand, this.stack, this.face, tintIndex);
        }
    }

    private static final class GhostRenderLayer
    extends RenderType {
        private static final Map<RenderType, RenderType> remappedTypes = new IdentityHashMap<RenderType, RenderType>();

        public GhostRenderLayer(RenderType original) {
            super("%s_%s_ghost".formatted(original, "apexcore"), original.m_110508_(), original.m_173186_(), original.m_110507_(), original.m_110405_(), true, () -> {
                original.m_110185_();
                RenderSystem.m_69465_();
                RenderSystem.m_69478_();
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)0.65f);
            }, () -> {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.m_69461_();
                RenderSystem.m_69482_();
                original.m_110188_();
            });
        }

        public static RenderType remap(RenderType in) {
            if (in instanceof GhostRenderLayer) {
                return in;
            }
            return remappedTypes.computeIfAbsent(in, GhostRenderLayer::new);
        }
    }

    private static final class GhostBuffers
    extends MultiBufferSource.BufferSource {
        private GhostBuffers(BufferBuilder fallback, Map<RenderType, BufferBuilder> buffers) {
            super(fallback, buffers);
        }

        public VertexConsumer m_6299_(RenderType renderType) {
            return super.m_6299_(GhostRenderLayer.remap(renderType));
        }
    }
}

