/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.thecsdev.betterstats.client.gui.other.BSTooltipElement;
import io.github.thecsdev.betterstats.client.gui.panel.BSPanel_Downloading;
import io.github.thecsdev.betterstats.client.gui.panel.BSPanel_Statistics;
import io.github.thecsdev.betterstats.util.StatUtils;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TTooltipElement;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TScreenPlus;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.achievement.StatsUpdateListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.stats.StatsCounter;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class BetterStatsScreen
extends TScreenPlus
implements StatsUpdateListener {
    public static final String FEEDBACK_URL = "https://github.com/TheCSDev/mc-better-stats";
    protected boolean STATUS_RECIEVED = false;
    public final Screen parent;
    protected final StatsCounter localStatHandler;
    protected BSPanel_Downloading panel_download;
    protected BSPanel_Statistics panel_stats;
    public CurrentTab filter_currentTab;
    public String filter_searchTerm;
    public double filter_statsScroll;
    public static boolean filter_showEmpty = false;

    public BetterStatsScreen(Screen parent) {
        super((Component)TextUtils.translatable((String)"gui.stats", (Object[])new Object[0]));
        this.f_96541_ = Minecraft.m_91087_();
        this.parent = parent;
        this.localStatHandler = this.f_96541_.f_91074_.m_108630_();
        this.filter_currentTab = CurrentTab.General;
        this.filter_searchTerm = "";
        this.filter_statsScroll = 0.0;
    }

    protected TTooltipElement __createTooltip() {
        return new BSTooltipElement(this.getTpeWidth() / 2);
    }

    public void onOpened() {
        if (!this.STATUS_RECIEVED) {
            this.sendStatsRequest();
        }
    }

    public boolean shouldRenderInGameHud() {
        return false;
    }

    public void sendStatsRequest() {
        if (this.panel_download != null) {
            this.panel_download.setVisible(true);
        }
        BetterStatsScreen.sendStatsRequestPacket();
    }

    public static void sendStatsRequestPacket() {
        Minecraft client = Minecraft.m_91087_();
        ServerboundClientCommandPacket packet = new ServerboundClientCommandPacket(ServerboundClientCommandPacket.Action.REQUEST_STATS);
        client.m_91403_().m_104955_((Packet)packet);
    }

    public StatsCounter getStatHandler() {
        return this.localStatHandler;
    }

    @Nullable
    public BSPanel_Statistics getStatPanel() {
        return this.panel_stats;
    }

    public Predicate<StatUtils.StatUtilsStat> getStatPredicate() {
        return this.getStatPredicate_emptyFilter().and(this.getStatPredicate_searchFilter());
    }

    public Predicate<StatUtils.StatUtilsStat> getStatPredicate_emptyFilter() {
        return stat -> filter_showEmpty || !stat.isEmpty();
    }

    public Predicate<StatUtils.StatUtilsStat> getStatPredicate_searchFilter() {
        return stat -> {
            if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{this.filter_searchTerm})) {
                return true;
            }
            String lbl = stat.label.getString().toLowerCase().replaceAll("\\s+", "");
            String st = this.filter_searchTerm.toLowerCase().replaceAll("\\s+", "");
            return lbl.contains(st);
        };
    }

    protected void m_7856_() {
        this.panel_download = new BSPanel_Downloading(this);
        this.panel_stats = new BSPanel_Statistics(this);
        this.addTChild((TElement)this.panel_download);
        this.addTChild((TElement)this.panel_stats);
        if (this.STATUS_RECIEVED) {
            this.m_7819_();
        } else {
            this.panel_download.setVisible(true);
        }
    }

    public void m_7819_() {
        this.STATUS_RECIEVED = true;
        if (this.panel_download == null || this.panel_stats == null) {
            return;
        }
        this.panel_download.setVisible(false);
        this.panel_stats.setVisible(true);
        this.panel_stats.clearTChildren();
        if (this.getStatHandler() != null) {
            this.panel_stats.init();
        }
    }

    public void m_7333_(PoseStack matrices) {
    }

    public static enum CurrentTab {
        General(TextUtils.translatable((String)"stat.generalButton", (Object[])new Object[0])),
        Items(TextUtils.translatable((String)"stat.itemsButton", (Object[])new Object[0])),
        Entities(TextUtils.translatable((String)"stat.mobsButton", (Object[])new Object[0])),
        FoodStuffs(TextUtils.translatable((String)"advancements.husbandry.balanced_diet.title", (Object[])new Object[0])),
        MonstersHunted(TextUtils.translatable((String)"advancements.adventure.kill_all_mobs.title", (Object[])new Object[0]));

        private final MutableComponent text;

        private CurrentTab(MutableComponent text) {
            this.text = text;
        }

        public MutableComponent asText() {
            return this.text;
        }
    }
}

