/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.bakedmodels;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelper;
import mod.pianomanu.blockcarpentry.util.ModelHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.block.WoodButtonBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public class IllusionButtonBakedModel
implements IDynamicBakedModel {
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, RenderType renderType) {
        BlockState mimic = (BlockState)extraData.get(FrameBlockTile.MIMIC);
        if (mimic != null) {
            ModelResourceLocation location = BlockModelShaper.m_110895_((BlockState)mimic);
            BakedModel model = Minecraft.m_91087_().m_91304_().m_119422_(location);
            return this.getIllusionQuads(state, side, rand, extraData, model);
        }
        return Collections.emptyList();
    }

    private List<BakedQuad> getIllusionQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, BakedModel model) {
        if (side != null) {
            return Collections.emptyList();
        }
        BlockState mimic = (BlockState)extraData.get(FrameBlockTile.MIMIC);
        if (mimic != null && state != null) {
            int tintIndex = BlockAppearanceHelper.setTintIndex(mimic);
            int rotation = (Integer)extraData.get(FrameBlockTile.ROTATION);
            float yl = 0.0f;
            float yh = 0.125f;
            if (((AttachFace)state.m_61143_((Property)WoodButtonBlock.f_53179_)).equals((Object)AttachFace.CEILING)) {
                yl = 0.875f;
                yh = 1.0f;
            }
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            block0 : switch ((AttachFace)state.m_61143_((Property)WoodButtonBlock.f_53179_)) {
                case WALL: {
                    switch ((Direction)state.m_61143_((Property)WoodButtonBlock.f_54117_)) {
                        case NORTH: {
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.3125f, 0.6875f, 0.375f, 0.625f, 0.875f, 1.0f, mimic, model, extraData, rand, tintIndex, rotation));
                            break;
                        }
                        case EAST: {
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.0f, 0.125f, 0.375f, 0.625f, 0.3125f, 0.6875f, mimic, model, extraData, rand, tintIndex, rotation));
                            break;
                        }
                        case WEST: {
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.875f, 1.0f, 0.375f, 0.625f, 0.3125f, 0.6875f, mimic, model, extraData, rand, tintIndex, rotation));
                            break;
                        }
                        case SOUTH: {
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.3125f, 0.6875f, 0.375f, 0.625f, 0.0f, 0.125f, mimic, model, extraData, rand, tintIndex, rotation));
                        }
                    }
                    break;
                }
                case FLOOR: 
                case CEILING: {
                    switch ((Direction)state.m_61143_((Property)WoodButtonBlock.f_54117_)) {
                        case EAST: 
                        case WEST: {
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.375f, 0.625f, yl, yh, 0.3125f, 0.6875f, mimic, model, extraData, rand, tintIndex, rotation));
                            break block0;
                        }
                        case NORTH: 
                        case SOUTH: {
                            quads.addAll(ModelHelper.createSixFaceCuboid(0.3125f, 0.6875f, yl, yh, 0.375f, 0.625f, mimic, model, extraData, rand, tintIndex, rotation));
                        }
                    }
                }
            }
            int overlayIndex = (Integer)extraData.get(FrameBlockTile.OVERLAY);
            if (overlayIndex != 0) {
                block14 : switch ((AttachFace)state.m_61143_((Property)WoodButtonBlock.f_53179_)) {
                    case WALL: {
                        switch ((Direction)state.m_61143_((Property)WoodButtonBlock.f_54117_)) {
                            case NORTH: {
                                quads.addAll(ModelHelper.createOverlay(0.3125f, 0.6875f, 0.375f, 0.625f, 0.875f, 1.0f, overlayIndex));
                                break;
                            }
                            case EAST: {
                                quads.addAll(ModelHelper.createOverlay(0.0f, 0.125f, 0.375f, 0.625f, 0.3125f, 0.6875f, overlayIndex));
                                break;
                            }
                            case WEST: {
                                quads.addAll(ModelHelper.createOverlay(0.875f, 1.0f, 0.375f, 0.625f, 0.3125f, 0.6875f, overlayIndex));
                                break;
                            }
                            case SOUTH: {
                                quads.addAll(ModelHelper.createOverlay(0.3125f, 0.6875f, 0.375f, 0.625f, 0.0f, 0.125f, overlayIndex));
                            }
                        }
                        break;
                    }
                    case FLOOR: 
                    case CEILING: {
                        switch ((Direction)state.m_61143_((Property)WoodButtonBlock.f_54117_)) {
                            case EAST: 
                            case WEST: {
                                quads.addAll(ModelHelper.createOverlay(0.375f, 0.625f, yl, yh, 0.3125f, 0.6875f, overlayIndex));
                                break block14;
                            }
                            case NORTH: 
                            case SOUTH: {
                                quads.addAll(ModelHelper.createOverlay(0.3125f, 0.6875f, yl, yh, 0.375f, 0.625f, overlayIndex));
                            }
                        }
                    }
                }
            }
            return quads;
        }
        return Collections.emptyList();
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public boolean m_7521_() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(new ResourceLocation("minecraft", "block/oak_planks"));
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }

    @NotNull
    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110466_()});
    }
}

