/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.block;

import java.util.function.Supplier;
import mod.pianomanu.blockcarpentry.block.StairsFrameBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SlopeFrameBlock
extends StairsFrameBlock {
    private static final VoxelShape[] SHAPES_BOTTOM = SlopeFrameBlock.makeShapes(false);
    private static final VoxelShape[] SHAPES_TOP = SlopeFrameBlock.makeShapes(true);

    public SlopeFrameBlock(Supplier<BlockState> state, BlockBehaviour.Properties properties) {
        super(state, properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)CONTAINS_BLOCK, (Comparable)Boolean.FALSE)).m_61124_((Property)f_56842_, (Comparable)Half.BOTTOM)).m_61124_((Property)f_56843_, (Comparable)StairsShape.STRAIGHT)).m_61124_((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    private static VoxelShape[] makeShapes(boolean isTop) {
        VoxelShape[] shapes = new VoxelShape[20];
        VoxelShape[] straightShapesTop = SlopeFrameBlock.createStraightShapes(true);
        VoxelShape[] straightShapesBottom = SlopeFrameBlock.createStraightShapes(false);
        VoxelShape[] outerShapesTop = SlopeFrameBlock.createOuterShapes(true);
        VoxelShape[] outerShapesBottom = SlopeFrameBlock.createOuterShapes(false);
        if (isTop) {
            shapes[0] = straightShapesTop[0];
            shapes[1] = straightShapesTop[1];
            shapes[2] = straightShapesTop[2];
            shapes[3] = straightShapesTop[3];
            shapes[4] = Shapes.m_83110_((VoxelShape)straightShapesTop[0], (VoxelShape)straightShapesTop[3]);
            shapes[5] = Shapes.m_83110_((VoxelShape)straightShapesTop[1], (VoxelShape)straightShapesTop[0]);
            shapes[6] = Shapes.m_83110_((VoxelShape)straightShapesTop[2], (VoxelShape)straightShapesTop[1]);
            shapes[7] = Shapes.m_83110_((VoxelShape)straightShapesTop[3], (VoxelShape)straightShapesTop[2]);
            shapes[8] = Shapes.m_83110_((VoxelShape)straightShapesTop[0], (VoxelShape)straightShapesTop[1]);
            shapes[9] = Shapes.m_83110_((VoxelShape)straightShapesTop[1], (VoxelShape)straightShapesTop[2]);
            shapes[10] = Shapes.m_83110_((VoxelShape)straightShapesTop[2], (VoxelShape)straightShapesTop[3]);
            shapes[11] = Shapes.m_83110_((VoxelShape)straightShapesTop[3], (VoxelShape)straightShapesTop[0]);
            shapes[12] = outerShapesTop[3];
            shapes[13] = outerShapesTop[0];
            shapes[14] = outerShapesTop[1];
            shapes[15] = outerShapesTop[2];
            shapes[16] = outerShapesTop[0];
            shapes[17] = outerShapesTop[1];
            shapes[18] = outerShapesTop[2];
            shapes[19] = outerShapesTop[3];
        } else {
            shapes[0] = straightShapesBottom[0];
            shapes[1] = straightShapesBottom[1];
            shapes[2] = straightShapesBottom[2];
            shapes[3] = straightShapesBottom[3];
            shapes[4] = Shapes.m_83110_((VoxelShape)straightShapesBottom[0], (VoxelShape)straightShapesBottom[3]);
            shapes[5] = Shapes.m_83110_((VoxelShape)straightShapesBottom[1], (VoxelShape)straightShapesBottom[0]);
            shapes[6] = Shapes.m_83110_((VoxelShape)straightShapesBottom[2], (VoxelShape)straightShapesBottom[1]);
            shapes[7] = Shapes.m_83110_((VoxelShape)straightShapesBottom[3], (VoxelShape)straightShapesBottom[2]);
            shapes[8] = Shapes.m_83110_((VoxelShape)straightShapesBottom[0], (VoxelShape)straightShapesBottom[1]);
            shapes[9] = Shapes.m_83110_((VoxelShape)straightShapesBottom[1], (VoxelShape)straightShapesBottom[2]);
            shapes[10] = Shapes.m_83110_((VoxelShape)straightShapesBottom[2], (VoxelShape)straightShapesBottom[3]);
            shapes[11] = Shapes.m_83110_((VoxelShape)straightShapesBottom[3], (VoxelShape)straightShapesBottom[0]);
            shapes[12] = outerShapesBottom[3];
            shapes[13] = outerShapesBottom[0];
            shapes[14] = outerShapesBottom[1];
            shapes[15] = outerShapesBottom[2];
            shapes[16] = outerShapesBottom[0];
            shapes[17] = outerShapesBottom[1];
            shapes[18] = outerShapesBottom[2];
            shapes[19] = outerShapesBottom[3];
        }
        return shapes;
    }

    private static VoxelShape[] createStraightShapes(boolean isTop) {
        VoxelShape[] shapes = new VoxelShape[16];
        VoxelShape[] straightShapes = new VoxelShape[4];
        for (int facing = 0; facing < 4; ++facing) {
            for (int i = 0; i < 16; ++i) {
                if (!isTop) {
                    if (facing == 0) {
                        shapes[i] = Block.m_49796_((double)0.0, (double)i, (double)i, (double)16.0, (double)(i + 1), (double)16.0);
                        continue;
                    }
                    if (facing == 1) {
                        shapes[i] = Block.m_49796_((double)0.0, (double)i, (double)0.0, (double)(16 - i), (double)(i + 1), (double)16.0);
                        continue;
                    }
                    if (facing == 2) {
                        shapes[i] = Block.m_49796_((double)0.0, (double)i, (double)0.0, (double)16.0, (double)(i + 1), (double)(16 - i));
                        continue;
                    }
                    if (facing != 3) continue;
                    shapes[i] = Block.m_49796_((double)i, (double)i, (double)0.0, (double)16.0, (double)(i + 1), (double)16.0);
                    continue;
                }
                if (facing == 0) {
                    shapes[i] = Block.m_49796_((double)0.0, (double)i, (double)(15 - i), (double)16.0, (double)(i + 1), (double)16.0);
                    continue;
                }
                if (facing == 1) {
                    shapes[i] = Block.m_49796_((double)0.0, (double)i, (double)0.0, (double)(i + 1), (double)(i + 1), (double)16.0);
                    continue;
                }
                if (facing == 2) {
                    shapes[i] = Block.m_49796_((double)0.0, (double)i, (double)0.0, (double)16.0, (double)(i + 1), (double)(i + 1));
                    continue;
                }
                if (facing != 3) continue;
                shapes[i] = Block.m_49796_((double)(15 - i), (double)i, (double)0.0, (double)16.0, (double)(i + 1), (double)16.0);
            }
            straightShapes[facing] = Shapes.m_83124_((VoxelShape)shapes[0], (VoxelShape[])new VoxelShape[]{shapes[1], shapes[2], shapes[3], shapes[4], shapes[5], shapes[6], shapes[7], shapes[8], shapes[9], shapes[10], shapes[11], shapes[12], shapes[13], shapes[14], shapes[15]});
        }
        return straightShapes;
    }

    private static VoxelShape[] createOuterShapes(boolean isTop) {
        VoxelShape[] shapes = new VoxelShape[16];
        VoxelShape[] straightShapes = new VoxelShape[4];
        for (int facing = 0; facing < 4; ++facing) {
            for (int i = 0; i < 16; ++i) {
                if (!isTop) {
                    if (facing == 0) {
                        shapes[i] = Block.m_49796_((double)0.0, (double)i, (double)i, (double)(16 - i), (double)(i + 1), (double)16.0);
                        continue;
                    }
                    if (facing == 1) {
                        shapes[i] = Block.m_49796_((double)0.0, (double)i, (double)0.0, (double)(16 - i), (double)(i + 1), (double)(16 - i));
                        continue;
                    }
                    if (facing == 2) {
                        shapes[i] = Block.m_49796_((double)i, (double)i, (double)0.0, (double)16.0, (double)(i + 1), (double)(16 - i));
                        continue;
                    }
                    if (facing != 3) continue;
                    shapes[i] = Block.m_49796_((double)i, (double)i, (double)i, (double)16.0, (double)(i + 1), (double)16.0);
                    continue;
                }
                if (facing == 0) {
                    shapes[i] = Block.m_49796_((double)0.0, (double)i, (double)(15 - i), (double)(i + 1), (double)(i + 1), (double)16.0);
                    continue;
                }
                if (facing == 1) {
                    shapes[i] = Block.m_49796_((double)0.0, (double)i, (double)0.0, (double)(i + 1), (double)(i + 1), (double)(i + 1));
                    continue;
                }
                if (facing == 2) {
                    shapes[i] = Block.m_49796_((double)(15 - i), (double)i, (double)0.0, (double)16.0, (double)(i + 1), (double)(i + 1));
                    continue;
                }
                if (facing != 3) continue;
                shapes[i] = Block.m_49796_((double)(15 - i), (double)i, (double)(15 - i), (double)16.0, (double)(i + 1), (double)16.0);
            }
            straightShapes[facing] = Shapes.m_83124_((VoxelShape)shapes[0], (VoxelShape[])new VoxelShape[]{shapes[1], shapes[2], shapes[3], shapes[4], shapes[5], shapes[6], shapes[7], shapes[8], shapes[9], shapes[10], shapes[11], shapes[12], shapes[13], shapes[14], shapes[15]});
        }
        return straightShapes;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        return (state.m_61143_((Property)f_56842_) == Half.TOP ? SHAPES_TOP : SHAPES_BOTTOM)[this.getShapeIndex(state)];
    }

    private int getShapeIndex(BlockState state) {
        return ((StairsShape)state.m_61143_((Property)f_56843_)).ordinal() * 4 + ((Direction)state.m_61143_((Property)StairBlock.f_56841_)).m_122416_();
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitresult) {
        return super.m_6227_(state, level, pos, player, hand, hitresult);
    }
}

