/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.block;

import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.block.IFrameBlock;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.tileentity.LockableFrameTile;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class TrapdoorFrameBlock
extends TrapDoorBlock
implements EntityBlock,
IFrameBlock {
    public TrapdoorFrameBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_57514_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_57516_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CONTAINS_BLOCK, (Comparable)Boolean.FALSE)).m_61124_((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{CONTAINS_BLOCK, LIGHT_LEVEL});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new LockableFrameTile(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitresult) {
        ItemStack itemStack = player.m_21120_(hand);
        if (!level.f_46443_ && hand == InteractionHand.MAIN_HAND) {
            LockableFrameTile trapdoorTileEntity;
            this.convertOutdatedTile(state, level, pos, player);
            if (this.shouldCallFrameUse(state, itemStack)) {
                return this.frameUse(state, level, pos, player, hand, hitresult);
            }
            if (this.lockRedstoneSignal(state, level, pos, player, itemStack) || this.lockOpenClose(state, level, pos, player, itemStack)) {
                return InteractionResult.CONSUME;
            }
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof LockableFrameTile && (trapdoorTileEntity = (LockableFrameTile)tileEntity).canBeOpenedByPlayers()) {
                super.m_6227_(state, level, pos, player, hand, hitresult);
                this.m_57527_(null, level, pos, (Boolean)state.m_61143_((Property)f_57514_));
                return InteractionResult.SUCCESS;
            }
        }
        return itemStack.m_41720_() instanceof BlockItem ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    private void convertOutdatedTile(BlockState state, Level level, BlockPos pos, Player player) {
        LockableFrameTile newTile;
        BlockEntity tileEntity = level.m_7702_(pos);
        if (!(tileEntity instanceof LockableFrameTile) && tileEntity instanceof FrameBlockTile && (newTile = (LockableFrameTile)this.m_142194_(pos, state)) != null) {
            newTile.addFromOutdatedTileEntity((FrameBlockTile)tileEntity);
            level.m_151523_((BlockEntity)newTile);
            player.m_5661_((Component)Component.m_237115_((String)"message.blockcarpentry.converting_outdated_block"), true);
        }
    }

    private boolean lockRedstoneSignal(BlockState state, Level level, BlockPos pos, Player player, ItemStack itemStack) {
        if (itemStack.m_41720_() == Items.f_42451_) {
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof LockableFrameTile) {
                LockableFrameTile doorTileEntity = (LockableFrameTile)tileEntity;
                if (doorTileEntity.canBeOpenedByRedstoneSignal()) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.blockcarpentry.redstone_off"), true);
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"message.blockcarpentry.redstone_on"), true);
                }
                doorTileEntity.setCanBeOpenedByRedstoneSignal(!doorTileEntity.canBeOpenedByRedstoneSignal());
            } else {
                this.convertOutdatedTile(state, level, pos, player);
            }
            return true;
        }
        return false;
    }

    private boolean lockOpenClose(BlockState state, Level level, BlockPos pos, Player player, ItemStack itemStack) {
        if (itemStack.m_41720_() == Items.f_42416_) {
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof LockableFrameTile) {
                LockableFrameTile doorTileEntity = (LockableFrameTile)tileEntity;
                if (doorTileEntity.canBeOpenedByPlayers()) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.blockcarpentry.lock"), true);
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"message.blockcarpentry.unlock"), true);
                }
                doorTileEntity.setCanBeOpenedByPlayers(!doorTileEntity.canBeOpenedByPlayers());
            } else {
                this.convertOutdatedTile(state, level, pos, player);
            }
            return true;
        }
        return false;
    }

    public void m_6810_(BlockState state, Level levelIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            this.dropContainedBlock(levelIn, pos);
            super.m_6810_(state, levelIn, pos, newState, isMoving);
        }
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return IFrameBlock.getLightEmission(state);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos pos2, boolean update) {
        LockableFrameTile doorTileEntity;
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity instanceof LockableFrameTile && (doorTileEntity = (LockableFrameTile)tileEntity).canBeOpenedByRedstoneSignal()) {
            super.m_6861_(state, level, pos, block, pos2, update);
        }
    }

    @Override
    public boolean isCorrectTileInstance(BlockEntity blockEntity) {
        return blockEntity instanceof LockableFrameTile;
    }

    @Override
    public void fillBlockEntity(Level levelIn, BlockPos pos, BlockState state, BlockState handBlock, BlockEntity blockEntity) {
        LockableFrameTile frameBlockEntity = (LockableFrameTile)blockEntity;
        frameBlockEntity.clear();
        frameBlockEntity.setMimic(handBlock);
        levelIn.m_7731_(pos, (BlockState)state.m_61124_((Property)CONTAINS_BLOCK, (Comparable)Boolean.TRUE), 2);
    }
}

