/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.tileentity;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mod.pianomanu.blockcarpentry.setup.Registration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DaylightDetectorFrameTileEntity
extends BlockEntity {
    public static final ModelProperty<BlockState> MIMIC = new ModelProperty();
    public static final ModelProperty<Integer> TEXTURE = new ModelProperty();
    public static final ModelProperty<Integer> DESIGN = new ModelProperty();
    public static final ModelProperty<Integer> DESIGN_TEXTURE = new ModelProperty();
    public static final ModelProperty<Integer> GLASS_COLOR = new ModelProperty();
    public static final ModelProperty<Integer> OVERLAY = new ModelProperty();
    public static final ModelProperty<Integer> ROTATION = new ModelProperty();
    public static final ModelProperty<Boolean> NORTH_VISIBLE = new ModelProperty();
    public static final ModelProperty<Boolean> EAST_VISIBLE = new ModelProperty();
    public static final ModelProperty<Boolean> SOUTH_VISIBLE = new ModelProperty();
    public static final ModelProperty<Boolean> WEST_VISIBLE = new ModelProperty();
    public static final ModelProperty<Boolean> UP_VISIBLE = new ModelProperty();
    public static final ModelProperty<Boolean> DOWN_VISIBLE = new ModelProperty();
    private static final Logger LOGGER = LogManager.getLogger();
    public final int maxTextures = 8;
    public final int maxDesignTextures = 4;
    public final int maxDesigns = 4;
    private BlockState mimic;
    private Integer texture = 0;
    private Integer design = 0;
    private Integer designTexture = 0;
    private Integer glassColor = 0;
    private Integer overlay = 0;
    private Integer rotation = 0;
    private Boolean northVisible = true;
    private Boolean eastVisible = true;
    private Boolean southVisible = true;
    private Boolean westVisible = true;
    private Boolean upVisible = true;
    private Boolean downVisible = true;

    public DaylightDetectorFrameTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.DAYLIGHT_DETECTOR_FRAME_TILE.get(), pos, state);
    }

    private static Integer readInteger(CompoundTag tag) {
        if (!tag.m_128425_("number", 8)) {
            return 0;
        }
        try {
            return Integer.parseInt(tag.m_128461_("number"));
        }
        catch (NumberFormatException e) {
            LOGGER.error("Not a valid Number Format: " + tag.m_128461_("number"));
            return 0;
        }
    }

    private static CompoundTag writeInteger(Integer tag) {
        CompoundTag compoundnbt = new CompoundTag();
        compoundnbt.m_128359_("number", tag.toString());
        return compoundnbt;
    }

    public BlockState getMimic() {
        return this.mimic;
    }

    public void setMimic(BlockState mimic) {
        this.mimic = mimic;
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public Integer getDesign() {
        return this.design;
    }

    public void setDesign(Integer design) {
        this.design = design;
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public Integer getDesignTexture() {
        return this.designTexture;
    }

    public void setDesignTexture(Integer designTexture) {
        this.designTexture = designTexture;
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public Integer getTexture() {
        return this.texture;
    }

    public void setTexture(Integer texture) {
        this.texture = texture;
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public Integer getGlassColor() {
        return this.glassColor;
    }

    public void setGlassColor(Integer colorNumber) {
        this.glassColor = colorNumber;
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public Integer getRotation() {
        return this.rotation;
    }

    public void setRotation(Integer rotation) {
        this.rotation = rotation;
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    public void setVisibileSides(Direction dir, boolean isVisible) {
        switch (dir) {
            case DOWN: {
                this.downVisible = isVisible;
                break;
            }
            case UP: {
                this.upVisible = isVisible;
                break;
            }
            case NORTH: {
                this.northVisible = isVisible;
                break;
            }
            case WEST: {
                this.westVisible = isVisible;
                break;
            }
            case SOUTH: {
                this.southVisible = isVisible;
                break;
            }
            case EAST: {
                this.eastVisible = isVisible;
                break;
            }
        }
    }

    public List<Direction> getVisibleSides() {
        ArrayList<Direction> dir = new ArrayList<Direction>();
        if (this.northVisible.booleanValue()) {
            dir.add(Direction.NORTH);
        }
        if (this.eastVisible.booleanValue()) {
            dir.add(Direction.EAST);
        }
        if (this.southVisible.booleanValue()) {
            dir.add(Direction.SOUTH);
        }
        if (this.westVisible.booleanValue()) {
            dir.add(Direction.WEST);
        }
        if (this.upVisible.booleanValue()) {
            dir.add(Direction.UP);
        }
        if (this.downVisible.booleanValue()) {
            dir.add(Direction.DOWN);
        }
        return dir;
    }

    public Integer getOverlay() {
        return this.overlay;
    }

    public void setOverlay(Integer overlay) {
        this.overlay = overlay;
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        if (this.mimic != null) {
            tag.m_128365_("mimic", (Tag)NbtUtils.m_129202_((BlockState)this.mimic));
        }
        if (this.texture != null) {
            tag.m_128365_("texture", (Tag)DaylightDetectorFrameTileEntity.writeInteger(this.texture));
        }
        if (this.design != null) {
            tag.m_128365_("design", (Tag)DaylightDetectorFrameTileEntity.writeInteger(this.design));
        }
        if (this.designTexture != null) {
            tag.m_128365_("design_texture", (Tag)DaylightDetectorFrameTileEntity.writeInteger(this.designTexture));
        }
        if (this.glassColor != null) {
            tag.m_128365_("glass_color", (Tag)DaylightDetectorFrameTileEntity.writeInteger(this.glassColor));
        }
        if (this.overlay != null) {
            tag.m_128365_("overlay", (Tag)DaylightDetectorFrameTileEntity.writeInteger(this.overlay));
        }
        if (this.rotation != null) {
            tag.m_128365_("rotation", (Tag)DaylightDetectorFrameTileEntity.writeInteger(this.rotation));
        }
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        BlockState oldMimic = this.mimic;
        Integer oldTexture = this.texture;
        Integer oldDesign = this.design;
        Integer oldDesignTexture = this.designTexture;
        Integer oldGlassColor = this.glassColor;
        Integer oldOverlay = this.overlay;
        Integer oldRotation = this.rotation;
        CompoundTag tag = pkt.m_131708_();
        if (tag.m_128441_("mimic")) {
            this.mimic = NbtUtils.m_129241_((CompoundTag)tag.m_128469_("mimic"));
            if (!Objects.equals(oldMimic, this.mimic)) {
                this.requestModelDataUpdate();
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
        if (tag.m_128441_("texture")) {
            this.texture = DaylightDetectorFrameTileEntity.readInteger(tag.m_128469_("texture"));
            if (!Objects.equals(oldTexture, this.texture)) {
                this.requestModelDataUpdate();
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
        if (tag.m_128441_("design")) {
            this.design = DaylightDetectorFrameTileEntity.readInteger(tag.m_128469_("design"));
            if (!Objects.equals(oldDesign, this.design)) {
                this.requestModelDataUpdate();
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
        if (tag.m_128441_("design_texture")) {
            this.designTexture = DaylightDetectorFrameTileEntity.readInteger(tag.m_128469_("design_texture"));
            if (!Objects.equals(oldDesignTexture, this.designTexture)) {
                this.requestModelDataUpdate();
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
        if (tag.m_128441_("glass_color")) {
            this.glassColor = DaylightDetectorFrameTileEntity.readInteger(tag.m_128469_("glass_color"));
            if (!Objects.equals(oldGlassColor, this.glassColor)) {
                this.requestModelDataUpdate();
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
        if (tag.m_128441_("overlay")) {
            this.overlay = DaylightDetectorFrameTileEntity.readInteger(tag.m_128469_("overlay"));
            if (!Objects.equals(oldOverlay, this.overlay)) {
                this.requestModelDataUpdate();
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
        if (tag.m_128441_("rotation")) {
            this.rotation = DaylightDetectorFrameTileEntity.readInteger(tag.m_128469_("rotation"));
            if (!Objects.equals(oldRotation, this.rotation)) {
                this.requestModelDataUpdate();
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }

    @Nonnull
    public ModelData getModelData() {
        return ModelData.builder().with(MIMIC, (Object)this.mimic).with(TEXTURE, (Object)this.texture).with(DESIGN, (Object)this.design).with(DESIGN_TEXTURE, (Object)this.designTexture).with(GLASS_COLOR, (Object)this.glassColor).with(OVERLAY, (Object)this.overlay).with(ROTATION, (Object)this.rotation).with(NORTH_VISIBLE, (Object)this.northVisible).with(EAST_VISIBLE, (Object)this.eastVisible).with(SOUTH_VISIBLE, (Object)this.southVisible).with(WEST_VISIBLE, (Object)this.westVisible).with(UP_VISIBLE, (Object)this.upVisible).with(DOWN_VISIBLE, (Object)this.downVisible).build();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("mimic")) {
            this.mimic = NbtUtils.m_129241_((CompoundTag)tag.m_128469_("mimic"));
        }
        if (tag.m_128441_("texture")) {
            this.texture = DaylightDetectorFrameTileEntity.readInteger(tag.m_128469_("texture"));
        }
        if (tag.m_128441_("design")) {
            this.design = DaylightDetectorFrameTileEntity.readInteger(tag.m_128469_("design"));
        }
        if (tag.m_128441_("design_texture")) {
            this.designTexture = DaylightDetectorFrameTileEntity.readInteger(tag.m_128469_("design_texture"));
        }
        if (tag.m_128441_("glass_color")) {
            this.glassColor = DaylightDetectorFrameTileEntity.readInteger(tag.m_128469_("glass_color"));
        }
        if (tag.m_128441_("overlay")) {
            this.overlay = DaylightDetectorFrameTileEntity.readInteger(tag.m_128469_("overlay"));
        }
        if (tag.m_128441_("rotation")) {
            this.rotation = DaylightDetectorFrameTileEntity.readInteger(tag.m_128469_("rotation"));
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.mimic != null) {
            tag.m_128365_("mimic", (Tag)NbtUtils.m_129202_((BlockState)this.mimic));
        }
        if (this.texture != null) {
            tag.m_128365_("texture", (Tag)DaylightDetectorFrameTileEntity.writeInteger(this.texture));
        }
        if (this.design != null) {
            tag.m_128365_("design", (Tag)DaylightDetectorFrameTileEntity.writeInteger(this.design));
        }
        if (this.designTexture != null) {
            tag.m_128365_("design_texture", (Tag)DaylightDetectorFrameTileEntity.writeInteger(this.designTexture));
        }
        if (this.glassColor != null) {
            tag.m_128365_("glass_color", (Tag)DaylightDetectorFrameTileEntity.writeInteger(this.glassColor));
        }
        if (this.overlay != null) {
            tag.m_128365_("overlay", (Tag)DaylightDetectorFrameTileEntity.writeInteger(this.overlay));
        }
        if (this.rotation != null) {
            tag.m_128365_("rotation", (Tag)DaylightDetectorFrameTileEntity.writeInteger(this.rotation));
        }
    }

    public void clear() {
        this.setMimic(null);
        this.setDesign(0);
        this.setDesign(0);
        this.setDesign(0);
        this.setGlassColor(0);
        this.setOverlay(0);
        this.setRotation(0);
    }
}

