/*
 * Decompiled with CFR 0.152.
 */
package mod.pianomanu.blockcarpentry.util;

import java.util.ArrayList;
import java.util.Objects;
import mod.pianomanu.blockcarpentry.block.BedFrameBlock;
import mod.pianomanu.blockcarpentry.block.SixWaySlabFrameBlock;
import mod.pianomanu.blockcarpentry.setup.Registration;
import mod.pianomanu.blockcarpentry.tileentity.BedFrameTile;
import mod.pianomanu.blockcarpentry.tileentity.ChestFrameBlockEntity;
import mod.pianomanu.blockcarpentry.tileentity.DaylightDetectorFrameTileEntity;
import mod.pianomanu.blockcarpentry.tileentity.FrameBlockTile;
import mod.pianomanu.blockcarpentry.tileentity.TwoBlocksFrameBlockTile;
import mod.pianomanu.blockcarpentry.util.BCBlockStateProperties;
import mod.pianomanu.blockcarpentry.util.BlockAppearanceHelperItems;
import mod.pianomanu.blockcarpentry.util.Tags;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockAppearanceHelper {
    public static boolean setLightLevel(ItemStack itemStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand) {
        if (itemStack.m_41720_() == Items.f_42525_ && (Integer)state.m_61143_((Property)BCBlockStateProperties.LIGHT_LEVEL) < 13) {
            int count = player.m_21120_(hand).m_41613_();
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BCBlockStateProperties.LIGHT_LEVEL, (Comparable)Integer.valueOf(state.m_60734_().getLightEmission(state, (BlockGetter)level, pos) + 3)), 3);
            player.m_21120_(hand).m_41764_(count - 1);
            player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.light_level", (Object[])new Object[]{(Integer)state.m_61143_((Property)BCBlockStateProperties.LIGHT_LEVEL) + 3}), true);
            return true;
        }
        if ((itemStack.m_41720_() == Items.f_42413_ || itemStack.m_41720_() == Items.f_42414_) && (Integer)state.m_61143_((Property)BCBlockStateProperties.LIGHT_LEVEL) < 15) {
            int count = player.m_21120_(hand).m_41613_();
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BCBlockStateProperties.LIGHT_LEVEL, (Comparable)Integer.valueOf(state.m_60734_().getLightEmission(state, (BlockGetter)level, pos) + 1)), 3);
            player.m_21120_(hand).m_41764_(count - 1);
            player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.light_level", (Object[])new Object[]{(Integer)state.m_61143_((Property)BCBlockStateProperties.LIGHT_LEVEL) + 1}), true);
            return true;
        }
        if (itemStack.m_41720_() == Items.f_42525_ && (Integer)state.m_61143_((Property)BCBlockStateProperties.LIGHT_LEVEL) >= 13) {
            player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.light_level", (Object[])new Object[]{state.m_61143_((Property)BCBlockStateProperties.LIGHT_LEVEL)}), true);
        }
        if ((itemStack.m_41720_() == Items.f_42413_ || itemStack.m_41720_() == Items.f_42414_) && (Integer)state.m_61143_((Property)BCBlockStateProperties.LIGHT_LEVEL) == 15) {
            player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.light_level", (Object[])new Object[]{state.m_61143_((Property)BCBlockStateProperties.LIGHT_LEVEL)}), true);
        }
        return false;
    }

    public static boolean setTexture(ItemStack itemStack, BlockState state, Level level, Player player, BlockPos pos) {
        if (itemStack.m_41720_() == Registration.TEXTURE_WRENCH.get() && !player.m_6047_() && ((Boolean)state.m_61143_((Property)BCBlockStateProperties.CONTAINS_BLOCK)).booleanValue() && Tags.isFrameBlock(state.m_60734_())) {
            Object fte;
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof FrameBlockTile) {
                fte = (FrameBlockTile)tileEntity;
                if (fte.getTexture() < 5) {
                    fte.setTexture(fte.getTexture() + 1);
                } else {
                    fte.setTexture(0);
                }
                player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.texture", (Object[])new Object[]{fte.getTexture()}), true);
            }
            if (tileEntity instanceof BedFrameTile) {
                fte = (BedFrameTile)tileEntity;
                if (fte.getTexture() < 5) {
                    fte.setTexture(fte.getTexture() + 1);
                } else {
                    fte.setTexture(0);
                }
                player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.texture", (Object[])new Object[]{fte.getTexture()}), true);
            }
            if (tileEntity instanceof ChestFrameBlockEntity) {
                fte = (ChestFrameBlockEntity)tileEntity;
                if (fte.getTexture() < 5) {
                    fte.setTexture(fte.getTexture() + 1);
                } else {
                    fte.setTexture(0);
                }
                player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.texture", (Object[])new Object[]{fte.getTexture()}), true);
            }
            if (tileEntity instanceof TwoBlocksFrameBlockTile) {
                fte = (TwoBlocksFrameBlockTile)tileEntity;
                if (!((Boolean)state.m_61143_((Property)SixWaySlabFrameBlock.DOUBLE_SLAB)).booleanValue()) {
                    if (fte.getTexture_1() < 5) {
                        fte.setTexture_1(fte.getTexture_1() + 1);
                    } else {
                        fte.setTexture_1(0);
                    }
                    player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.texture", (Object[])new Object[]{fte.getTexture_1()}), true);
                } else {
                    if (fte.getTexture_2() < 5) {
                        fte.setTexture_2(fte.getTexture_2() + 1);
                    } else {
                        fte.setTexture_2(0);
                    }
                    player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.texture", (Object[])new Object[]{fte.getTexture_2()}), true);
                }
            }
            if (tileEntity instanceof DaylightDetectorFrameTileEntity) {
                fte = (DaylightDetectorFrameTileEntity)tileEntity;
                if (fte.getTexture() < 5) {
                    fte.setTexture(fte.getTexture() + 1);
                } else {
                    fte.setTexture(0);
                }
                player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.texture", (Object[])new Object[]{fte.getTexture()}), true);
            }
            return true;
        }
        return false;
    }

    public static boolean setDesign(Level level, BlockPos pos, Player player, ItemStack itemStack) {
        if (itemStack.m_41720_() == Registration.CHISEL.get() && !player.m_6047_()) {
            Object fte;
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof FrameBlockTile) {
                fte = (FrameBlockTile)tileEntity;
                int n = ((FrameBlockTile)((Object)fte)).getDesign();
                Objects.requireNonNull(fte);
                if (n < 4) {
                    ((FrameBlockTile)((Object)fte)).setDesign(((FrameBlockTile)((Object)fte)).getDesign() + 1);
                } else {
                    ((FrameBlockTile)((Object)fte)).setDesign(0);
                }
                player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.design", (Object[])new Object[]{((FrameBlockTile)((Object)fte)).getDesign()}), true);
            }
            if (tileEntity instanceof BedFrameTile) {
                fte = (BedFrameTile)tileEntity;
                int n = ((BedFrameTile)((Object)fte)).getDesign();
                Objects.requireNonNull(fte);
                if (n < 4) {
                    ((BedFrameTile)((Object)fte)).setDesign(((BedFrameTile)((Object)fte)).getDesign() + 1);
                } else {
                    ((BedFrameTile)((Object)fte)).setDesign(0);
                }
                player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.design", (Object[])new Object[]{((BedFrameTile)((Object)fte)).getDesign()}), true);
            }
            if (tileEntity instanceof ChestFrameBlockEntity) {
                fte = (ChestFrameBlockEntity)tileEntity;
                int n = ((ChestFrameBlockEntity)((Object)fte)).getDesign();
                Objects.requireNonNull(fte);
                if (n < 4) {
                    ((ChestFrameBlockEntity)((Object)fte)).setDesign(((ChestFrameBlockEntity)((Object)fte)).getDesign() + 1);
                } else {
                    ((ChestFrameBlockEntity)((Object)fte)).setDesign(0);
                }
                player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.design", (Object[])new Object[]{((ChestFrameBlockEntity)((Object)fte)).getDesign()}), true);
            }
            if (tileEntity instanceof TwoBlocksFrameBlockTile) {
                fte = (TwoBlocksFrameBlockTile)tileEntity;
                BlockState state = level.m_8055_(pos);
                if (!((Boolean)state.m_61143_((Property)SixWaySlabFrameBlock.DOUBLE_SLAB)).booleanValue()) {
                    int n = ((TwoBlocksFrameBlockTile)((Object)fte)).getDesign_1();
                    Objects.requireNonNull(fte);
                    if (n < 4) {
                        ((TwoBlocksFrameBlockTile)((Object)fte)).setDesign_1(((TwoBlocksFrameBlockTile)((Object)fte)).getDesign_1() + 1);
                    } else {
                        ((TwoBlocksFrameBlockTile)((Object)fte)).setDesign_1(0);
                    }
                    player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.design", (Object[])new Object[]{((TwoBlocksFrameBlockTile)((Object)fte)).getDesign_1()}), true);
                } else {
                    int n = ((TwoBlocksFrameBlockTile)((Object)fte)).getDesign_2();
                    Objects.requireNonNull(fte);
                    if (n < 4) {
                        ((TwoBlocksFrameBlockTile)((Object)fte)).setDesign_2(((TwoBlocksFrameBlockTile)((Object)fte)).getDesign_2() + 1);
                    } else {
                        ((TwoBlocksFrameBlockTile)((Object)fte)).setDesign_2(0);
                    }
                    player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.design", (Object[])new Object[]{((TwoBlocksFrameBlockTile)((Object)fte)).getDesign_2()}), true);
                }
            }
            if (tileEntity instanceof DaylightDetectorFrameTileEntity) {
                fte = (DaylightDetectorFrameTileEntity)tileEntity;
                int n = ((DaylightDetectorFrameTileEntity)((Object)fte)).getDesign();
                Objects.requireNonNull(fte);
                if (n < 4) {
                    ((DaylightDetectorFrameTileEntity)((Object)fte)).setDesign(((DaylightDetectorFrameTileEntity)((Object)fte)).getDesign() + 1);
                } else {
                    ((DaylightDetectorFrameTileEntity)((Object)fte)).setDesign(0);
                }
                player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.design", (Object[])new Object[]{((DaylightDetectorFrameTileEntity)((Object)fte)).getDesign()}), true);
            }
            return true;
        }
        return false;
    }

    public static boolean setDesignTexture(Level level, BlockPos pos, Player player, ItemStack itemStack) {
        if (itemStack.m_41720_() == Registration.PAINTBRUSH.get() && !player.m_6047_()) {
            Object fte;
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof FrameBlockTile) {
                fte = (FrameBlockTile)tileEntity;
                int n = fte.getDesignTexture();
                Objects.requireNonNull(fte);
                if (n < 4) {
                    fte.setDesignTexture(fte.getDesignTexture() + 1);
                } else {
                    fte.setDesignTexture(0);
                }
                player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.design_texture", (Object[])new Object[]{fte.getDesignTexture()}), true);
            }
            if (tileEntity instanceof BedFrameTile) {
                fte = (BedFrameTile)tileEntity;
                if (fte.getDesignTexture() < 7) {
                    fte.setDesignTexture(fte.getDesignTexture() + 1);
                } else {
                    fte.setDesignTexture(0);
                }
                player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.design_texture", (Object[])new Object[]{fte.getDesignTexture()}), true);
            }
            if (tileEntity instanceof ChestFrameBlockEntity) {
                fte = (ChestFrameBlockEntity)tileEntity;
                int n = fte.getDesignTexture();
                Objects.requireNonNull(fte);
                if (n < 4) {
                    fte.setDesignTexture(fte.getDesignTexture() + 1);
                } else {
                    fte.setDesignTexture(0);
                }
                player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.design_texture", (Object[])new Object[]{fte.getDesignTexture()}), true);
            }
            return true;
        }
        return false;
    }

    public static boolean setColor(Level level, BlockPos pos, Player player, InteractionHand hand) {
        if (BlockAppearanceHelperItems.isDyeItem(player.m_21120_(hand).m_41720_())) {
            BlockEntity fte;
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof FrameBlockTile) {
                fte = (FrameBlockTile)tileEntity;
                fte.setGlassColor(BlockAppearanceHelper.dyeItemToInt(player.m_21120_(hand).m_41720_()) + 1);
            }
            if (tileEntity instanceof DaylightDetectorFrameTileEntity) {
                fte = (DaylightDetectorFrameTileEntity)tileEntity;
                fte.setGlassColor(BlockAppearanceHelper.dyeItemToInt(player.m_21120_(hand).m_41720_()) + 1);
            }
            if (tileEntity instanceof BedFrameTile) {
                fte = (BedFrameTile)tileEntity;
                if (level.m_8055_(pos).m_61143_(BedFrameBlock.PART) == BedPart.FOOT) {
                    fte.setBlanketColor(BlockAppearanceHelper.dyeItemToInt(player.m_21120_(hand).m_41720_()));
                }
                if (level.m_8055_(pos).m_61143_(BedFrameBlock.PART) == BedPart.HEAD) {
                    fte.setPillowColor(BlockAppearanceHelper.dyeItemToInt(player.m_21120_(hand).m_41720_()));
                }
            }
            return true;
        }
        return false;
    }

    public static Integer dyeItemToInt(Item item) {
        ArrayList<Item> colors = new ArrayList<Item>(BlockAppearanceHelperItems.getDyeItems());
        if (colors.contains(item)) {
            return colors.indexOf(item);
        }
        return 0;
    }

    public static boolean setOverlay(Level level, BlockPos pos, Player player, ItemStack itemStack) {
        if (itemStack.m_41720_().equals(Items.f_41864_)) {
            BlockEntity fte;
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof FrameBlockTile) {
                fte = (FrameBlockTile)tileEntity;
                if (fte.getOverlay() == 1) {
                    fte.setOverlay(2);
                    player.m_5661_((Component)Component.m_237115_((String)"message.blockcarpentry.grass_overlay_large"), true);
                } else {
                    fte.setOverlay(1);
                    player.m_5661_((Component)Component.m_237115_((String)"message.blockcarpentry.grass_overlay"), true);
                }
            }
            if (tileEntity instanceof TwoBlocksFrameBlockTile) {
                fte = (TwoBlocksFrameBlockTile)tileEntity;
                BlockState state = level.m_8055_(pos);
                if (!((Boolean)state.m_61143_((Property)SixWaySlabFrameBlock.DOUBLE_SLAB)).booleanValue()) {
                    if (fte.getOverlay_1() == 1) {
                        fte.setOverlay_1(2);
                        player.m_5661_((Component)Component.m_237115_((String)"message.blockcarpentry.grass_overlay_large"), true);
                    } else {
                        fte.setOverlay_1(1);
                        player.m_5661_((Component)Component.m_237115_((String)"message.blockcarpentry.grass_overlay"), true);
                    }
                } else if (fte.getOverlay_2() == 1) {
                    fte.setOverlay_2(2);
                    player.m_5661_((Component)Component.m_237115_((String)"message.blockcarpentry.grass_overlay_large"), true);
                } else {
                    fte.setOverlay_2(1);
                    player.m_5661_((Component)Component.m_237115_((String)"message.blockcarpentry.grass_overlay"), true);
                }
            }
            return true;
        }
        if (itemStack.m_41720_().equals(Items.f_42452_)) {
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof FrameBlockTile) {
                FrameBlockTile fte = (FrameBlockTile)tileEntity;
                if (fte.getOverlay() == 3) {
                    fte.setOverlay(4);
                    player.m_5661_((Component)Component.m_237115_((String)"message.blockcarpentry.snow_overlay_small"), true);
                } else {
                    fte.setOverlay(3);
                    player.m_5661_((Component)Component.m_237115_((String)"message.blockcarpentry.snow_overlay"), true);
                }
            }
            if (tileEntity instanceof TwoBlocksFrameBlockTile) {
                BlockState state = level.m_8055_(pos);
                if (!((Boolean)state.m_61143_((Property)SixWaySlabFrameBlock.DOUBLE_SLAB)).booleanValue()) {
                    TwoBlocksFrameBlockTile fte = (TwoBlocksFrameBlockTile)tileEntity;
                    if (fte.getOverlay_1() == 3) {
                        fte.setOverlay_1(4);
                        player.m_5661_((Component)Component.m_237115_((String)"message.blockcarpentry.snow_overlay_small"), true);
                    } else {
                        fte.setOverlay_1(3);
                        player.m_5661_((Component)Component.m_237115_((String)"message.blockcarpentry.snow_overlay"), true);
                    }
                } else {
                    TwoBlocksFrameBlockTile fte = (TwoBlocksFrameBlockTile)tileEntity;
                    if (fte.getOverlay_2() == 3) {
                        fte.setOverlay_2(4);
                        player.m_5661_((Component)Component.m_237115_((String)"message.blockcarpentry.snow_overlay_small"), true);
                    } else {
                        fte.setOverlay_2(3);
                        player.m_5661_((Component)Component.m_237115_((String)"message.blockcarpentry.snow_overlay"), true);
                    }
                }
            }
            return true;
        }
        if (itemStack.m_41720_().equals(Items.f_42029_)) {
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof FrameBlockTile) {
                FrameBlockTile fte = (FrameBlockTile)tileEntity;
                fte.setOverlay(5);
                player.m_5661_((Component)Component.m_237115_((String)"message.blockcarpentry.vine_overlay"), true);
            }
            if (tileEntity instanceof TwoBlocksFrameBlockTile) {
                BlockState state = level.m_8055_(pos);
                if (!((Boolean)state.m_61143_((Property)SixWaySlabFrameBlock.DOUBLE_SLAB)).booleanValue()) {
                    TwoBlocksFrameBlockTile fte = (TwoBlocksFrameBlockTile)tileEntity;
                    fte.setOverlay_1(5);
                    player.m_5661_((Component)Component.m_237115_((String)"message.blockcarpentry.vine_overlay"), true);
                } else {
                    TwoBlocksFrameBlockTile fte = (TwoBlocksFrameBlockTile)tileEntity;
                    fte.setOverlay_2(5);
                    player.m_5661_((Component)Component.m_237115_((String)"message.blockcarpentry.vine_overlay"), true);
                }
            }
            return true;
        }
        if (itemStack.m_41720_().equals(Items.f_42403_)) {
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof FrameBlockTile) {
                FrameBlockTile fte = (FrameBlockTile)tileEntity;
                if (fte.getOverlay() > 5 && fte.getOverlay() < 10) {
                    fte.setOverlay(fte.getOverlay() + 1);
                } else {
                    fte.setOverlay(6);
                }
                player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.special_overlay", (Object[])new Object[]{fte.getOverlay() - 5}), true);
            }
            if (tileEntity instanceof TwoBlocksFrameBlockTile) {
                BlockState state = level.m_8055_(pos);
                if (!((Boolean)state.m_61143_((Property)SixWaySlabFrameBlock.DOUBLE_SLAB)).booleanValue()) {
                    TwoBlocksFrameBlockTile fte = (TwoBlocksFrameBlockTile)tileEntity;
                    if (fte.getOverlay_1() > 5 && fte.getOverlay_1() < 10) {
                        fte.setOverlay_1(fte.getOverlay_1() + 1);
                    } else {
                        fte.setOverlay_1(6);
                    }
                    player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.special_overlay", (Object[])new Object[]{fte.getOverlay_1() - 5}), true);
                } else {
                    TwoBlocksFrameBlockTile fte = (TwoBlocksFrameBlockTile)tileEntity;
                    if (fte.getOverlay_2() > 5 && fte.getOverlay_2() < 10) {
                        fte.setOverlay_2(fte.getOverlay_2() + 1);
                    } else {
                        fte.setOverlay_2(6);
                    }
                    player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.special_overlay", (Object[])new Object[]{fte.getOverlay_2() - 5}), true);
                }
            }
            return true;
        }
        return false;
    }

    public static int setTintIndex(BlockState state) {
        Block b = state.m_60734_();
        if (b instanceof GrassBlock || b instanceof LeavesBlock) {
            return 1;
        }
        return -1;
    }

    public static boolean setRotation(Level level, BlockPos pos, Player player, ItemStack itemStack) {
        if (itemStack.m_41720_() == Registration.TEXTURE_WRENCH.get() && !player.m_6047_() && Tags.isIllusionBlock(level.m_8055_(pos).m_60734_())) {
            Object fte;
            BlockEntity tileEntity = level.m_7702_(pos);
            if (tileEntity instanceof FrameBlockTile) {
                fte = (FrameBlockTile)tileEntity;
                if (fte.getRotation() < 11) {
                    fte.setRotation(fte.getRotation() + 1);
                } else {
                    fte.setRotation(0);
                }
                player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.rotation", (Object[])new Object[]{fte.getRotation()}), true);
            }
            if (tileEntity instanceof BedFrameTile) {
                fte = (BedFrameTile)tileEntity;
                if (fte.getRotation() < 11) {
                    fte.setRotation(fte.getRotation() + 1);
                } else {
                    fte.setRotation(0);
                }
                player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.rotation", (Object[])new Object[]{fte.getRotation()}), true);
            }
            if (tileEntity instanceof ChestFrameBlockEntity) {
                fte = (ChestFrameBlockEntity)tileEntity;
                if (fte.getRotation() < 11) {
                    fte.setRotation(fte.getRotation() + 1);
                } else {
                    fte.setRotation(0);
                }
                player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.rotation", (Object[])new Object[]{fte.getRotation()}), true);
            }
            if (tileEntity instanceof TwoBlocksFrameBlockTile) {
                fte = (TwoBlocksFrameBlockTile)tileEntity;
                BlockState state = level.m_8055_(pos);
                if (!((Boolean)state.m_61143_((Property)SixWaySlabFrameBlock.DOUBLE_SLAB)).booleanValue()) {
                    if (fte.getRotation_1() < 11) {
                        fte.setRotation_1(fte.getRotation_1() + 1);
                    } else {
                        fte.setRotation_1(0);
                    }
                    player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.rotation", (Object[])new Object[]{fte.getRotation_1()}), true);
                } else {
                    if (fte.getRotation_2() < 11) {
                        fte.setRotation_2(fte.getRotation_2() + 1);
                    } else {
                        fte.setRotation_2(0);
                    }
                    player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.rotation", (Object[])new Object[]{fte.getRotation_2()}), true);
                }
            }
            if (tileEntity instanceof DaylightDetectorFrameTileEntity) {
                fte = (DaylightDetectorFrameTileEntity)tileEntity;
                if (fte.getRotation() < 7) {
                    fte.setRotation(fte.getRotation() + 1);
                } else {
                    fte.setRotation(0);
                }
                player.m_5661_((Component)Component.m_237110_((String)"message.blockcarpentry.rotation", (Object[])new Object[]{fte.getRotation()}), true);
            }
            return true;
        }
        return false;
    }
}

