/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.views;

import com.ldtteam.blockui.Loader;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.views.ScrollingContainer;
import com.ldtteam.blockui.views.ScrollingList;

public class ScrollingListContainer
extends ScrollingContainer {
    private int listElementHeight = 0;

    ScrollingListContainer(ScrollingList owner) {
        super(owner);
    }

    public void refreshElementPanes(ScrollingList.DataProvider dataProvider, PaneParams listNodeParams, int height, int childSpacing) {
        int numElements;
        int n = numElements = dataProvider != null ? dataProvider.getElementCount() : 0;
        if (dataProvider != null) {
            for (int i = 0; i < numElements; ++i) {
                Pane child;
                int childYpos = (childSpacing + this.listElementHeight) * i;
                if (!((double)(childYpos + this.listElementHeight) >= this.scrollY) || !((double)childYpos <= this.scrollY + (double)height)) continue;
                if (i < this.children.size()) {
                    child = (Pane)this.children.get(i);
                } else {
                    child = Loader.createFromPaneParams(listNodeParams, this);
                    if (child == null) continue;
                    if (i == 0) {
                        this.listElementHeight = child.getHeight() + childSpacing;
                    }
                }
                child.setPosition(0, childYpos);
                dataProvider.updateElement(i, child);
            }
        }
        while (this.children.size() > numElements) {
            this.removeChild((Pane)this.children.get(numElements));
        }
        this.setContentHeight(numElements * (this.listElementHeight + childSpacing) - childSpacing);
    }

    public int getListElementIndexByPane(Pane pane) {
        Pane parentPane;
        for (parentPane = pane; parentPane != null && parentPane.getParent() != this; parentPane = parentPane.getParent()) {
        }
        if (parentPane == null) {
            return -1;
        }
        return this.getChildren().indexOf(parentPane);
    }

    @Override
    public Pane findPaneForClick(double mx, double my) {
        Pane child;
        if (this.children.isEmpty() || this.listElementHeight == 0) {
            return null;
        }
        int listElement = (int)my / this.listElementHeight;
        if (listElement < this.children.size() && (child = (Pane)this.children.get(listElement)).canHandleClick(mx, my)) {
            return child;
        }
        return null;
    }
}

