/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.world.modification;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.blueprint.core.Blueprint;
import com.teamabnormals.blueprint.core.util.BiomeUtil;
import com.teamabnormals.blueprint.core.util.modification.selection.ConditionedResourceSelector;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.GsonHelper;

public record ModdedBiomeSlice(ResourceLocation name, int weight, BiomeUtil.ModdedBiomeProvider provider) {
    public static final Codec<ModdedBiomeSlice> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("name").forGetter(slice -> slice.name), (App)ExtraCodecs.f_144628_.fieldOf("weight").forGetter(slice -> slice.weight), (App)BiomeUtil.ModdedBiomeProvider.CODEC.fieldOf("provider").forGetter(slice -> slice.provider)).apply((Applicative)instance, ModdedBiomeSlice::new));
    private static final Pair<ConditionedResourceSelector, ModdedBiomeSlice> SKIPPED = Pair.of((Object)ConditionedResourceSelector.EMPTY, (Object)new ModdedBiomeSlice(new ResourceLocation("blueprint", "skipped"), 0, new BiomeUtil.OriginalModdedBiomeProvider()));

    public static Pair<ConditionedResourceSelector, ModdedBiomeSlice> deserializeWithSelector(ResourceLocation name, JsonElement element, DynamicOps<JsonElement> ops) throws JsonParseException {
        JsonObject object = GsonHelper.m_13918_((JsonElement)element, (String)element.toString());
        ConditionedResourceSelector selector = ConditionedResourceSelector.deserialize("selector", object.get("selector"));
        if (selector == ConditionedResourceSelector.EMPTY) {
            Blueprint.LOGGER.info("Skipped modded biome slice named '" + name + "' as its conditions were not met");
            return SKIPPED;
        }
        DataResult sliceResult = CODEC.decode(ops, (Object)object);
        Optional sliceError = sliceResult.error();
        if (sliceError.isPresent()) {
            throw new JsonParseException(((DataResult.PartialResult)sliceError.get()).message());
        }
        return Pair.of((Object)selector, (Object)((ModdedBiomeSlice)((Pair)sliceResult.result().get()).getFirst()));
    }

    public JsonElement serializeWithSelector(ConditionedResourceSelector selector, DynamicOps<JsonElement> ops) throws JsonParseException {
        JsonObject object = new JsonObject();
        object.add("selector", selector.serialize());
        DataResult result = CODEC.encode((Object)this, ops, (Object)object);
        Optional error = result.error();
        if (error.isPresent()) {
            throw new JsonParseException(((DataResult.PartialResult)error.get()).message());
        }
        return (JsonElement)result.get().left().get();
    }
}

