/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util.modification.selection.selectors;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.teamabnormals.blueprint.core.util.modification.selection.ResourceSelector;
import com.teamabnormals.blueprint.core.util.modification.selection.ResourceSelectorSerializers;
import com.teamabnormals.blueprint.core.util.modification.selection.SelectionSpace;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;

public record RegexResourceSelector(Pattern pattern) implements ResourceSelector<RegexResourceSelector>
{
    @Override
    public List<ResourceLocation> select(SelectionSpace space) {
        ArrayList<ResourceLocation> targetNames = new ArrayList<ResourceLocation>();
        Matcher matcher = this.pattern.matcher("");
        space.forEach(key -> {
            if (matcher.reset(key.toString()).matches()) {
                targetNames.add((ResourceLocation)key);
            }
        });
        return targetNames;
    }

    public Serializer getSerializer() {
        return ResourceSelectorSerializers.REGEX;
    }

    public static final class Serializer
    implements ResourceSelector.Serializer<RegexResourceSelector> {
        @Override
        public JsonElement serialize(RegexResourceSelector selector) {
            return new JsonPrimitive(selector.pattern().pattern());
        }

        @Override
        public RegexResourceSelector deserialize(JsonElement element) {
            return new RegexResourceSelector(Pattern.compile(element.getAsString()));
        }
    }
}

