/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.util.registry;

import com.google.common.collect.Sets;
import com.teamabnormals.blueprint.core.util.registry.AbstractSubRegistryHelper;
import com.teamabnormals.blueprint.core.util.registry.RegistryHelper;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class BlockEntitySubRegistryHelper
extends AbstractSubRegistryHelper<BlockEntityType<?>> {
    public BlockEntitySubRegistryHelper(RegistryHelper parent, DeferredRegister<BlockEntityType<?>> deferredRegister) {
        super(parent, deferredRegister);
    }

    public BlockEntitySubRegistryHelper(RegistryHelper parent) {
        super(parent, DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)parent.getModId()));
    }

    public static Block[] collectBlocks(Class<?> blockClass) {
        return (Block[])ForgeRegistries.BLOCKS.getValues().stream().filter(blockClass::isInstance).toArray(Block[]::new);
    }

    public <T extends BlockEntity> RegistryObject<BlockEntityType<T>> createBlockEntity(String name, BlockEntityType.BlockEntitySupplier<? extends T> blockEntity, Supplier<Block[]> validBlocks) {
        return this.deferredRegister.register(name, () -> new BlockEntityType(blockEntity, (Set)Sets.newHashSet((Object[])((Block[])validBlocks.get())), null));
    }

    public <T extends BlockEntity> RegistryObject<BlockEntityType<T>> createBlockEntity(String name, BlockEntityType.BlockEntitySupplier<? extends T> blockEntity, Class<? extends Block> blockClass) {
        return this.deferredRegister.register(name, () -> new BlockEntityType(blockEntity, (Set)Sets.newHashSet((Object[])BlockEntitySubRegistryHelper.collectBlocks(blockClass)), null));
    }
}

