/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mrh0.buildersaddition.BuildersAddition;
import com.mrh0.buildersaddition.config.Config;
import com.mrh0.buildersaddition.container.SpeakerContainer;
import com.mrh0.buildersaddition.midi.IMidiEvent;
import com.mrh0.buildersaddition.network.PlayNotePacket;
import com.mrh0.buildersaddition.network.UpdateDataPacket;
import com.mrh0.buildersaddition.tileentity.SpeakerTileEntity;
import com.mrh0.buildersaddition.util.Notes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;

public class SpeakerGui
extends AbstractContainerScreen<SpeakerContainer>
implements IMidiEvent {
    private final SpeakerContainer screenContainer;
    private final SpeakerTileEntity te;
    private static final int SIZE = 16;
    private Button connectBtn;
    private Button helpBtn;
    private Button[] btns;

    public SpeakerGui(SpeakerContainer screenContainer, Inventory inv, Component tc) {
        super((AbstractContainerMenu)screenContainer, inv, tc);
        this.screenContainer = screenContainer;
        this.te = (SpeakerTileEntity)Minecraft.m_91087_().f_91073_.m_7702_(screenContainer.pos);
        this.f_97726_ = 384;
        this.f_97727_ = 192;
        if (BuildersAddition.midi != null) {
            BuildersAddition.midi.midiEvent = this;
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        int x = this.f_96543_ / 2;
        int y = this.f_96544_ / 2;
        Button.OnPress p = b -> {};
        this.connectBtn = new Button(x - 48 - 12, y + 96, 96, 20, (Component)Component.m_237115_((String)(BuildersAddition.midi == null ? "container.buildersaddition.speaker.connect" : "container.buildersaddition.speaker.disconnect")), b -> {
            if (BuildersAddition.midi != null) {
                BuildersAddition.midi.midiEvent = BuildersAddition.midi.midiEvent == null ? this : null;
                this.connectBtn.m_93666_((Component)Component.m_237115_((String)(BuildersAddition.midi.midiEvent == null ? "container.buildersaddition.speaker.connect" : "container.buildersaddition.speaker.disconnect")));
            }
        });
        this.helpBtn = new Button(x + 52 - 12, y + 96, 20, 20, (Component)Component.m_237113_((String)"?"), b -> {});
        this.m_142416_((GuiEventListener)this.connectBtn);
        this.m_142416_((GuiEventListener)this.helpBtn);
        this.btns = new Button[16];
        for (int i = 0; i < 16; ++i) {
            this.btns[i] = new Button(x + (i > 7 ? -100 : 4), y + i % 8 * 24 - 96, 96, 20, (Component)Component.m_237115_((String)("note.buildersaddition." + Notes.instrumentNames[i])), p);
            this.m_142416_((GuiEventListener)this.btns[i]);
            this.btns[i].f_93623_ = this.te.isInstrumentActive(i);
        }
    }

    public void m_6574_(Minecraft mc, int w, int h) {
        super.m_6574_(mc, w, h);
    }

    public boolean m_6375_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        for (int i = 0; i < 16; ++i) {
            if (!this.btns[i].m_198029_()) continue;
            this.buttonClicked(this.btns[i], i);
        }
        return super.m_6375_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
    }

    private void buttonClicked(Button b, int id) {
        b.f_93623_ = !b.f_93623_;
        this.sendInstrumentUpdate(this.getEncoded());
    }

    private int getEncoded() {
        int r = 0;
        for (int i = 0; i < 16; ++i) {
            r = (int)((double)r + (this.btns[i].f_93623_ ? Math.pow(2.0, i) : 0.0));
        }
        return r;
    }

    private void sendInstrumentUpdate(int data) {
        if (this.getTE() != null) {
            BuildersAddition.Network.sendToServer((Object)new UpdateDataPacket(this.getTE().m_58899_(), data));
        }
    }

    public void m_6305_(PoseStack stack, int x, int y, float partialTicks) {
        super.m_6305_(stack, x, y, partialTicks);
        if (this.btns == null) {
            return;
        }
        GlStateManager.m_84519_();
        for (int i = 0; i < 16; ++i) {
            if (!this.btns[i].m_198029_()) continue;
            this.m_96602_(stack, (Component)Component.m_237113_((String)("F#" + Notes.octaveNames[i])), x, y);
        }
        if (this.helpBtn.m_5953_((double)x, (double)y)) {
            this.m_96602_(stack, (Component)Component.m_237113_((String)((this.hasDevice() ? "Device Discovered" : "No Device Connected") + ", Midi Input: " + ((Boolean)Config.MIDI_INPUT_ENABLED.get() != false ? "Enabled" : "Disabled"))), x, y);
        }
        this.m_7025_(stack, x, y);
    }

    private boolean hasDevice() {
        if (BuildersAddition.midi != null) {
            return BuildersAddition.midi.hasDevice();
        }
        return false;
    }

    public BlockEntity getTE() {
        return this.te;
    }

    private void sendNote(int note) {
        if (this.getTE() != null) {
            BuildersAddition.Network.sendToServer((Object)new PlayNotePacket(this.getTE().m_58899_(), note));
        }
    }

    @Override
    public void minecraftNote(int note, boolean on) {
        if ((note += 24) < 0) {
            return;
        }
        if (on) {
            this.sendNote(note);
        }
    }

    protected void m_7286_(PoseStack stack, float partialTicks, int x, int y) {
        this.m_7333_(stack);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void m_7027_(PoseStack p_97808_, int p_97809_, int p_97810_) {
    }
}

